#!/bin/sh

# panic: prot 0x3 is not subset of max_prot 0x5
# cpuid = 0
# time = 1586745417
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x47/frame 0xfffffe0015fe8650
# vpanic() at vpanic+0x1c7/frame 0xfffffe0015fe86b0
# panic() at panic+0x43/frame 0xfffffe0015fe8710
# vm_map_insert() at vm_map_insert+0xa11/frame 0xfffffe0015fe87d0
# vm_map_fixed() at vm_map_fixed+0x19c/frame 0xfffffe0015fe8850
# vm_mmap_object() at vm_mmap_object+0x3be/frame 0xfffffe0015fe88e0
# shm_mmap() at shm_mmap+0x2e3/frame 0xfffffe0015fe8980
# kern_mmap_req() at kern_mmap_req+0xa72/frame 0xfffffe0015fe8a70
# sys_mmap() at sys_mmap+0x53/frame 0xfffffe0015fe8ac0
# amd64_syscall() at amd64_syscall+0x236/frame 0xfffffe0015fe8bf0

# Reproduced on r359818
# Fixed by r359892

[ `uname -p` = "i386" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller8.c <<EOF
// http://syzkaller.backtrace.io:8080/report?id=ba93405590ed607e9b2d65025a44ff60dc6c4bcc
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  if (__atomic_load_n(&skip_segv, __ATOMIC_RELAXED) &&
      (addr < prog_start || addr > prog_end)) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  {                                                                            \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    }                                                                          \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
  }

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 3ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  intptr_t res = 0;
  syscall(SYS___getcwd, 0x20000000ul, 0xc7ul);
  res = syscall(SYS_socket, 0x1cul, 3ul, 0x3a);
  if (res != -1)
    r[0] = res;
  res = syscall(SYS_fcntl, r[0], 1ul, -1);
  if (res != -1)
    r[1] = res;
  syscall(SYS_close, r[1]);
  syscall(SYS_mprotect, 0x20000000ul, 0x4000ul, 1ul);
  NONFAILING(memcpy((void*)0x20000000, "./file1\000", 8));
  syscall(SYS_freebsd12_shm_open, 0x20000000ul, 0x200ul, 0ul);
  res = syscall(SYS_freebsd10_pipe, 0x20000080ul);
  if (res != -1)
    NONFAILING(r[2] = *(uint32_t*)0x20000084);
  syscall(SYS_mmap, 0x20d43000ul, 0x200000ul, 3ul, 0x12ul, r[2], 0ul);
  return 0;
}
EOF
mycc -o /tmp/syzkaller8 -Wall -Wextra -O2 /tmp/syzkaller8.c -lpthread ||
    exit 1

(cd /tmp; ./syzkaller8) &
sleep 60
pkill -9 syzkaller8
wait

rm -f /tmp/syzkaller8 /tmp/syzkaller8.c /tmp/syzkaller8.core /tmp/file0
exit 0
