
BRSSL_CFLAGS+= -DNO_STDIO

.include "Makefile.inc"

# for "measured boot"
# loader puts the equivalent of TPM's PCR register into kenv
# this is not as good but *way* simpler than talking to TPM
CFLAGS+= -DVE_PCR_SUPPORT

# sources that only apply to libsa
SRCS+= \
	vectx.c \
	veopen.c \
	vepcr.c \
	verify_file.c \

# Build library with support for the UEFI based authentication
.if ${MK_LOADER_EFI_SECUREBOOT} == "yes"
SRCS+= \
	efi/efi_variables.c \
	efi/efi_init.c

# Add includes required by efi part
CFLAGS+= \
	-I${SRCTOP}/stand/efi/include \
	-I${SRCTOP}/lib/libsecureboot/efi/include \
	-I${SRCTOP}/stand/efi/include/${MACHINE}
.endif

.if ${MK_LOADER_VERIEXEC_PASS_MANIFEST} == "yes"
SRCS+= \
	pass_manifest.c
.endif

# this is the list of paths (relative to a file
# that we need to verify) used to find a signed manifest.
# the signature extensions in VE_SIGNATURE_EXT_LIST
# will be applied to each.
VE_MANIFEST_LIST?= manifest ../manifest

verify_file.o: manifests.h
manifests.h:
	@( echo '/* Autogenerated - DO NOT EDIT!!! */'; echo; \
	echo "static const char *manifest_names[] = {"; \
	echo '${VE_MANIFEST_LIST:@m@"$m",${.newline}@}'; \
	echo 'NULL };' ) > ${.TARGET}

# only add these if set
XCFLAGS.verify_file+= \
	${VE_DEBUG_LEVEL \
	VE_VERBOSE_DEFAULT \
	VE_VERIFY_FLAGS \
	:L:@v@${$v:S,^,-D$v=,}@}

.if !empty(MANIFEST_SKIP_ALWAYS)
XCFLAGS.verify_file+= -DMANIFEST_SKIP_ALWAYS=\"${MANIFEST_SKIP_ALWAYS}\"
.elif !empty(MANIFEST_SKIP)
XCFLAGS.verify_file+= -DMANIFEST_SKIP=\"${MANIFEST_SKIP}\"
.endif
