#!/bin/sh

#
# Copyright (c) 2018 Dell EMC Isilon
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

# Free page shortage test scenario
# No problems seen

. ../default.cfg
[ `id -u` -ne 0 ] && echo "Must be root!" && exit 1

dir=/tmp
odir=`pwd`
cd $dir
sed '1,/^EOF/d' < $odir/$0 > $dir/freepages.c
mycc -o freepages -Wall -Wextra -O0 -g freepages.c || exit 1
rm -f freepages.c
cd $odir

$dir/freepages `sysctl -n hw.usermem`
s=$?
[ -f freepages.core -a $s -eq 0 ] &&
    { ls -l freepages.core; mv freepages.core /tmp; s=1; }

rm -rf $dir/freepages
exit $s
EOF
#include <sys/param.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <machine/atomic.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

static volatile u_int *share;

#define PARALLEL 6
#define RUNTIME (5 * 60)
#define SYNC 0

static void
test(char *s)
{
	time_t start;
	size_t i, len;
	char *cp;

	atomic_add_int(&share[SYNC], 1);
	while (share[SYNC] != PARALLEL)
		;
	start = time(NULL);
	while ((time(NULL) - start) < RUNTIME) {
		len = atol(s) / PARALLEL;
		len = len / 10 * 8;
		if ((cp = mmap(NULL, len, PROT_READ | PROT_WRITE,
		    MAP_ANON | MAP_SHARED, -1, 0)) == MAP_FAILED)
			err(1, "mmap(%zd)", len);
		for (i = 0; i < len; i += PAGE_SIZE)
			cp[i] = 1;
		if (munmap(cp, len) == -1)
			err(1, "unmap");
	}

	_exit(0);
}

int
main(int argc __unused, char *argv[])
{
	pid_t pids[PARALLEL];
	size_t len;
	int e, i, status;

	e = 0;
	len = PAGE_SIZE;
	if ((share = mmap(NULL, len, PROT_READ | PROT_WRITE,
	    MAP_ANON | MAP_SHARED, -1, 0)) == MAP_FAILED)
		err(1, "mmap");

	for (i = 0; i < PARALLEL; i++) {
		if ((pids[i] = fork()) == 0)
			test(argv[1]);
		if (pids[i] == -1)
			err(1, "fork()");
	}
	for (i = 0; i < PARALLEL; i++) {
		if (waitpid(pids[i], &status, 0) == -1)
			err(1, "waitpid(%d)", pids[i]);
		if (status != 0) {
			if (WIFSIGNALED(status))
				fprintf(stderr,
				    "pid %d exit signal %d\n",
				    pids[i], WTERMSIG(status));
		}
		e += status == 0 ? 0 : 1;
	}

	return (e);
}
