#!/bin/sh

# Fatal trap 9: general protection fault while in kernel mode
# cpuid = 5; apic id = 05
# instruction pointer     = 0x20:0xffffffff8237cbac
# stack pointer           = 0x28:0xfffffe01026e4910
# frame pointer           = 0x28:0xfffffe01026e4980
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 45836 (syzkaller25)
# trap number             = 9
# panic: general protection fault
# cpuid = 5
# time = 1601745366
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01026e4620
# vpanic() at vpanic+0x182/frame 0xfffffe01026e4670
# panic() at panic+0x43/frame 0xfffffe01026e46d0
# trap_fatal() at trap_fatal+0x387/frame 0xfffffe01026e4730
# trap() at trap+0xa4/frame 0xfffffe01026e4840
# calltrap() at calltrap+0x8/frame 0xfffffe01026e4840
# --- trap 0x9, rip = 0xffffffff8237cbac, rsp = 0xfffffe01026e4910, rbp = 0xfffffe01026e4980 ---
# sctp_inpcb_bind() at sctp_inpcb_bind+0x3cc/frame 0xfffffe01026e4980
# sctp_connect() at sctp_connect+0x14f/frame 0xfffffe01026e49e0
# soconnectat() at soconnectat+0xd0/frame 0xfffffe01026e4a30
# kern_connectat() at kern_connectat+0xe2/frame 0xfffffe01026e4a90
# sys_connect() at sys_connect+0x75/frame 0xfffffe01026e4ad0
# amd64_syscall() at amd64_syscall+0x14e/frame 0xfffffe01026e4bf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01026e4bf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x8003b0a1a, rsp = 0x7fffdfffdbb8, rbp = 0x7fffdfffdf90 ---
# KDB: enter: panic
# [ thread pid 45836 tid 101772 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10ac846(%rip)
# db> x/s version
# version: FreeBSD 13.0-CURRENT #0 r366401: Sat Oct  3 19:00:37 CEST 2020
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
kldstat -v | grep -q sctp || kldload sctp.ko

cat > /tmp/syzkaller25.c <<EOF
// https://syzkaller.appspot.com/bug?id=2e4fc04b5a5775777770f7244613571ca85da78a
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+77fcf6a9d28f301bc2e5@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS) {
    valid = 1;
  }
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename))
      exit(1);
  }
  closedir(dp);
  if (rmdir(dir))
    exit(1);
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  if (setsid() == -1)
    exit(1);
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  int collide = 0;
again:
  for (call = 0; call < 4; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (collide && (call % 2) == 0)
        break;
      event_timedwait(&th->done, 45);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
  if (!collide) {
    collide = 1;
    goto again;
  }
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 2ul, 5ul, 0x84);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    NONFAILING(*(uint8_t*)0x20000300 = 0x10);
    NONFAILING(*(uint8_t*)0x20000301 = 2);
    NONFAILING(*(uint16_t*)0x20000302 = htobe16(0x4e23 + procid * 4));
    NONFAILING(*(uint32_t*)0x20000304 = htobe32(0));
    NONFAILING(*(uint8_t*)0x20000308 = 0);
    NONFAILING(*(uint8_t*)0x20000309 = 0);
    NONFAILING(*(uint8_t*)0x2000030a = 0);
    NONFAILING(*(uint8_t*)0x2000030b = 0);
    NONFAILING(*(uint8_t*)0x2000030c = 0);
    NONFAILING(*(uint8_t*)0x2000030d = 0);
    NONFAILING(*(uint8_t*)0x2000030e = 0);
    NONFAILING(*(uint8_t*)0x2000030f = 0);
    syscall(SYS_bind, r[0], 0x20000300ul, 0x10ul);
    break;
  case 2:
    NONFAILING(*(uint8_t*)0x20000040 = 0x10);
    NONFAILING(*(uint8_t*)0x20000041 = 2);
    NONFAILING(*(uint16_t*)0x20000042 = htobe16(0x4e23 + procid * 4));
    NONFAILING(*(uint32_t*)0x20000044 = htobe32(0x7f000001));
    NONFAILING(*(uint8_t*)0x20000048 = 0);
    NONFAILING(*(uint8_t*)0x20000049 = 0);
    NONFAILING(*(uint8_t*)0x2000004a = 0);
    NONFAILING(*(uint8_t*)0x2000004b = 0);
    NONFAILING(*(uint8_t*)0x2000004c = 0);
    NONFAILING(*(uint8_t*)0x2000004d = 0);
    NONFAILING(*(uint8_t*)0x2000004e = 0);
    NONFAILING(*(uint8_t*)0x2000004f = 0);
    syscall(SYS_connect, r[0], 0x20000040ul, 0x10ul);
    break;
  case 3:
    NONFAILING(*(uint8_t*)0x20000000 = 0x10);
    NONFAILING(*(uint8_t*)0x20000001 = 2);
    NONFAILING(*(uint16_t*)0x20000002 = htobe16(0x4e23 + procid * 4));
    NONFAILING(*(uint8_t*)0x20000004 = 0xac);
    NONFAILING(*(uint8_t*)0x20000005 = 0x14);
    NONFAILING(*(uint8_t*)0x20000006 = 0 + procid * 1);
    NONFAILING(*(uint8_t*)0x20000007 = 0xaa);
    NONFAILING(*(uint8_t*)0x20000008 = 0);
    NONFAILING(*(uint8_t*)0x20000009 = 0);
    NONFAILING(*(uint8_t*)0x2000000a = 0);
    NONFAILING(*(uint8_t*)0x2000000b = 0);
    NONFAILING(*(uint8_t*)0x2000000c = 0);
    NONFAILING(*(uint8_t*)0x2000000d = 0);
    NONFAILING(*(uint8_t*)0x2000000e = 0);
    NONFAILING(*(uint8_t*)0x2000000f = 0);
    syscall(SYS_connect, r[0], 0x20000000ul, 0x10ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      use_temporary_dir();
      do_sandbox_none();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/syzkaller25 -Wall -Wextra -O0 /tmp/syzkaller25.c -lpthread ||
    exit 1

(cd ../testcases/swap; ./swap -t 1m -i 20 -h > /dev/null 2>&1) &
(cd /tmp; timeout 3m ./syzkaller25)
while pkill swap; do :; done
wait

rm -rf /tmp/syzkaller25 /tmp/syzkaller25.c /tmp/syzkaller.*
exit 0
