#!/bin/sh

# No issues seen (Looks a bit like syzkaller43.sh)

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=cf4c0a08d26692dc8f22b0fcc50db08fd17dd709
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#ifndef SYS_aio_writev
#define SYS_aio_writev 578
#endif

static __thread int clone_ongoing;
static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  if (__atomic_load_n(&clone_ongoing, __ATOMIC_RELAXED) != 0) {
    exit(sig);
  }
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS)
    valid = 1;
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void reset_flags(const char* filename)
{
  struct stat st;
  if (lstat(filename, &st))
    exit(1);
  st.st_flags &= ~(SF_NOUNLINK | UF_NOUNLINK | SF_IMMUTABLE | UF_IMMUTABLE |
                   SF_APPEND | UF_APPEND);
  if (lchflags(filename, st.st_flags))
    exit(1);
}
static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename)) {
      if (errno == EPERM) {
        reset_flags(filename);
        reset_flags(dir);
        if (unlink(filename) == 0)
          continue;
      }
      exit(1);
    }
  }
  closedir(dp);
  while (rmdir(dir)) {
    if (errno == EPERM) {
      reset_flags(dir);
      if (rmdir(dir) == 0)
        break;
    }
    exit(1);
  }
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  int i, call, thread;
  for (call = 0; call < 24; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, /*domain=AF_INET6*/ 0x1cul,
                  /*type=SOCK_STREAM*/ 1ul, /*proto=*/0);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    NONFAILING(*(uint32_t*)0x200000c0 = 0x101);
    syscall(SYS_setsockopt, /*fd=*/r[0], /*level=*/0xffff,
            /*optname=SO_SNDBUF*/ 0x1001, /*optval=*/0x200000c0ul,
            /*optlen=*/4ul);
    break;
  case 2:
    NONFAILING(*(uint8_t*)0x20000140 = 0x1c);
    NONFAILING(*(uint8_t*)0x20000141 = 0x1c);
    NONFAILING(*(uint16_t*)0x20000142 = htobe16(0x4e23));
    NONFAILING(*(uint32_t*)0x20000144 = 0);
    NONFAILING(memset((void*)0x20000148, 0, 16));
    NONFAILING(*(uint32_t*)0x20000158 = 0);
    syscall(SYS_bind, /*fd=*/r[0], /*addr=*/0x20000140ul, /*addrlen=*/0x1cul);
    break;
  case 3:
    NONFAILING(*(uint32_t*)0x20000500 = r[0]);
    NONFAILING(*(uint64_t*)0x20000508 = 0);
    NONFAILING(*(uint64_t*)0x20000510 = 0);
    NONFAILING(*(uint64_t*)0x20000518 = 0);
    NONFAILING(*(uint32_t*)0x20000520 = 4);
    NONFAILING(*(uint32_t*)0x20000524 = 0);
    NONFAILING(*(uint64_t*)0x20000528 = 0);
    NONFAILING(*(uint32_t*)0x20000530 = 0);
    NONFAILING(*(uint32_t*)0x20000534 = 4);
    NONFAILING(*(uint64_t*)0x20000538 = 0x822e);
    NONFAILING(*(uint64_t*)0x20000540 = 0);
    NONFAILING(*(uint64_t*)0x20000548 = 0x20000340);
    NONFAILING(*(uint32_t*)0x20000550 = 0);
    NONFAILING(*(uint32_t*)0x20000554 = 0);
    NONFAILING(*(uint64_t*)0x20000558 = 0xfffffffffffffffe);
    NONFAILING(*(uint64_t*)0x20000560 = 0);
    NONFAILING(*(uint64_t*)0x20000568 = 0x20000380);
    NONFAILING(memcpy((void*)0x20000380, "\x3c\x88\x80", 3));
    syscall(SYS_aio_writev, /*iocb=*/0x20000500ul);
    break;
  case 4:
    NONFAILING(*(uint8_t*)0x20000180 = 0x1c);
    NONFAILING(*(uint8_t*)0x20000181 = 0x1c);
    NONFAILING(*(uint16_t*)0x20000182 = htobe16(0x4e23));
    NONFAILING(*(uint32_t*)0x20000184 = 0);
    NONFAILING(memset((void*)0x20000188, 0, 16));
    NONFAILING(*(uint32_t*)0x20000198 = 0);
    syscall(SYS_connect, /*fd=*/r[0], /*addr=*/0x20000180ul,
            /*addrlen=*/0x1cul);
    break;
  case 5:
    NONFAILING(memset((void*)0x20000200, 14, 1));
    syscall(SYS_sendto, /*fd=*/r[0], /*buf=*/0x20000200ul, /*len=*/0xff66ul,
            /*f=*/0ul, /*addr=*/0ul, /*addrlen=*/0ul);
    break;
  case 6:
    syscall(SYS_sendmsg, /*fd=*/r[0], /*msg=*/0ul, /*f=*/0ul);
    break;
  case 7:
    syscall(SYS_socket, /*domain=AF_INET*/ 2ul, /*type=SOCK_STREAM*/ 1ul,
            /*proto=*/0);
    break;
  case 8:
    res = syscall(SYS_socket, /*domain=*/2ul, /*type=SOCK_SEQPACKET*/ 5ul,
                  /*proto=*/0x84);
    if (res != -1)
      r[1] = res;
    break;
  case 9:
    syscall(SYS_openat, /*fd=*/0xffffffffffffff9cul, /*file=*/0ul,
            /*flags=O_RDWR*/ 2ul, /*mode=*/0ul);
    break;
  case 10:
    syscall(SYS_openat, /*fd=*/0xffffffffffffff9cul, /*file=*/0ul,
            /*flags=O_RDWR*/ 2ul, /*mode=*/0ul);
    break;
  case 11:
    syscall(SYS_socket, /*domain=*/2ul, /*type=SOCK_SEQPACKET*/ 5ul,
            /*proto=*/0x84);
    break;
  case 12:
    syscall(SYS_socket, /*domain=*/0x1cul, /*type=*/1ul, /*proto=*/0);
    break;
  case 13:
    syscall(SYS_shutdown, /*fd=*/-1, /*how=*/0ul);
    break;
  case 14:
    syscall(SYS_shutdown, /*fd=*/-1, /*how=*/0ul);
    break;
  case 15:
    syscall(SYS_sendto, /*fd=*/-1, /*buf=*/0ul, /*len=*/0ul, /*f=*/0ul,
            /*addr=*/0ul, /*addrlen=*/0ul);
    break;
  case 16:
    syscall(SYS_sendmsg, /*fd=*/-1, /*msg=*/0ul, /*f=*/0ul);
    break;
  case 17:
    syscall(SYS_rfork, /*flags=RFMEM|RFTHREAD|RFCFDG|RFNOWAIT*/ 0x3060ul);
    break;
  case 18:
    syscall(SYS_rfork, /*flags=RFMEM|RFTHREAD|RFCFDG|RFNOWAIT*/ 0x3060ul);
    break;
  case 19:
    syscall(SYS_openat, /*fd=*/0xffffff9cul, /*file=*/0ul,
            /*flags=O_APPEND*/ 8ul, /*mode=*/0ul);
    break;
  case 20:
    syscall(SYS_openat, /*fd=*/0xffffff9cul, /*file=*/0ul,
            /*flags=O_APPEND*/ 8ul, /*mode=*/0ul);
    break;
  case 21:
    syscall(SYS_connect, /*fd=*/r[1], /*addr=*/0ul, /*addrlen=*/0ul);
    break;
  case 22:
    res = syscall(SYS_socket, /*domain=*/2ul, /*type=SOCK_STREAM*/ 1ul,
                  /*proto=*/0x84);
    if (res != -1)
      r[2] = res;
    break;
  case 23:
    NONFAILING(*(uint32_t*)0x200001c0 = 0);
    syscall(SYS_getsockopt, /*fd=*/r[2], /*level=*/0x84, /*opt=*/0xc,
            /*val=*/0ul, /*len=*/0x200001c0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x20000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul, /*fd=*/-1,
          /*offset=*/0ul);
  const char* reason;
  (void)reason;
  install_segv_handler();
  use_temporary_dir();
  do_sandbox_none();
  return 0;
}
EOF
mycc -o /tmp/$prog -m32 -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 2m -i 10 -l 100 > /dev/null 2>&1) &
sleep 1
cd /tmp
start=`date +%s`
while [ $((`date +%s` - start)) -lt 120 ]; do
	timeout 3m /tmp/$prog > /dev/null 2>&1
done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core
exit 0
