# Contribution Guidelines for GitHub

## General Contributions to FreeBSD

Please read the guidelines in [Contributing to FreeBSD](https://docs.freebsd.org/en/articles/contributing/)
for all the ways you can contribute to the project, how the project is organized,
how to build different parts of the project, etc. The
[developer's handbook](https://docs.freebsd.org/en/books/developers-handbook/)
is another useful resource.

FreeBSD accepts source code contributions using one of several methods:
- A GitHub [pull request](https://github.com/freebsd/freebsd-src/pulls)
- A code review in [Phabricator](https://reviews.freebsd.org/differential)
- An attachment on a [Bugzilla ticket](https://bugs.freebsd.org)
- Direct access to the [Git repository](https://cgit.freebsd.org/src/)

The preferred method depends on a few factors including the size or scope of
the change.  GitHub pull requests are preferred for relatively straightforward
changes where the contributor already has a GitHub account.

A change should be submitted by only one method.  For example, please do not
open a GitHub pull request and create a Phabricator review for the same change
(unless explicitly requested to do so by a FreeBSD committer). If asked to move
from Github to Phabricator, please close the Github pull request adding the URL
of the Phabricator review as a comment.

## GitHub Pull Requests

The _freebsd-src_ GitHub repository is a **publish-only mirror** of the FreeBSD
_src_ repository.  Pull Requests are accepted for **small, low-risk** changes
that require minimal review and integration effort.

For complex, controversial, security-related, or discussion-heavy changes, use
the normal FreeBSD review and development process (described below) instead.

Submit a Pull Request if your change:

* Fixes a real, specific problem.
* Is small in scope and easy to review.
* Can be committed with **less than ~10 minutes** of additional work.
* Passes all GitHub CI jobs.
* Affects roughly **10 or fewer files** and **fewer than 200 lines of changes**.

### When Not to use a Pull Request

Do NOT submit a Pull Request for:

* Security-related changes.
* Works in progress.
* Changes that require design discussion, or are likely to be controversial.
  (Start a mailing list thread to discuss the change first.)
* Changes needing specialized or cross-subsystem review.
* Large refactors or mechanical tree-wide changes.
* Changes generated by AI tools without substantial human review and validation.

### Preparing your Pull Request

Before submitting, ensure:

#### Code Quality

* The changes follow FreeBSD's style guide. See [Style](#Style).
* _tools/build/checkstyle9.pl_ is run and:
  * All errors are fixed, **or**
  * Exceptions are documented in the PR.
* No trailing whitespace is introduced.
* Changes compile and work before submitting.
* Test results (including Kyua tests) are unchanged, unless intentionally
  modified.
* Bug fixes include new test cases, when possible.

#### Commit Structure

* Each logical change is a **separate commit**.
* Fixup commits are squashed into the commit they correct.
* Each commit is suitable for direct inclusion in the FreeBSD's repository.
* Pull Request scope must remain stable during review.  If feedback expands
  scope, create a new Pull Request.
* Rebase your chages (and update with a forced push) when incorporating review
  feedback, rather than using a merge commit.

#### Commit Messages

Each commit must:

* Follow the [commit log message guide](https://docs.freebsd.org/en/articles/committers-guide/#commit-log-message).
* Include one ore more `Signed-off-by:` trailers certifying [Developer Certificate of Origin](https://developercertificate.org/).
* Include `PR: \<bugnumber\>` if fixing a Bugzilla Problem Report.
* Include the URL of a related code review, if applicable.
  (Avoid opening both Phabricator/Differential reviews and GitHub Pull Requests
  for the same change.)

#### Author Information

* Commits use your name and valid email address.
* GitHub-generated `users.noreply.github.com` addresses cannot be used.
* See [Author Name and Email](#author-name-and-email) for details.

### Contributor Responsibilities

* Monitor your Pull Request and respond to review feedback promptly.
* Pull Requests may be closed if there is no response for **one month**.

### Additional Requirements for FreeBSD Committers

* Committers submitting Pull Requests are for pushing their changes to the tree
  (including obtaining any required approvals).
* Pull Requests opened by FreeBSD committers may be closed after one month
  unless there is a strong reason to keep them open.

### Quality Expectations

Low quality submimssions will be rejected.  This includes submissions generated
by AI tools that lack sufficient validation, testing, or understanding by the
submitter.

A pull request may be closed if there are too many obvious mistakes, or when a
time-consuming rework is needed.

Automated accounts or chatbots must not submit pull requests or use pull
request interactions to train AI or LLM systems.

Finally, if we close a pull request because it's not ready yet, or stalled out,
please don't give up. You can resubmit them later once you have time to finish
the work, or to have them reconsidered if you think we've made an error in
closing it.

### Author Name and Email

Please use a name and email address in the `Signed-off-by` trailer and as the
author of the git commits, since we cannot accept anonymous contributions. It is
common, but not required, to use some form of your full name. We realize that
some contributors are not comfortable doing so or prefer to contribute under a
pseudonym, preferred name, chosen name or similar moniker that might not match
relevant government records. We can accept your patch, as long as the name and
email you use are distinctive, identifying, and not misleading. Please note that
if your patch is accepted, the name and email address will become a permanent
and immutable part of the public history of the FreeBSD source tree.

The goal of this policy is to allow us to have sufficient information to contact
you if questions arise about your contribution. Addresses of the form
something@users.noreply.github.com do not meet this standard since we cannot use
it to contact you. We can use `.mailmap` for name or email changes and mistakes,
but is imperfect.

Core (core@freebsd.org) may request authors of significant changes using an
obvious pseudonym to document their identity more concretely should there be
issues in the future. The author may request this documentation be kept
confidential unless needed for legal issues arising from their contributions.

## Style

Avoid adding trailing newlines and whitespace. These slow down the integration
process and are a distraction. `git diff` will highlight them in red, as will
the Files Changed tab in the pull request.

For C programs, see [style(9)](https://man.freebsd.org/cgi/man.cgi?query=style&sektion=9)
for details. You can use [Clang format](https://clang.llvm.org/docs/ClangFormat.html)
with the top level .clang-format file if you are unsure. The
[git clang-format](https://github.com/llvm-mirror/clang/blob/master/tools/clang-format/git-clang-format)
command can help minimize churn by only formatting the areas nearby the changes. While
not perfect, using these tools will maximize your chances of not having style
comments on your pull requests.

For [Lua](https://www.lua.org), see
[style.lua(9)](https://man.freebsd.org/cgi/man.cgi?query=style.lua&sektion=9)
for details. Lua is used for the boot loader and a few scripts in the base system.

For Makefiles changes, see
[style.Makefile(5)](https://man.freebsd.org/cgi/man.cgi?query=style.Makefile&sektion=5)
for details. FreeBSD's base system uses the in-tree make, not GNU Make, so
[make(1)](https://man.freebsd.org/cgi/man.cgi?query=make&sektion=1) is another useful
resource.

For manual page changes, see
[style.mdoc(5)](https://man.freebsd.org/cgi/man.cgi?query=style.mdoc&sektion=5)
for details. Changes should pass `mandoc -Tlint` and igor (install the latter with `pkg install igor`).
Please be sure to observe the one-sentence-per-line rule so manual pages properly render.
Proposed changes to manual pages should not bump the document date until merged.

For shell scripts, avoid using bash. The system shell (/bin/sh) is preferred.
Shell scripts in the base system cannot use bash or bash extensions
not present in FreeBSD's [shell](https://man.freebsd.org/cgi/man.cgi?query=sh&sektion=1).

## Signed-off-by

Other projects mandate Signed-off-by to create a paper trail for contributions they
receive. The Developer Certificate of Origin is an attestation that the person
making the contribution can do it under the current license of the file. Other
projects that have 'delegated' hierarchies also use it when maintainers
integrate these patches and submit them upstream.

Right now, pull requests on GitHub are an experimental feature. We strongly
suggest that people add this line. It creates a paper trail for infrequent
contributors. Also, developers that are landing a pull request will use a
Signed-off-by line to set the author for the commit.

These lines are easy to add with `git commit -s`.

## Submitting as part of class work

If you are a professor or teacher that wishes to have your students submit fixes
as part of their class work, please contact imp@FreeBSD.org before the semester
to ensure we allocate the proper resources to process them quickly. We'll give
you more details when you contact us and thanks for including FreeBSD in your
class work. It also helps us keep track.

## FreeBSD's Upstreams

Anything that's in the directory `contrib`, `crypto`, `sys/contrib`,
`sys/crypto/` or `sys/cddl` likely has an upstream we pull from. Please do a
`git log --merges` in any subdirectory of these you are submitting patches for
to find out the last time we merged from upstream. If it is in the last 5 years,
upstream is "active" and you should submit your patches there and let the last
few people to commit to this file (especially merge commits) know. If it's been
more than 5 years, upstream is likely inactive so please submit the patch. We
can sort out if it should go into FreeBSD or upstream.
