#!/bin/sh

# panic: Counter goes negative
# cpuid = 4
# time = 1694583637
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01bac2a960
# vpanic() at vpanic+0x132/frame 0xfffffe01bac2aa90
# panic() at panic+0x43/frame 0xfffffe01bac2aaf0
# sctp_inpcb_free() at sctp_inpcb_free+0xf28/frame 0xfffffe01bac2ab60
# sctp_close() at sctp_close+0xc0/frame 0xfffffe01bac2abb0
# soclose() at soclose+0x154/frame 0xfffffe01bac2ac10
# _fdrop() at _fdrop+0x1b/frame 0xfffffe01bac2ac30
# closef() at closef+0x1e3/frame 0xfffffe01bac2acc0
# fdescfree() at fdescfree+0x41a/frame 0xfffffe01bac2ad80
# exit1() at exit1+0x4a1/frame 0xfffffe01bac2adf0
# sys_exit() at sys_exit+0xd/frame 0xfffffe01bac2ae00
# amd64_syscall() at amd64_syscall+0x14f/frame 0xfffffe01bac2af30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01bac2af30
# --- syscall (1, FreeBSD ELF64, exit), rip = 0x824db2f4a, rsp = 0x8211862b8, rbp = 0x8211862d0 ---
# KDB: enter: pani[ thread pid 9676 tid 346853 ]
# Stopped at      kdb_enter+0x32: movq    $0,0xe27583(%rip)
# db> x/s version
# version: FreeBSD 15.0-CURRENT #0 main-n265298-10db91ecec98b1: Tue Sep 12 12:16:45 CEST 2023
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

uname -p | grep -Eq "amd64" || exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=d8a54d453b8e643b807a5c3c56728561f01c0fde
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+d4e1d30d578891245f59@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x20000040 = 0x1c;
  *(uint8_t*)0x20000041 = 0x1c;
  *(uint16_t*)0x20000042 = htobe16(0x4e22 + procid * 4);
  *(uint32_t*)0x20000044 = 0;
  *(uint64_t*)0x20000048 = htobe64(0);
  *(uint64_t*)0x20000050 = htobe64(1);
  *(uint32_t*)0x20000058 = 0;
  syscall(SYS_bind, r[0], 0x20000040ul, 0x1cul);
  *(uint8_t*)0x20000180 = 0x1c;
  *(uint8_t*)0x20000181 = 0x1c;
  *(uint16_t*)0x20000182 = htobe16(0x4e22 + procid * 4);
  *(uint32_t*)0x20000184 = 0;
  *(uint64_t*)0x20000188 = htobe64(0);
  *(uint64_t*)0x20000190 = htobe64(1);
  *(uint32_t*)0x20000198 = 0;
  syscall(SYS_connect, r[0], 0x20000180ul, 0x1cul);
  *(uint32_t*)0x20000300 = 0x80000021;
  syscall(SYS_setsockopt, r[0], 0x84, 0x1b, 0x20000300ul, 4ul);
  memset((void*)0x20000480, 163, 1);
  syscall(SYS_sendto, r[0], 0x20000480ul, 0xfffffe5cul, 0x188ul, 0ul, 0ul);
  *(uint16_t*)0x200000c0 = 0;
  *(uint16_t*)0x200000c2 = 0x200;
  *(uint32_t*)0x200000c4 = 0;
  *(uint32_t*)0x200000c8 = 0;
  *(uint32_t*)0x200000cc = 0;
  syscall(SYS_setsockopt, r[0], 0x84, 0x21, 0x200000c0ul, 0x10ul);
  syscall(SYS_shutdown, r[0], 0ul);
  syscall(SYS_writev, r[0], 0ul, 0ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      loop();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

mount | grep -q "on $mntpoint " && umount $mntpoint
mount -o size=10m -t tmpfs dummy $mntpoint

cd $mntpoint
for i in `jot 20`; do
	timeout 3m /tmp/$prog &
done
wait
cd -

umount $mntpoint
rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core
exit 0
