/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.KioskCanvas;
import com.sun.prodreg.awt.RegNode;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ProdReg;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Polygon;
import java.util.Locale;
import java.util.Vector;

class Node {
    static int nodeIndent = 15;
    static int nodeLeading = 18;
    static Locale currentLocale;
    boolean expand = false;
    static Color markerColor;
    static Color selectColor;
    static Color nonSelectableColor;
    static Color disabledColor;
    static Color fontColor;
    static Node nodeSelected;
    Node parent;
    Runtime rt = Runtime.getRuntime();
    static Cursor currentCursor;
    Label nameLabel = null;
    private Vector childCache = null;
    private ProdRegTreeNode node = null;

    static {
        markerColor = Color.darkGray;
        selectColor = Color.blue;
        nonSelectableColor = new Color(100, 100, 100);
        disabledColor = new Color(100, 100, 100);
        fontColor = Color.black;
        nodeSelected = null;
    }

    public Node(ProdRegTreeNode node, boolean exp) {
        this.node = node;
        this.expand = exp;
    }

    public ProdRegTreeNode getTreeNode() {
        return this.node;
    }

    public void paintMarker(Graphics g, boolean expanded, Color c, int x, int y) {
        Polygon p = new Polygon();
        if (!this.node.isLeaf()) {
            if (expanded) {
                if (KioskCanvas.openImage != null) {
                    g.drawImage(KioskCanvas.openImage, x - 15, y - 10, null);
                    return;
                }
                g.setColor(c);
                p.addPoint(x - 13, y - 6);
                p.addPoint(x - 9, y - 2);
                p.addPoint(x - 5, y - 6);
                g.fillPolygon(p);
            } else {
                if (KioskCanvas.closeImage != null) {
                    g.drawImage(KioskCanvas.closeImage, x - 15, y - 10, null);
                    return;
                }
                g.setColor(c);
                p.addPoint(x - 11, y - 9);
                p.addPoint(x - 11, y - 1);
                p.addPoint(x - 7, y - 5);
                g.fillPolygon(p);
            }
        }
        if (this.node.getComponentDescription().isDamaged()) {
            g.drawImage(KioskCanvas.damageImage, x - 30, y - 15, null);
        }
    }

    public int paintNode(Graphics g, boolean enabled, Vector treeDisplay, int x, int y) {
        String section = "";
        this.verify();
        Color mc = !enabled ? disabledColor : (!this.node.isSelectable() ? nonSelectableColor : markerColor);
        this.paintMarker(g, this.expand, mc, x, y);
        if (!enabled) {
            g.setColor(disabledColor);
        } else if (!this.node.isSelectable()) {
            g.setColor(nonSelectableColor);
        } else if (this == nodeSelected) {
            g.setColor(selectColor);
        } else if (this == nodeSelected) {
            g.setColor(selectColor);
        } else {
            g.setColor(fontColor);
        }
        String nm = this.node.toString();
        treeDisplay.addElement(new RegNode(this, x, y));
        g.drawString(nm, x, y);
        if (this.node.isSelectable() && !this.node.isLeaf() && this.expand) {
            int last = y;
            int size = this.childCache.size();
            int i = 0;
            while (i < size) {
                Node n = (Node)this.childCache.elementAt(i);
                last = n.paintNode(g, enabled, treeDisplay, x + nodeIndent, last + nodeLeading);
                ++i;
            }
            return last;
        }
        return y;
    }

    public void refresh(Vector idsToExpand, boolean toExpand) {
        this.childCache = null;
        this.verify();
        String myID = this.node.getComponentDescription().getID();
        if (idsToExpand.contains(myID)) {
            if (toExpand) {
                this.expand = true;
            }
            nodeSelected = this;
        }
        int sz = this.childCache.size();
        int i = 0;
        while (i < sz) {
            Node n = (Node)this.childCache.elementAt(i);
            n.refresh(idsToExpand, toExpand);
            ++i;
        }
    }

    public Dimension requiredSize(FontMetrics fm, int indent) {
        this.verify();
        String nm = this.toString();
        if (nm == null) {
            nm = Localizer.resolve("<L ProdRegResources.NoDisplayName>");
        }
        int width = 0;
        int height = 0;
        height += nodeLeading;
        width += indent + fm.stringWidth(nm);
        if (!this.node.isLeaf() && this.expand) {
            int size = this.childCache.size();
            int i = 0;
            while (i < size) {
                Node n = (Node)this.childCache.elementAt(i);
                Dimension nSize = n.requiredSize(fm, indent + nodeIndent);
                height += nSize.height;
                if (nSize.width > width) {
                    width = nSize.width;
                }
                ++i;
            }
        }
        return new Dimension(width, height);
    }

    private void verify() {
        if (this.childCache == null) {
            ComponentReference[] kids;
            this.childCache = new Vector();
            Vector childDescCache = new Vector();
            if (this.node.getComponentDescription() != null && (kids = this.node.getComponentDescription().getChildren()) != null) {
                ComponentDescription childNode;
                int i = 0;
                while (i < kids.length) {
                    childNode = ComponentDescriptionLookup.get(kids[i].getID());
                    if (childNode != null) {
                        childDescCache.addElement(childNode);
                    } else if (ProdReg.debug) {
                        String id = this.node.getComponentDescription().getID();
                        System.out.println("warning: could not findchild of " + id + "with id " + kids[i].getID() + " could not be found");
                    }
                    ++i;
                }
                childDescCache = Utils.alphaCache(childDescCache);
                int sz = childDescCache.size();
                int i2 = 0;
                while (i2 < sz) {
                    childNode = (ComponentDescription)childDescCache.elementAt(i2);
                    ProdRegTreeNode newNode = new ProdRegTreeNode(childNode);
                    Node n = new Node(newNode, false);
                    this.childCache.addElement(n);
                    ++i2;
                }
            }
        }
    }
}

