/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.swing;

import com.sun.prodreg.swing.JTreeComponentDescriptionWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProdregTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Image damageImage = null;

    public ProdregTreeCellRenderer(Image damageImage) {
        this.damageImage = damageImage;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon saveLeafIcon = this.getLeafIcon();
        Icon saveOpenIcon = this.getOpenIcon();
        Icon saveClosedIcon = this.getClosedIcon();
        Color textns = this.getTextNonSelectionColor();
        Color texts = this.getTextSelectionColor();
        Color bgns = this.getBackgroundNonSelectionColor();
        Color bgs = this.getBackgroundSelectionColor();
        Color bord = this.getBorderSelectionColor();
        Color bg = this.getBackground();
        JTreeComponentDescriptionWrapper desc = (JTreeComponentDescriptionWrapper)value;
        boolean damaged = desc.getTreeNode().getComponentDescription().isDamaged();
        boolean selectable = desc.getTreeNode().isSelectable();
        if (!selectable) {
            this.setTextNonSelectionColor(Color.lightGray);
            this.setTextSelectionColor(Color.lightGray);
            this.setBackground(Color.white);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setBackgroundSelectionColor(Color.white);
            this.setBorderSelectionColor(Color.lightGray);
        } else if (damaged) {
            this.setLeafIcon(new ImageIcon(this.damageImage));
            this.setOpenIcon(new ImageIcon(this.damageImage));
            this.setClosedIcon(new ImageIcon(this.damageImage));
        }
        Component rtn = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!selectable) {
            this.setTextNonSelectionColor(textns);
            this.setTextSelectionColor(texts);
            this.setBackgroundNonSelectionColor(bgns);
            this.setBackgroundSelectionColor(bgs);
            this.setBorderSelectionColor(bord);
            this.setBackground(bg);
        }
        if (damaged) {
            this.setLeafIcon(saveLeafIcon);
            this.setOpenIcon(saveOpenIcon);
            this.setClosedIcon(saveClosedIcon);
        }
        return rtn;
    }
}

