/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.InsetsPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class Separator
extends InsetsPanel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    protected int orientation = 1;

    public Separator() {
    }

    public Separator(int orientation) {
        this.orientation = orientation;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int width = 4;
        int height = 4;
        switch (this.orientation) {
            case 1: {
                width = size.width - insets.left - insets.right;
                break;
            }
            case 2: {
                height = size.height - insets.top - insets.bottom;
                break;
            }
        }
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        g.setClip(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        Color background = this.getBackground();
        Color lightLine = background.brighter().brighter();
        Color darkLine = background.darker().darker();
        switch (this.orientation) {
            case 1: {
                int topLineY = (size.height - (insets.top + insets.bottom)) / 2 + insets.top - 1;
                g.setColor(darkLine);
                g.drawLine(insets.left, topLineY, size.width - insets.right, topLineY);
                g.setColor(lightLine);
                g.drawLine(insets.left, topLineY + 1, size.width - insets.right, topLineY + 1);
                break;
            }
            case 2: {
                int rightLineX = (size.width - (insets.left + insets.right)) / 2 + insets.left - 1;
                g.setColor(darkLine);
                g.drawLine(rightLineX, insets.top, rightLineX, size.height - insets.top);
                g.setColor(lightLine);
                g.drawLine(rightLineX + 1, insets.top, rightLineX + 1, size.height - insets.top);
                break;
            }
        }
    }
}

