/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.awt.AboutDialog;
import com.sun.prodreg.awt.ComponentSelectableViewComponentAdapter;
import com.sun.prodreg.awt.ExpandableDialog;
import com.sun.prodreg.awt.FlowLabel;
import com.sun.prodreg.awt.ImagePanel;
import com.sun.prodreg.awt.QueryDialog;
import com.sun.prodreg.awt.RelativeLayout;
import com.sun.prodreg.awt.Separator;
import com.sun.prodreg.awt.TitleBox;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.ProgressBar;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentView;
import com.sun.prodreg.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ProdRegViewManager
implements ViewManager,
ActionListener {
    private UIProvider provider = null;
    private Frame regFrame = null;
    public static final int FRAME_WIDTH = 800;
    public static final int FRAME_HEIGHT = 600;
    private InstallManager installManager = null;
    private ComponentView summaryView = null;
    private ComponentView moreView = null;
    private ComponentSelectableView treeView = null;
    private Object treeViewLock = new Object();
    private Object moreViewLock = new Object();
    private Object summaryViewLock = new Object();
    private Container summaryContainer = null;
    private Container moreContainer = null;
    private Container treeContainer = null;
    private static String recentDir = "/cdrom";
    private Component aboutButton = null;
    private Component newInstallButton = null;
    private Component uninstallButton = null;
    private Component exitButton = null;
    private Vector errorCache = new Vector();
    public static final int OPTION_UNINSTALL = 1;
    public static final int OPTION_INSTALL = 2;
    private ProgressBar pbar = null;
    private int options = 0;

    public ProdRegViewManager(UIProvider provider, InstallManager installManager, ComponentView summaryView, ComponentView moreView, ComponentSelectableView treeView) {
        this.treeView = treeView;
        this.installManager = installManager;
        this.provider = provider;
        this.summaryView = summaryView;
        this.moreView = moreView;
        this.treeContainer = provider.getContainer(new BorderLayout());
        this.moreContainer = provider.getContainer(new BorderLayout());
        this.summaryContainer = provider.getContainer(new BorderLayout());
        this.pbar = provider.getProgressBar();
        this.showGUI();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.aboutButton)) {
            this.aboutButton.setEnabled(false);
            this.doAbout();
            this.aboutButton.setEnabled(true);
        } else if (src.equals(this.newInstallButton)) {
            FileDialog d = new FileDialog(this.regFrame, Localizer.resolve("<L ProdRegResources.NewInstallTitle>..."), 0);
            d.setDirectory(recentDir);
            d.show();
            if (d.getDirectory() != null && d.getFile() != null) {
                recentDir = d.getDirectory();
                this.installManager.newInstall(recentDir, d.getFile());
            }
        } else if (src.equals(this.uninstallButton)) {
            boolean interactive = (e.getModifiers() & 1) != 0;
            this.installManager.newUninstall(interactive);
        } else if (src.equals(this.exitButton)) {
            this.close();
            this.installManager.close(0);
        }
    }

    public void close() {
        ((Component)this.regFrame).setVisible(false);
        this.regFrame.dispose();
    }

    private void doAbout() {
        AboutDialog ad = new AboutDialog(this.regFrame);
        Dimension parentSize = this.regFrame.getSize();
        Point loc = this.regFrame.getLocationOnScreen();
        ((Component)ad).setLocation(loc.x, loc.y);
        ad.setForeground(Color.black);
        ((Component)ad).setBackground(Color.lightGray);
        ad.show();
    }

    private Component getAboutComponent() {
        Container p = this.provider.getContainer(new FlowLayout(2));
        this.aboutButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.About>"), this);
        p.add(this.aboutButton);
        return p;
    }

    private Component getControlComponent() {
        double[] rel = new double[]{0.4, 0.4, 0.2};
        Container p = this.provider.getContainer(new RelativeLayout(rel, 0));
        Container left = this.provider.getContainer(new FlowLayout(1));
        Container middle = this.provider.getContainer(new GridBagLayout());
        Container right = this.provider.getContainer(new FlowLayout(2));
        this.newInstallButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.NewInstall>..."), this);
        this.uninstallButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.Uninstall>..."), this);
        this.uninstallButton.setEnabled(false);
        this.exitButton = this.provider.getButton(Localizer.resolve("<L ProdRegResources.Exit>"), this);
        left.add(this.newInstallButton);
        left.add(this.uninstallButton);
        GridBagConstraints pbarConstraints = new GridBagConstraints();
        pbarConstraints.fill = 2;
        pbarConstraints.weightx = 1.0;
        pbarConstraints.insets = new Insets(0, 7, 0, 0);
        middle.add((Component)((Object)this.pbar), pbarConstraints);
        this.hideProgress();
        right.add(this.exitButton);
        p.add(left);
        p.add(middle);
        p.add(right);
        return p;
    }

    private Component getInfoPanel() {
        double[] infoRel = new double[]{0.5, 0.5};
        Container infoPanel = this.provider.getContainer(new RelativeLayout(infoRel, 1));
        TitleBox sumPanel = new TitleBox(Localizer.resolve("<L ProdRegResources.Summary>"));
        GridBagConstraints tc = new GridBagConstraints();
        tc.weightx = 1.0;
        tc.weighty = 1.0;
        tc.fill = 1;
        tc.gridwidth = 0;
        tc.insets = new Insets(13, 10, 10, 10);
        Object object = this.summaryViewLock;
        synchronized (object) {
            if (this.summaryView != null && this.summaryView instanceof Component) {
                this.summaryContainer.add((Component)((Object)this.summaryView), "Center");
            }
        }
        sumPanel.add((Component)this.summaryContainer, tc);
        infoPanel.add(sumPanel);
        TitleBox morePanel = new TitleBox(Localizer.resolve("<L ProdRegResources.MoreInfo>"));
        Object object2 = this.moreViewLock;
        synchronized (object2) {
            if (this.moreView != null && this.moreView instanceof Component) {
                this.moreContainer.add((Component)((Object)this.moreView), "Center");
            }
        }
        morePanel.add((Component)this.moreContainer, tc);
        infoPanel.add(morePanel);
        return infoPanel;
    }

    public ComponentView getMoreiew() {
        Object object = this.moreViewLock;
        synchronized (object) {
            ComponentView componentView = this.moreView;
            Object var3_3 = null;
            return componentView;
        }
    }

    public int getOptions() {
        return this.options;
    }

    public ComponentView getSummaryView() {
        Object object = this.summaryViewLock;
        synchronized (object) {
            ComponentView componentView = this.summaryView;
            Object var3_3 = null;
            return componentView;
        }
    }

    private Component getTreePanel() {
        Container treePanel = this.provider.getContainer(new GridBagLayout());
        GridBagConstraints treeGbl = new GridBagConstraints();
        treeGbl.fill = 2;
        treeGbl.insets = new Insets(3, 2, 5, 2);
        treeGbl.gridwidth = -1;
        Component label = this.provider.getLabel(Localizer.resolve("<L ProdRegResources.InstalledSoftware>"), 2);
        treePanel.add(label, treeGbl);
        treeGbl.fill = 1;
        treeGbl.weightx = 1.0;
        treeGbl.weighty = 1.0;
        treeGbl.gridx = 0;
        treeGbl.gridy = 1;
        Object object = this.treeViewLock;
        synchronized (object) {
            if (this.treeView != null && this.treeView instanceof Component) {
                this.treeContainer.add((Component)((Object)this.treeView), "Center");
            }
        }
        treePanel.add((Component)this.treeContainer, treeGbl);
        return treePanel;
    }

    public ComponentSelectableView getTreeView() {
        Object object = this.treeViewLock;
        synchronized (object) {
            ComponentSelectableView componentSelectableView = this.treeView;
            Object var3_3 = null;
            return componentSelectableView;
        }
    }

    public void hideProgress() {
        ((Component)((Object)this.pbar)).setVisible(false);
        ((Component)((Object)this.pbar)).getParent().repaint();
    }

    public void logError(String msg) {
        String title = Localizer.resolve("<L ProdRegResources.Error>");
        String ok = Localizer.resolve("<L ProdRegResources.OK>");
        if (this.regFrame == null || !this.regFrame.isVisible()) {
            this.errorCache.addElement(msg);
            return;
        }
        QueryDialog q = new QueryDialog(null, this.regFrame, title, msg, new String[]{ok}, null);
    }

    public void logMessage(String msg) {
    }

    public void logWarning(String msg) {
    }

    public int query(String title, String msg, String moreInfo, String[] buttons) {
        String ms = String.valueOf(Localizer.resolve("<L ProdRegResources.More>")) + " >>>";
        String ls = "<<< " + Localizer.resolve("<L ProdRegResources.Less>");
        if (msg == null) {
            msg = Localizer.resolve("<L ProdRegResources.Error>");
        }
        ExpandableDialog ed = new ExpandableDialog(this.regFrame, title, true);
        ed.setExpandLabels(ms, ls);
        ed.setButtons(buttons);
        FlowLabel fl = new FlowLabel(msg);
        Panel flp = new Panel(new BorderLayout());
        flp.add((Component)fl, "Center");
        ed.setTopComponent(flp);
        if (moreInfo != null) {
            TextArea more = new TextArea();
            Panel moreP = new Panel(new BorderLayout());
            String pout = Localizer.resolve("<L ProdRegResources.ProgramOutput>:");
            moreP.add(this.provider.getLabel(pout, 0), "North");
            moreP.add((Component)more, "Center");
            more.setEditable(false);
            more.append(moreInfo);
            ed.setBottomComponent(moreP);
        }
        ed.pack();
        Point regLoc = this.regFrame.getLocationOnScreen();
        ((Component)ed).setLocation(regLoc.x + (this.regFrame.getSize().width / 2 - ed.getSize().width / 2), regLoc.y + (this.regFrame.getSize().height / 2 - ed.getSize().height / 2));
        ed.show();
        return ed.getButtonPressed();
    }

    public void setMoreView(ComponentView moreView) {
        Object object = this.moreViewLock;
        synchronized (object) {
            this.moreView = moreView;
            if (moreView != null && moreView instanceof Component) {
                this.moreContainer.removeAll();
                this.moreContainer.add((Component)((Object)moreView), "Center");
                this.moreContainer.validate();
                this.moreContainer.invalidate();
            }
        }
    }

    public void setOptions(int options) {
        this.uninstallButton.setEnabled((options & 1) != 0);
        this.newInstallButton.setEnabled((options & 2) != 0);
        this.options = options;
    }

    public void setProgress(int progress) {
        this.pbar.setProgress(progress);
    }

    public void setProgressMessage(String message) {
        this.pbar.setMessage(message);
    }

    public void setSummaryView(ComponentView summaryView) {
        Object object = this.summaryViewLock;
        synchronized (object) {
            this.summaryView = summaryView;
            if (summaryView != null && summaryView instanceof Component) {
                this.summaryContainer.removeAll();
                this.summaryContainer.add((Component)((Object)summaryView), "Center");
                this.summaryContainer.validate();
                this.summaryContainer.invalidate();
            }
        }
    }

    public void setTreeView(ComponentSelectableView treeView) {
        Object object = this.treeViewLock;
        synchronized (object) {
            if (treeView == null || !(treeView instanceof Component)) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Image damage = tk.getImage(this.getClass().getResource("/images/damage.gif"));
                ImagePanel ip = new ImagePanel();
                ip.setImage(damage);
                ComponentSelectableViewComponentAdapter c = new ComponentSelectableViewComponentAdapter(ip, null);
                treeView = c;
            }
            this.treeView = treeView;
            this.treeContainer.removeAll();
            this.treeContainer.add((Component)((Object)treeView), "Center");
            this.treeContainer.validate();
            this.treeContainer.invalidate();
        }
    }

    public void showComponent(ComponentDescription desc) {
        Object object = this.summaryViewLock;
        synchronized (object) {
            this.summaryView.showComponent(desc);
        }
        object = this.moreViewLock;
        synchronized (object) {
            this.moreView.showComponent(desc);
        }
    }

    private void showGUI() {
        Container regPanel = this.provider.getContainer(new GridBagLayout());
        this.regFrame = this.provider.getFrame(Localizer.resolve("<L ProdRegResources.WindowTitle>"), regPanel);
        ((Component)this.regFrame).setSize(800, 600);
        this.regFrame.setForeground(Color.black);
        ((Component)this.regFrame).setBackground(Color.lightGray);
        GridBagConstraints topgbl = new GridBagConstraints();
        topgbl.fill = 2;
        topgbl.gridwidth = 0;
        topgbl.insets = new Insets(2, 3, 2, 3);
        regPanel.add(this.getAboutComponent(), topgbl);
        regPanel.add((Component)new Separator(1), topgbl);
        double[] centerRel = new double[]{0.4, 0.6};
        Container centerPanel = this.provider.getContainer(new RelativeLayout(centerRel, 0));
        centerPanel.add(this.getTreePanel());
        centerPanel.add(this.getInfoPanel());
        topgbl.weightx = 1.0;
        topgbl.weighty = 1.0;
        topgbl.fill = 1;
        regPanel.add((Component)centerPanel, topgbl);
        topgbl.fill = 2;
        topgbl.weightx = 0.0;
        topgbl.weighty = 0.0;
        regPanel.add((Component)new Separator(1), topgbl);
        regPanel.add(this.getControlComponent(), topgbl);
        this.regFrame.addWindowListener(new ProdRegWindowAdapter());
        Toolkit tk = this.regFrame.getToolkit();
        Dimension screenSize = tk.getScreenSize();
        Dimension size = this.regFrame.getSize();
        ((Component)this.regFrame).setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
        Image winicon = tk.getImage(this.getClass().getResource("/images/winicon.gif"));
        tk.prepareImage(winicon, -1, -1, null);
        this.regFrame.setIconImage(winicon);
        this.regFrame.show();
        int i = 0;
        while (i < this.errorCache.size()) {
            this.logError((String)this.errorCache.elementAt(i));
            ++i;
        }
    }

    public void showProgress() {
        ((Component)((Object)this.pbar)).setVisible(true);
        ((Component)((Object)this.pbar)).getParent().repaint();
    }

    class ProdRegWindowAdapter
    extends WindowAdapter {
        ProdRegWindowAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            ProdRegViewManager.this.close();
            ProdRegViewManager.this.installManager.close(0);
        }
    }
}

