/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizard;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SaveAsSubApplicationTypeAction
extends SelectionAction {
    public static final String ID = "SaveAsSubApplicationTypeAction";

    public SaveAsSubApplicationTypeAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.SaveAsSubApplicationTypeAction_SaveAsSubApplicationTypeText);
    }

    protected boolean calculateEnabled() {
        if (!this.getSelectedObjects().isEmpty()) {
            for (Object selected : this.getSelectedObjects()) {
                if (selected instanceof EditPart) {
                    if (((EditPart)selected).getModel() instanceof SubApp) {
                        if (((SubApp)((EditPart)selected).getModel()).getPaletteEntry() == null) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void run() {
        for (Object selected : this.getSelectedObjects()) {
            EditPart ep = (EditPart)selected;
            SubApp subApp = (SubApp)ep.getModel();
            if (!this.checkContainedSubApps(subApp).booleanValue()) {
                this.showInformationDialog(subApp);
                continue;
            }
            this.invokeSaveWizard(subApp);
        }
    }

    private void showInformationDialog(SubApp subApp) {
        MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.SaveAsSubApplicationTypeAction_UntypedSubappError, (String)Messages.SaveAsSubApplicationTypeAction_UntypedSubappErrorDescription);
    }

    private void invokeSaveWizard(SubApp subApp) {
        SaveAsSubappWizard wizard = new SaveAsSubappWizard(subApp);
        WizardDialog dialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private Boolean checkContainedSubApps(SubApp subApp) {
        for (FBNetworkElement element : subApp.getSubAppNetwork().getNetworkElements()) {
            if (!(element instanceof SubApp) || element.getPaletteEntry() != null) continue;
            return false;
        }
        return true;
    }
}

