/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.launching.JavaMigrationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ScrapbookLauncher
implements IDebugEventSetListener {
    public static final String SCRAPBOOK_LAUNCH = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".scrapbook_launch";
    public static final String SCRAPBOOK_FILE_PATH = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".scrapbook_file_path";
    public static final QualifiedName SNIPPET_EDITOR_LAUNCH_CONFIG_HANDLE_MEMENTO = new QualifiedName(IJavaDebugUIConstants.PLUGIN_ID, "snippet_editor_launch_config");
    private IJavaLineBreakpoint fMagicBreakpoint;
    private HashMap<IFile, IDebugTarget> fScrapbookToVMs = new HashMap(10);
    private HashMap<IDebugTarget, IBreakpoint> fVMsToBreakpoints = new HashMap(10);
    private HashMap<IDebugTarget, IFile> fVMsToScrapbooks = new HashMap(10);
    private static ScrapbookLauncher fgDefault = null;

    private ScrapbookLauncher() {
    }

    public static ScrapbookLauncher getDefault() {
        if (fgDefault == null) {
            fgDefault = new ScrapbookLauncher();
        }
        return fgDefault;
    }

    protected ILaunch launch(IFile page) {
        this.cleanupLaunchConfigurations();
        if (!page.getFileExtension().equals("jpage")) {
            this.showNoPageDialog();
            return null;
        }
        IDebugTarget vm = this.getDebugTarget(page);
        if (vm != null) {
            return vm.getLaunch();
        }
        IJavaProject javaProject = JavaCore.create((IProject)page.getProject());
        URL jarURL = null;
        try {
            jarURL = JDIDebugUIPlugin.getDefault().getBundle().getEntry("snippetsupport.jar");
            jarURL = FileLocator.toFileURL((URL)jarURL);
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
            return null;
        }
        catch (IOException e) {
            JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
            return null;
        }
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>(3);
        String jarFile = jarURL.getFile();
        IRuntimeClasspathEntry supportEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(jarFile));
        cp.add(supportEntry);
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getClasspathProperty() != 3) {
                    cp.add(entries[i]);
                }
                ++i;
            }
            IRuntimeClasspathEntry[] classPath = cp.toArray(new IRuntimeClasspathEntry[cp.size()]);
            return this.doLaunch(javaProject, page, classPath, jarFile);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ILaunch doLaunch(IJavaProject p, IFile page, IRuntimeClasspathEntry[] classPath, String jarFile) {
        try {
            if (this.fVMsToScrapbooks.isEmpty()) {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
            ILaunchConfiguration config = null;
            ILaunchConfigurationWorkingCopy wc = null;
            try {
                config = ScrapbookLauncher.getLaunchConfigurationTemplate(page);
                if (config != null) {
                    wc = config.getWorkingCopy();
                }
            }
            catch (CoreException e) {
                config = null;
                JDIDebugUIPlugin.errorDialog("Unable to retrieve scrapbook settings", e);
            }
            if (config == null) {
                config = ScrapbookLauncher.createLaunchConfigurationTemplate(page);
                wc = config.getWorkingCopy();
            }
            IPath outputLocation = p.getProject().getWorkingLocation(JDIDebugUIPlugin.getUniqueIdentifier());
            File f = outputLocation.toFile();
            URL u = null;
            try {
                u = this.getEncodedURL(f);
            }
            catch (MalformedURLException e) {
                JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
                return null;
            }
            catch (UnsupportedEncodingException usee) {
                JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", usee);
                return null;
            }
            String[] defaultClasspath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)p);
            String[] urls = new String[defaultClasspath.length + 1];
            urls[0] = u.toExternalForm();
            int i = 0;
            while (i < defaultClasspath.length) {
                f = new File(defaultClasspath[i]);
                try {
                    urls[i + 1] = this.getEncodedURL(f).toExternalForm();
                }
                catch (MalformedURLException e) {
                    JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
                    return null;
                }
                catch (UnsupportedEncodingException usee) {
                    JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", usee);
                    return null;
                }
                ++i;
            }
            ArrayList<String> classpathList = new ArrayList<String>(classPath.length);
            int i2 = 0;
            while (i2 < classPath.length) {
                classpathList.add(classPath[i2].getMemento());
                ++i2;
            }
            if (wc == null) {
                wc = config.getWorkingCopy();
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpathList);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, p.getElementName());
            if (wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null) == null) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.jdt.debug.ui.scrapbookSourcepathProvider");
            }
            StringBuffer urlsString = new StringBuffer();
            int i3 = 0;
            while (i3 < urls.length) {
                urlsString.append(' ');
                urlsString.append(urls[i3]);
                ++i3;
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, urlsString.toString());
            wc.setAttribute(SCRAPBOOK_LAUNCH, SCRAPBOOK_LAUNCH);
            config = wc.doSave();
            ILaunch launch = config.launch("debug", null);
            if (launch == null) return null;
            IDebugTarget dt = launch.getDebugTarget();
            IBreakpoint magicBreakpoint = this.createMagicBreakpoint(jarFile);
            this.fScrapbookToVMs.put(page, dt);
            this.fVMsToScrapbooks.put(dt, page);
            this.fVMsToBreakpoints.put(dt, magicBreakpoint);
            dt.breakpointAdded(magicBreakpoint);
            launch.setAttribute(SCRAPBOOK_LAUNCH, SCRAPBOOK_LAUNCH);
            return launch;
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog("Unable to launch scrapbook VM", e);
        }
        return null;
    }

    IBreakpoint createMagicBreakpoint(String jarFile) throws CoreException {
        IMethodInfo[] methodInfos;
        String typeName = "org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain";
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)jarFile, (String)(String.valueOf(typeName.replace('.', '/')) + ".class"), (int)35);
        IMethodInfo[] iMethodInfoArray = methodInfos = reader.getMethodInfos();
        int n = methodInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodInfo methodInfo = iMethodInfoArray[n2];
            if (CharOperation.equals((char[])"nop".toCharArray(), (char[])methodInfo.getName())) {
                ICodeAttribute codeAttribute = methodInfo.getCodeAttribute();
                ILineNumberAttribute lineNumberAttribute = codeAttribute.getLineNumberAttribute();
                int[][] lineNumberTable = lineNumberAttribute.getLineNumberTable();
                int lineNumber = lineNumberTable[0][1];
                this.fMagicBreakpoint = JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)false, null);
                this.fMagicBreakpoint.setPersisted(false);
                return this.fMagicBreakpoint;
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "An error occurred creating the evaluation breakpoint location.", null));
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IDebugTarget && event.getKind() == 8) {
                this.cleanup((IDebugTarget)event.getSource());
            }
            ++i;
        }
    }

    public IDebugTarget getDebugTarget(IFile page) {
        return this.fScrapbookToVMs.get(page);
    }

    public IBreakpoint getMagicBreakpoint(IDebugTarget target) {
        return this.fVMsToBreakpoints.get(target);
    }

    protected void showNoPageDialog() {
        String title = SnippetMessages.getString("ScrapbookLauncher.error.title");
        String msg = SnippetMessages.getString("ScrapbookLauncher.error.pagenotfound");
        MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)msg);
    }

    protected void cleanup(IDebugTarget target) {
        IFile page = this.fVMsToScrapbooks.get(target);
        if (page != null) {
            this.fVMsToScrapbooks.remove(target);
            this.fScrapbookToVMs.remove(page);
            this.fVMsToBreakpoints.remove(target);
            ILaunch launch = target.getLaunch();
            if (launch != null) {
                ScrapbookLauncher.getLaunchManager().removeLaunch(launch);
            }
            if (this.fVMsToScrapbooks.isEmpty()) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    protected URL getEncodedURL(File file) throws MalformedURLException, UnsupportedEncodingException {
        String urlDelimiter = "/";
        String unencoded = file.toURL().toExternalForm();
        StringBuffer encoded = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(unencoded, urlDelimiter);
        encoded.append(tokenizer.nextToken());
        encoded.append(urlDelimiter);
        encoded.append(tokenizer.nextToken());
        while (tokenizer.hasMoreElements()) {
            encoded.append(urlDelimiter);
            String token = tokenizer.nextToken();
            try {
                encoded.append(URLEncoder.encode(token, ResourcesPlugin.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                encoded.append(URLEncoder.encode(token, "UTF-8"));
            }
        }
        if (file.isDirectory()) {
            encoded.append(urlDelimiter);
        }
        return new URL(encoded.toString());
    }

    public static ILaunchConfiguration getLaunchConfigurationTemplate(IFile file) throws CoreException {
        String memento = ScrapbookLauncher.getLaunchConfigMemento(file);
        if (memento != null) {
            return ScrapbookLauncher.getLaunchManager().getLaunchConfiguration(memento);
        }
        return null;
    }

    public static ILaunchConfiguration createLaunchConfigurationTemplate(IFile page) throws CoreException {
        ILaunchConfigurationType lcType = ScrapbookLauncher.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        String name = NLS.bind((String)SnippetMessages.getString("ScrapbookLauncher.17"), (Object[])new String[]{page.getName()});
        ILaunchConfigurationWorkingCopy wc = lcType.newInstance(null, name);
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain");
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, page.getProject().getName());
        wc.setAttribute(SCRAPBOOK_LAUNCH, SCRAPBOOK_LAUNCH);
        wc.setAttribute(SCRAPBOOK_FILE_PATH, page.getFullPath().toString());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.jdt.debug.ui.scrapbookSourcepathProvider");
        JavaMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)wc);
        ILaunchConfiguration config = wc.doSave();
        ScrapbookLauncher.setLaunchConfigMemento(page, config.getMemento());
        return config;
    }

    private static String getLaunchConfigMemento(IFile file) {
        try {
            return file.getPersistentProperty(SNIPPET_EDITOR_LAUNCH_CONFIG_HANDLE_MEMENTO);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return null;
        }
    }

    protected static void setLaunchConfigMemento(IFile file, String memento) {
        try {
            file.setPersistentProperty(SNIPPET_EDITOR_LAUNCH_CONFIG_HANDLE_MEMENTO, memento);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static String getWorkingDirectoryAttribute(IFile file) throws CoreException {
        ILaunchConfiguration config = ScrapbookLauncher.getLaunchConfigurationTemplate(file);
        if (config != null) {
            return config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        }
        return null;
    }

    public static String getVMArgsAttribute(IFile file) throws CoreException {
        ILaunchConfiguration config = ScrapbookLauncher.getLaunchConfigurationTemplate(file);
        if (config != null) {
            return config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        }
        return null;
    }

    public static IVMInstall getVMInstall(IFile file) throws CoreException {
        ILaunchConfiguration config = ScrapbookLauncher.getLaunchConfigurationTemplate(file);
        if (config == null) {
            IJavaProject pro = JavaCore.create((IProject)file.getProject());
            return JavaRuntime.getVMInstall((IJavaProject)pro);
        }
        return JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
    }

    public void cleanupLaunchConfigurations() {
        try {
            ILaunchConfigurationType lcType = ScrapbookLauncher.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfiguration[] configs = ScrapbookLauncher.getLaunchManager().getLaunchConfigurations(lcType);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < configs.length) {
                Path pagePath;
                IResource res;
                String path = configs[i].getAttribute(SCRAPBOOK_FILE_PATH, null);
                if (path != null && (res = root.findMember((IPath)(pagePath = new Path(path)))) == null) {
                    configs[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }
}

