/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintOperation;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PrintFigureOperation
extends PrintOperation {
    public static final int TILE = 1;
    public static final int FIT_PAGE = 2;
    public static final int FIT_WIDTH = 3;
    public static final int FIT_HEIGHT = 4;
    private IFigure printSource;
    private Color oldBGColor;
    private int printMode = 1;

    protected PrintFigureOperation(Printer p) {
        super(p);
    }

    public PrintFigureOperation(Printer p, IFigure srcFigure) {
        super(p);
        this.setPrintSource(srcFigure);
    }

    @Override
    int getGraphicsOrientation() {
        return this.getPrintSource().isMirrored() ? 0x4000000 : 0x2000000;
    }

    protected int getPrintMode() {
        return this.printMode;
    }

    protected IFigure getPrintSource() {
        return this.printSource;
    }

    @Override
    protected void preparePrintSource() {
        this.oldBGColor = this.getPrintSource().getLocalBackgroundColor();
        this.getPrintSource().setBackgroundColor(ColorConstants.white);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void printPages() {
        graphics = this.getFreshPrinterGraphics();
        figure = this.getPrintSource();
        this.setupPrinterGraphicsFor(graphics, figure);
        bounds = figure.getBounds();
        x = bounds.x;
        y = bounds.y;
        clipRect = new Rectangle();
        ** GOTO lbl26
        {
            graphics.pushState();
            this.getPrinter().startPage();
            graphics.translate(-x, -y);
            graphics.getClip(clipRect);
            clipRect.setLocation(x, y);
            graphics.clipRect(clipRect);
            figure.paint(graphics);
            this.getPrinter().endPage();
            graphics.popState();
            x += clipRect.width;
            do {
                if (x < bounds.x + bounds.width) continue block0;
                x = bounds.x;
                y += clipRect.height;
lbl26:
                // 2 sources

            } while (y < bounds.y + bounds.height);
        }
    }

    @Override
    protected void restorePrintSource() {
        this.getPrintSource().setBackgroundColor(this.oldBGColor);
        this.oldBGColor = null;
    }

    public void setPrintMode(int mode) {
        this.printMode = mode;
    }

    protected void setPrintSource(IFigure printSource) {
        this.printSource = printSource;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
        Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        switch (this.getPrintMode()) {
            case 2: {
                graphics.scale(Math.min(xScale, yScale) * dpiScale);
                break;
            }
            case 3: {
                graphics.scale(xScale * dpiScale);
                break;
            }
            case 4: {
                graphics.scale(yScale * dpiScale);
                break;
            }
            default: {
                graphics.scale(dpiScale);
            }
        }
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }
}

