/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.ArithmeticUtils;

public class HermiteInterpolator
implements UnivariateDifferentiableVectorFunction {
    private final List<Double> abscissae = new ArrayList<Double>();
    private final List<double[]> topDiagonal = new ArrayList<double[]>();
    private final List<double[]> bottomDiagonal = new ArrayList<double[]>();

    public void addSamplePoint(double x, double[] ... value) throws ZeroException, MathArithmeticException {
        int i = 0;
        while (i < value.length) {
            int j;
            double[] y = (double[])value[i].clone();
            if (i > 1) {
                double inv = 1.0 / (double)ArithmeticUtils.factorial(i);
                j = 0;
                while (j < y.length) {
                    int n = j++;
                    y[n] = y[n] * inv;
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, y);
            double[] bottom0 = y;
            j = i;
            while (j < n) {
                double[] bottom1 = this.bottomDiagonal.get(n - (j + 1));
                double inv = 1.0 / (x - this.abscissae.get(n - (j + 1)));
                if (Double.isInfinite(inv)) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, x);
                }
                int k = 0;
                while (k < y.length) {
                    bottom1[k] = inv * (bottom0[k] - bottom1[k]);
                    ++k;
                }
                bottom0 = bottom1;
                ++j;
            }
            this.topDiagonal.add((double[])bottom0.clone());
            this.abscissae.add(x);
            ++i;
        }
    }

    public PolynomialFunction[] getPolynomials() throws NoDataException {
        this.checkInterpolation();
        PolynomialFunction zero = this.polynomial(0.0);
        PolynomialFunction[] polynomials = new PolynomialFunction[this.topDiagonal.get(0).length];
        int i = 0;
        while (i < polynomials.length) {
            polynomials[i] = zero;
            ++i;
        }
        PolynomialFunction coeff = this.polynomial(1.0);
        int i2 = 0;
        while (i2 < this.topDiagonal.size()) {
            double[] tdi = this.topDiagonal.get(i2);
            int k = 0;
            while (k < polynomials.length) {
                polynomials[k] = polynomials[k].add(coeff.multiply(this.polynomial(tdi[k])));
                ++k;
            }
            coeff = coeff.multiply(this.polynomial(-this.abscissae.get(i2).doubleValue(), 1.0));
            ++i2;
        }
        return polynomials;
    }

    @Override
    public double[] value(double x) throws NoDataException {
        this.checkInterpolation();
        double[] value = new double[this.topDiagonal.get(0).length];
        double valueCoeff = 1.0;
        int i = 0;
        while (i < this.topDiagonal.size()) {
            double[] dividedDifference = this.topDiagonal.get(i);
            int k = 0;
            while (k < value.length) {
                int n = k;
                value[n] = value[n] + dividedDifference[k] * valueCoeff;
                ++k;
            }
            double deltaX = x - this.abscissae.get(i);
            valueCoeff *= deltaX;
            ++i;
        }
        return value;
    }

    @Override
    public DerivativeStructure[] value(DerivativeStructure x) throws NoDataException {
        this.checkInterpolation();
        Object[] value = new DerivativeStructure[this.topDiagonal.get(0).length];
        Arrays.fill(value, x.getField().getZero());
        DerivativeStructure valueCoeff = x.getField().getOne();
        int i = 0;
        while (i < this.topDiagonal.size()) {
            double[] dividedDifference = this.topDiagonal.get(i);
            int k = 0;
            while (k < value.length) {
                value[k] = ((DerivativeStructure)value[k]).add(valueCoeff.multiply(dividedDifference[k]));
                ++k;
            }
            DerivativeStructure deltaX = x.subtract(this.abscissae.get(i));
            valueCoeff = valueCoeff.multiply(deltaX);
            ++i;
        }
        return value;
    }

    private void checkInterpolation() throws NoDataException {
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
    }

    private PolynomialFunction polynomial(double ... c) {
        return new PolynomialFunction(c);
    }
}

