/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.pathplanners.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.mobility.pathplanners.impl.CircularExclusionZoneImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;

public class CircularExclusionZoneCustomImpl
extends CircularExclusionZoneImpl {
    private static CartesianPositionCoordinates center = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();

    @Override
    public boolean isPolygonInside(CartesianTriangle polygon) {
        return this.isPolygonInside((CartesianPolygon)polygon);
    }

    public boolean isPolygonInside(CartesianPolygon polygon) {
        boolean inside = false;
        Matrix4d centerTransform = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)this);
        Vector3d centerPosition = new Vector3d();
        centerTransform.get(centerPosition);
        CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(centerPosition.x, centerPosition.y, centerPosition.z);
        inside = Geometry3DUtilities.isInsidePolygon((CartesianPositionCoordinates)point, (CartesianPolygon)polygon);
        if (!inside) {
            int index = 0;
            CartesianPositionCoordinates from = null;
            CartesianPositionCoordinates to = null;
            while (index < polygon.getVertices().size() && !inside) {
                from = (CartesianPositionCoordinates)polygon.getVertices().get(index);
                to = index + 1 >= polygon.getVertices().size() ? (CartesianPositionCoordinates)polygon.getVertices().get(0) : (CartesianPositionCoordinates)polygon.getVertices().get(index + 1);
                inside = this.intersects(from, to);
                ++index;
            }
        }
        if (this.isInvertSamplingShape()) {
            return !inside;
        }
        return inside;
    }

    private CartesianPositionCoordinates projectOntoExclusionZone(CartesianPositionCoordinates point) {
        Matrix4d matrix = ApogyCommonTopologyFacade.INSTANCE.expressRootInNodeFrame((Node)this);
        Point3d projected = new Point3d();
        matrix.transform(point.asPoint3d(), projected);
        CartesianPositionCoordinates projectedPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(projected.x, projected.y, projected.z);
        return Geometry3DUtilities.getFlattenCoordinate((CartesianPlane)CartesianPlane.XY, (CartesianPositionCoordinates)projectedPoint);
    }

    @Override
    public boolean isInside(CartesianPositionCoordinates point) {
        boolean inside;
        CartesianPositionCoordinates projectedPoint = this.projectOntoExclusionZone(point);
        boolean bl = inside = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)projectedPoint, (CartesianPositionCoordinates)center) < this.getRadius();
        if (this.isInvertSamplingShape()) {
            return !inside;
        }
        return inside;
    }

    @Override
    public boolean intersects(CartesianPositionCoordinates from, CartesianPositionCoordinates to) {
        CartesianPositionCoordinates flattenedTo;
        CartesianPositionCoordinates flattenedFrom;
        CartesianPositionCoordinates intersect;
        if (this.isInside(from) || this.isInside(to)) {
            return true;
        }
        CartesianPositionCoordinates flattenedCenter = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        if (Geometry3DUtilities.getDistance((CartesianPositionCoordinates)flattenedCenter, (CartesianPositionCoordinates)(intersect = Geometry3DUtilities.getProjection((CartesianPositionCoordinates)flattenedCenter, (CartesianPositionCoordinates)(flattenedFrom = this.projectOntoExclusionZone(from)), (CartesianPositionCoordinates)(flattenedTo = this.projectOntoExclusionZone(to))))) < this.getRadius()) {
            double u1u2Distance = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)flattenedFrom, (CartesianPositionCoordinates)flattenedTo);
            return Geometry3DUtilities.getDistance((CartesianPositionCoordinates)intersect, (CartesianPositionCoordinates)flattenedFrom) < u1u2Distance && Geometry3DUtilities.getDistance((CartesianPositionCoordinates)intersect, (CartesianPositionCoordinates)flattenedTo) < u1u2Distance;
        }
        return false;
    }
}

