/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrakeStatComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(BrakeStatComposite.class);
    private static final String IMAGES_FOLDER = "platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/";
    private Image backgroundDisengaged;
    private Image backgroundEngaged;
    private boolean isEngaged;

    public BrakeStatComposite(Composite parent, int style, boolean isEngaged) {
        super(parent, style | 0x20000000);
        this.isEngaged = isEngaged;
        this.initImages();
        this.createPaintListener();
        this.createDisposeListener();
    }

    public synchronized boolean getActualValue() {
        return this.isEngaged;
    }

    public void setActualValue(boolean isEngaged) {
        this.isEngaged = isEngaged;
        this.redraw();
    }

    private void initImages() {
        try {
            Display device = Display.getCurrent();
            URL url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/brakeDisengaged.png");
            this.backgroundDisengaged = new Image((Device)device, url.openStream());
            url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/brakeEngaged.png");
            this.backgroundEngaged = new Image((Device)device, url.openStream());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintMeter(GC gc) {
        if (this.isEngaged) {
            if (this.backgroundEngaged != null) {
                gc.drawImage(this.backgroundEngaged, 0, 0, this.backgroundEngaged.getBounds().width, this.backgroundEngaged.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
            } else {
                this.drawBlackRectangle(gc);
            }
        } else if (this.backgroundDisengaged != null) {
            gc.drawImage(this.backgroundDisengaged, 0, 0, this.backgroundDisengaged.getBounds().width, this.backgroundDisengaged.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        } else {
            this.drawBlackRectangle(gc);
        }
    }

    private void drawBlackRectangle(GC gc) {
        Color color = new Color((Device)this.getDisplay(), 0, 0, 0);
        gc.setForeground(color);
        gc.setLineWidth(4);
        gc.drawRectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4);
        color.dispose();
    }

    private void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BrakeStatComposite.this.paintMeter(e.gc);
            }
        });
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BrakeStatComposite.this.backgroundDisengaged != null) {
                    BrakeStatComposite.this.backgroundDisengaged.dispose();
                }
                if (BrakeStatComposite.this.backgroundEngaged != null) {
                    BrakeStatComposite.this.backgroundEngaged.dispose();
                }
            }
        });
    }
}

