/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.Messages;

public abstract class AbstractScriptingServlet
extends HttpServlet {
    private static final String COULD_NOT_INITIALIZE_REPOSITORY = Messages.getString("AbstractScriptingServlet.COULD_NOT_INITIALIZE_REPOSITORY");
    private static final long serialVersionUID = -9115022531455267478L;
    public static final String REGISTRY_SCRIPTING_DEPLOY_PATH = "/db/dirigible/registry/public/ScriptingServices";
    public static final String REGISTRY_INTEGRATION_DEPLOY_PATH = "/db/dirigible/registry/public/IntegrationServices";
    public static final String REPOSITORY_ATTRIBUTE = "repository-instance";

    public static String getSandboxScripting(HttpServletRequest request) {
        return "/db/dirigible/sandbox/" + RepositoryFacade.getUser(request) + "/" + "ScriptingServices";
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initRepository(request);
        super.service(request, response);
    }

    private IRepository initRepository(HttpServletRequest request) throws ServletException {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            if (request != null) {
                request.getSession().setAttribute(REPOSITORY_ATTRIBUTE, (Object)repository);
            }
            return repository;
        }
        catch (Exception ex) {
            throw new ServletException(COULD_NOT_INITIALIZE_REPOSITORY, (Throwable)ex);
        }
    }

    protected abstract void doExecution(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected String getScriptingRegistryPath(HttpServletRequest request) {
        if (request != null && (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue() || request.getAttribute("debug") != null && ((Boolean)request.getAttribute("debug")).booleanValue())) {
            return AbstractScriptingServlet.getSandboxScripting(request);
        }
        return REGISTRY_SCRIPTING_DEPLOY_PATH;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecution(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecution(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecution(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecution(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecution(req, resp);
    }

    protected IRepository getRepository(HttpServletRequest req) throws IOException {
        IRepository repository = null;
        if (req != null) {
            repository = (IRepository)req.getSession().getAttribute(REPOSITORY_ATTRIBUTE);
        }
        if (repository == null) {
            try {
                repository = this.initRepository(req);
            }
            catch (Exception e) {
                this.log(e.getMessage(), e);
                throw new IOException(e);
            }
        }
        return repository;
    }
}

