/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer.properties;

import org.eclipse.eatop.common.ui.util.InstanceRefAutoCompleter;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.eatop.examples.explorer.internal.messages.Messages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.TreePath;

public class InstanceRefNotifier
extends EContentAdapter {
    private EObject eObject;
    private TreePath treePath;

    public void observe(EObject eo) {
        this.eObject = eo;
        eo.eAdapters().add((Object)this);
    }

    public void notifyChanged(Notification n) {
        this.unregister();
        EObject notifier = (EObject)n.getNotifier();
        boolean isInstanceRef = ModelSearcher.isInstanceRef((EObject)notifier);
        if (!isInstanceRef) {
            return;
        }
        EObject target = InstanceRefNotifier.getInstanceRefTarget(notifier);
        EObject newValue = null;
        if (n.getEventType() != 1) {
            return;
        }
        EObject cfr_ignored_0 = (EObject)n.getFeature();
        newValue = (EObject)n.getNewValue();
        if (newValue == target) {
            EStructuralFeature contextFeature = null;
            for (EStructuralFeature feature : notifier.eClass().getEAllStructuralFeatures()) {
                EAnnotation annotation = feature.getEAnnotation(Messages.Annotation_Stereotype);
                if (annotation == null || !annotation.getDetails().containsValue((Object)Messages.InstanceRef_Context)) continue;
                contextFeature = feature;
                InstanceRefAutoCompleter.completeInstanceRefContext((EObject)notifier, (EStructuralFeature)contextFeature, (TreePath)this.treePath);
            }
        }
    }

    private void unregister() {
        this.eObject.eAdapters().remove((Object)this);
    }

    private static EObject getInstanceRefTarget(EObject instanceRef) {
        EObject target = null;
        for (EStructuralFeature feature : instanceRef.eClass().getEAllStructuralFeatures()) {
            EAnnotation annotation = feature.getEAnnotation(Messages.Annotation_Stereotype);
            if (annotation == null || !annotation.getDetails().containsValue((Object)Messages.InstanceRef_Target)) continue;
            target = (EObject)instanceRef.eGet(feature);
        }
        return target;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }
}

