/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.ECPStaticRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.reporting.ECPRendererDescriptionInitFailedReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RendererInitFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class LegacyRendererService
implements EMFFormsRendererService<VElement> {
    private static final String TEST_DYNAMIC = "dynamicTest";
    private static final String TEST_STATIC = "staticTest";
    private static final String TESTER_PRIORITY = "priority";
    private static final String TESTER_VELEMENT = "element";
    private static final String RENDERER_TESTER = "testClass";
    private static final String RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.renderers";
    private ReportService reportService;
    private final Map<Set<ECPRendererTester>, Class<AbstractSWTRenderer<VElement>>> legacyRenderer = new LinkedHashMap<Set<ECPRendererTester>, Class<AbstractSWTRenderer<VElement>>>();

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.readRenderer(bundleContext);
    }

    private void readRenderer(BundleContext bundleContext) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class renderer = LegacyRendererService.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    LinkedHashSet<Object> tester = new LinkedHashSet<Object>();
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement testerExtension = iConfigurationElementArray2[n6];
                        if (TEST_DYNAMIC.equals(testerExtension.getName())) {
                            tester.add((ECPRendererTester)testerExtension.createExecutableExtension(RENDERER_TESTER));
                        } else if (TEST_STATIC.equals(testerExtension.getName())) {
                            int priority = Integer.parseInt(testerExtension.getAttribute(TESTER_PRIORITY));
                            String vElement = testerExtension.getAttribute(TESTER_VELEMENT);
                            Class supportedEObject = LegacyRendererService.loadClass(testerExtension.getContributor().getName(), vElement);
                            tester.add(new ECPStaticRendererTester(priority, supportedEObject));
                        }
                        ++n6;
                    }
                    this.legacyRenderer.put(tester, renderer);
                }
                catch (CoreException ex) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)ex));
                }
                catch (ClassNotFoundException ex) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)ex));
                }
                catch (InvalidRegistryObjectException ex) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)ex));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        int currentPriority = -1;
        for (Set<ECPRendererTester> testerSet : this.legacyRenderer.keySet()) {
            for (ECPRendererTester tester : testerSet) {
                int testerPriority = tester.isApplicable(vElement, viewModelContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
        }
        return currentPriority;
    }

    public AbstractSWTRenderer<VElement> getRendererInstance(VElement vElement, ViewModelContext viewModelContext) {
        return this.createRenderer(vElement, viewModelContext, this.getFittingRenderer(vElement, viewModelContext));
    }

    private Class<AbstractSWTRenderer<VElement>> getFittingRenderer(VElement vElement, ViewModelContext viewModelContext) {
        int currentPriority = -1;
        Class<AbstractSWTRenderer<VElement>> best = null;
        for (Map.Entry<Set<ECPRendererTester>, Class<AbstractSWTRenderer<VElement>>> testerSet : this.legacyRenderer.entrySet()) {
            for (ECPRendererTester tester : testerSet.getKey()) {
                int testerPriority = tester.isApplicable(vElement, viewModelContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
                best = testerSet.getValue();
            }
        }
        return best;
    }

    private AbstractSWTRenderer<VElement> createRenderer(VElement vElement, ViewModelContext viewContext, Class<? extends AbstractSWTRenderer<VElement>> rendererClass) {
        if (rendererClass == null) {
            this.reportService.report(new AbstractReport(String.format("RendererClass for %1$s is null!", vElement.getName())));
            throw new IllegalStateException(String.format("RendererClass for %1$s is null!", vElement.getName()));
        }
        try {
            return rendererClass.getConstructor(vElement.getClass().getInterfaces()[0], ViewModelContext.class, ReportService.class).newInstance(vElement, viewContext, this.reportService);
        }
        catch (InstantiationException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (IllegalArgumentException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (NoSuchMethodException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (SecurityException ex) {
            this.reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
    }
}

