/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.actions;

import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.service.ElkServicePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferenceAction
extends Action {
    private static final String ACTION_ID = "org.eclipse.elk.debug.actions.preference";
    private static final String ICON_PATH = "icons/preference.gif";
    private final String preferenceId;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener();

    public PreferenceAction(String preferenceId) {
        super("&Log", 2);
        this.setId(ACTION_ID);
        this.setToolTipText("Enables or disables logging information displayed in this view.");
        this.setImageDescriptor(ElkDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.core.debug", (String)ICON_PATH));
        this.preferenceId = preferenceId;
        this.updateCheckedState();
        ElkServicePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
    }

    public void dispose() {
        ElkServicePlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
    }

    public void updateCheckedState() {
        this.setChecked(ElkServicePlugin.getInstance().getPreferenceStore().getBoolean(this.preferenceId));
    }

    public void run() {
        IPreferenceStore prefStore;
        prefStore.setValue(this.preferenceId, !(prefStore = ElkServicePlugin.getInstance().getPreferenceStore()).getBoolean(this.preferenceId));
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(PreferenceAction.this.preferenceId)) {
                PreferenceAction.this.updateCheckedState();
            }
        }
    }
}

