/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.stream.LocatorURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFTP
extends LocatorURL {
    private static Logger log = LoggerFactory.getLogger(LocatorFTP.class);
    private static final String[] schemeNames = new String[]{"ftp"};

    public LocatorFTP() {
        super(schemeNames);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    public TypedInputStream performOpen(String uri) {
        if (uri.startsWith("ftp://")) {
            try {
                URL url = new URL(uri);
                InputStream in = url.openStream();
                ContentType ct = RDFLanguages.guessContentType(uri);
                return new TypedInputStream(in, ct);
            }
            catch (MalformedURLException ex) {
                throw new RiotException("Bad FTP URL: " + uri, ex);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "LocatorFTP";
    }

    @Override
    public int hashCode() {
        return 57;
    }
}

