/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;

@API(status=API.Status.STABLE, since="1.6")
public class NestedMethodSelector
implements DiscoverySelector {
    private final NestedClassSelector nestedClassSelector;
    private final MethodSelector methodSelector;

    NestedMethodSelector(ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName, String parameterTypeNames) {
        this.nestedClassSelector = new NestedClassSelector(classLoader, enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(classLoader, nestedClassName, methodName, parameterTypeNames);
    }

    NestedMethodSelector(ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName, Class<?> ... parameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(classLoader, enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(classLoader, nestedClassName, methodName, parameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, String parameterTypeNames) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName, parameterTypeNames);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, Class<?> ... parameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName, parameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, method);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public ClassLoader getClassLoader() {
        return this.nestedClassSelector.getClassLoader();
    }

    public List<String> getEnclosingClassNames() {
        return this.nestedClassSelector.getEnclosingClassNames();
    }

    public List<Class<?>> getEnclosingClasses() {
        return this.nestedClassSelector.getEnclosingClasses();
    }

    public String getNestedClassName() {
        return this.nestedClassSelector.getNestedClassName();
    }

    public Class<?> getNestedClass() {
        return this.nestedClassSelector.getNestedClass();
    }

    public String getMethodName() {
        return this.methodSelector.getMethodName();
    }

    public Method getMethod() {
        return this.methodSelector.getJavaMethod();
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.10")
    public String getMethodParameterTypes() {
        return this.getParameterTypeNames();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public String getParameterTypeNames() {
        return this.methodSelector.getParameterTypeNames();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public Class<?>[] getParameterTypes() {
        return this.methodSelector.getParameterTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedMethodSelector that = (NestedMethodSelector)o;
        return this.nestedClassSelector.equals(that.nestedClassSelector) && this.methodSelector.equals(that.methodSelector);
    }

    public int hashCode() {
        return Objects.hash(this.nestedClassSelector, this.methodSelector);
    }

    public String toString() {
        return new ToStringBuilder(this).append("enclosingClassNames", this.getEnclosingClassNames()).append("nestedClassName", this.getNestedClassName()).append("methodName", this.getMethodName()).append("parameterTypes", this.getParameterTypeNames()).append("classLoader", this.getClassLoader()).toString();
    }
}

