/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.threading;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="thr", nsUri="http://purl.org/syndication/thread/1.0", localName="in-reply-to")
public class InReplyTo
extends ExtensionPoint {
    static final String XML_NAME = "in-reply-to";
    private static final String HREF = "href";
    private static final String REF = "ref";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    private String href = null;
    private String ref = null;
    private String source = null;
    private String type = null;

    public InReplyTo() {
    }

    public InReplyTo(String href, String ref, String source, String type) {
        this.setHref(href);
        this.setRef(ref);
        this.setSource(source);
        this.setType(type);
        this.setImmutable(true);
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.throwExceptionIfImmutable();
        this.href = href;
    }

    public boolean hasHref() {
        return this.getHref() != null;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.throwExceptionIfImmutable();
        this.ref = ref;
    }

    public boolean hasRef() {
        return this.getRef() != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.throwExceptionIfImmutable();
        this.source = source;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    protected void validate() {
        if (this.ref == null) {
            InReplyTo.throwExceptionForMissingAttribute(REF);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(InReplyTo.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(HREF, this.href);
        generator.put(REF, this.ref);
        generator.put(SOURCE, this.source);
        generator.put(TYPE, this.type);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.href = helper.consume(HREF, false);
        this.ref = helper.consume(REF, true);
        this.source = helper.consume(SOURCE, false);
        this.type = helper.consume(TYPE, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        InReplyTo other = (InReplyTo)obj;
        return InReplyTo.eq(this.href, other.href) && InReplyTo.eq(this.ref, other.ref) && InReplyTo.eq(this.source, other.source) && InReplyTo.eq(this.type, other.type);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.href != null) {
            result = 37 * result + this.href.hashCode();
        }
        if (this.ref != null) {
            result = 37 * result + this.ref.hashCode();
        }
        if (this.source != null) {
            result = 37 * result + this.source.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{InReplyTo href=" + this.href + " ref=" + this.ref + " source=" + this.source + " type=" + this.type + "}";
    }
}

