/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.AttributeTransform;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataImpl;
import com.google.gdata.model.Schema;
import com.google.gdata.util.ParseException;
import com.google.gdata.wireformats.ObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributeMetadataImpl<D>
extends MetadataImpl<D>
implements AttributeMetadata<D> {
    private final AttributeKey<D> attKey;

    AttributeMetadataImpl(Schema schema, AttributeTransform transform, ElementKey<?, ?> parent, AttributeKey<D> key, MetadataContext context) {
        super(schema, transform, parent, key, context);
        this.attKey = key;
    }

    @Override
    public AttributeMetadata<D> bind(MetadataContext context) {
        return this.schema.bind(this.parent, this.attKey, context);
    }

    @Override
    public AttributeKey<D> getKey() {
        return this.attKey;
    }

    @Override
    public Object generateValue(Element element, ElementMetadata<?, ?> metadata) {
        Object result = super.generateValue(element, metadata);
        if (result == null) {
            result = element.getAttributeValue(this.attKey);
        }
        return result;
    }

    @Override
    public void parseValue(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        if (!super.parse(element, metadata, value)) {
            element.setAttributeValue(this.attKey, ObjectConverter.getValue(value, this.attKey.getDatatype()));
        }
    }
}

