/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.features.add.StorageAddFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.BlockDiagramMetaFeatureProvider;
import org.eclipse.fmc.blockdiagram.editor.meta.util.AddConnectionHelper;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.FMCNode;
import org.eclipse.fmc.mm.MultiplicityType;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class StorageAddMetaFeature
extends StorageAddFeature {
    AddConnectionHelper connHelper = null;

    public StorageAddMetaFeature(IFeatureProvider fp, ShapeStyle style) {
        super(fp, style);
    }

    public PictogramElement add(IAddContext context) {
        PictogramElement picEl = super.add(context);
        this.connHelper = new AddConnectionHelper();
        this.connHelper.addStorageConnections(picEl, (BlockDiagramMetaFeatureProvider)this.getFeatureProvider(), this.getDiagram());
        this.checkMultiplicity(picEl);
        return picEl;
    }

    private void checkMultiplicity(PictogramElement picEl) {
        ContainerShape container = (ContainerShape)picEl;
        FMCNode node = (FMCNode)FMCUtil.getBO((PictogramElement)container);
        FMCNodeAlgorithm algorithm = this.factory.getShape((PictogramElement)container);
        if (algorithm == null) {
            return;
        }
        boolean isMultiInstance = algorithm.isMultipleInstances(container);
        if (node.getMultiplicity() == MultiplicityType.MANY != isMultiInstance && !this.isContainerMultiPart(algorithm, container)) {
            algorithm.setMultipleInstances((ContainerShape)picEl, this.getFeatureProvider(), node.getMultiplicity() == MultiplicityType.MANY);
        }
    }

    protected boolean isContainerMultiPart(FMCNodeAlgorithm algorithm, ContainerShape container) {
        if (container.eContainer() == null || !(container.eContainer() instanceof ContainerShape)) {
            return false;
        }
        ContainerShape containerParent = (ContainerShape)container.eContainer();
        return container.getGraphicsAlgorithm().equals(algorithm.getMultiInstanceChild(containerParent, true)) || container.getGraphicsAlgorithm().equals(algorithm.getMultiInstanceChild(containerParent, false));
    }

    public boolean isAvailable(IContext context) {
        if (this.connHelper == null) {
            return super.isAvailable(context);
        }
        if (!this.connHelper.isAvailable(context)) {
            return false;
        }
        return super.isAvailable(context);
    }

    public boolean canExecute(IContext context) {
        if (this.connHelper == null) {
            return super.canExecute(context);
        }
        if (!this.connHelper.canExecute(context)) {
            return false;
        }
        return super.canExecute(context);
    }

    public void execute(IContext context) {
        super.execute(context);
        if (this.connHelper != null) {
            this.connHelper.execute(context);
        }
    }

    public boolean canUndo(IContext context) {
        if (this.connHelper == null) {
            return super.canUndo(context);
        }
        if (!this.connHelper.canUndo(context)) {
            return false;
        }
        return super.canUndo(context);
    }

    public boolean hasDoneChanges() {
        if (this.connHelper == null) {
            return super.hasDoneChanges();
        }
        return this.connHelper.hasDoneChanges() || super.hasDoneChanges();
    }
}

