/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gemini.web.internal.url.WebBundleScanner;
import org.eclipse.gemini.web.internal.url.WebBundleScannerCallback;

class PackagesInWarScanner {
    PackagesInWarScanner() {
    }

    Set<String> getPackagesContainedInWar(URL warURL) throws IOException {
        final HashSet<String> packagesInWar = new HashSet<String>();
        if (warURL != null) {
            WebBundleScanner scanner = new WebBundleScanner(warURL, new WebBundleScannerCallback(){

                @Override
                public void classFound(String entry) {
                    int lastSlashIndex = entry.lastIndexOf(47);
                    if (lastSlashIndex >= 0) {
                        packagesInWar.add(entry.substring(0, lastSlashIndex).replace('/', '.'));
                    }
                }

                @Override
                public void jarFound(String entry) {
                }
            }, true);
            scanner.scanWar();
        }
        return packagesInWar;
    }
}

