/********************************************************************************
 * Copyright (c) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
package org.eclipse.glsp.server.protocol;

public interface ClientSessionListener {

   default void clientConnected(final GLSPClient client) {
      // No-op as default. This enables partial interface implementation.
   }

   default void sessionCreated(final String clientId, final GLSPClient client) {
      // No-op as default. This enables partial interface implementation.
   }

   default void sessionClosed(final String clientId, final GLSPClient client) {
      // No-op as default. This enables partial interface implementation.
   }

   default void clientDisconnected(final GLSPClient client) {
      // No-op as default. This enables partial interface implementation.
   }
}
