/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.diagram;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.BasicActionHandler;
import org.eclipse.glsp.server.diagram.DiagramConfiguration;
import org.eclipse.glsp.server.diagram.DiagramConfigurationRegistry;
import org.eclipse.glsp.server.diagram.RequestTypeHintsAction;
import org.eclipse.glsp.server.diagram.SetTypeHintsAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.utils.ClientOptions;

public class RequestTypeHintsActionHandler
extends BasicActionHandler<RequestTypeHintsAction> {
    private final Logger log = Logger.getLogger(RequestTypeHintsActionHandler.class);
    @Inject
    protected DiagramConfigurationRegistry diagramConfigurationRegistry;

    @Override
    public List<Action> executeAction(RequestTypeHintsAction action, GModelState modelState) {
        Optional<String> diagramType = this.getDiagramType(action, modelState);
        if (!diagramType.isPresent()) {
            this.log.info((Object)"RequestTypeHintsAction failed: No diagram type is present");
            return this.none();
        }
        Optional configuration = this.diagramConfigurationRegistry.get(diagramType.get());
        if (!configuration.isPresent()) {
            this.log.info((Object)("RequestTypeHintsAction failed: No diagram confiuration found for : " + diagramType.get()));
            return this.none();
        }
        return this.listOf(new SetTypeHintsAction(((DiagramConfiguration)configuration.get()).getNodeTypeHints(), ((DiagramConfiguration)configuration.get()).getEdgeTypeHints()));
    }

    private Optional<String> getDiagramType(RequestTypeHintsAction action, GModelState modelState) {
        if (action.getDiagramType() == null && !action.getDiagramType().isEmpty()) {
            return Optional.of(action.getDiagramType());
        }
        return ClientOptions.getValue(modelState.getClientOptions(), "diagramType");
    }
}

