/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.glsp.server.launch.DefaultCLIParser;

public final class LaunchUtil {
    private static Logger LOG = Logger.getLogger(LaunchUtil.class);

    private LaunchUtil() {
    }

    public static boolean isValidPort(Integer port) {
        return port >= 0 && port <= 65535;
    }

    public static void configure(DefaultCLIParser cli) throws ParseException, IOException {
        if (cli.isHelp()) {
            cli.printHelp();
            System.exit(0);
        }
        LaunchUtil.configureLogger(cli);
        if (cli.hasOption("logDir") && !cli.isFileLog()) {
            LOG.warn((Object)String.format("File logging is disabled. The option '--%s' will be ignored.", "logDir"));
        }
    }

    public static void configureLogger(DefaultCLIParser cli) throws ParseException, IOException {
        if (cli.isFileLog()) {
            LaunchUtil.configureLogger(cli.isConsoleLog(), cli.parseLogDir(), cli.parseLogLevel());
        } else {
            LaunchUtil.configureLogger(cli.isConsoleLog(), cli.parseLogLevel());
        }
    }

    public static void configureLogger(boolean logToConsole, Level logLevel) throws IOException {
        LaunchUtil.configureLogger(logToConsole, null, logLevel);
    }

    public static void configureLogger(boolean logToConsole, String logDir, Level logLevel) throws IOException {
        Logger root = Logger.getRootLogger();
        List<ConsoleAppender> consoleAppenders = LaunchUtil.getAppenders(root, ConsoleAppender.class);
        if (logToConsole) {
            if (consoleAppenders.isEmpty()) {
                root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
            }
        } else {
            consoleAppenders.forEach(arg_0 -> ((Logger)root).removeAppender(arg_0));
        }
        if (logDir != null && !logDir.isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy_HH:mm:ss");
            String fileName = String.valueOf(formatter.format(new Date())) + ".log";
            String logFile = new File(logDir, fileName).getAbsolutePath();
            root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), logFile));
        }
        root.setLevel(logLevel);
    }

    public static <T extends Appender> List<T> getAppenders(Logger logger, Class<T> clazz) {
        ArrayList<Appender> result = new ArrayList<Appender>();
        Enumeration allAppenders = logger.getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!clazz.isInstance(appender)) continue;
            result.add((Appender)clazz.cast(appender));
        }
        return result;
    }

    public static void printHelp(String processName, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(90, processName, "\noptions:", options, "", true);
    }

    public static final class DefaultOptions {
        public static final int SERVER_PORT = 5007;
        public static final Level LOG_LEVEL = Level.INFO;
        public static final String LOG_DIR = new File("./logs/").getAbsolutePath();
        public static final boolean CONSOLE_LOG_ENABLED = true;
        public static final boolean FILE_LOG_ENABLED = false;
    }
}

