/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.internal.registry.MapRegistry;

public class DefaultActionRegistry
extends MapRegistry<String, Map<String, Class<? extends Action>>>
implements ActionRegistry {
    protected Map<String, List<String>> serverHandledActionKinds = new HashMap<String, List<String>>();

    @Override
    public boolean register(String diagramType, String actionKind, Class<? extends Action> actionClass, boolean isServerAction) {
        Map actionMap = this.elements.computeIfAbsent(diagramType, k -> new HashMap());
        Class<? extends Action> existing = actionMap.putIfAbsent(actionKind, actionClass);
        if (existing == null && isServerAction) {
            this.serverHandledActionKinds.computeIfAbsent(diagramType, k -> new ArrayList()).add(actionKind);
        } else if (existing != null && existing != actionClass) {
            throw new IllegalArgumentException(String.format("Conflicting registration! Another class is already registered for action kind '%s'. Conflicting classes: '%s', '%s'", actionKind, existing, actionClass));
        }
        return existing == null;
    }

    @Override
    public boolean register(String diagramType, Map<String, Class<? extends Action>> actionMap, boolean isServerAction) {
        return actionMap.entrySet().stream().allMatch(entry -> this.register(diagramType, (String)entry.getKey(), (Class)entry.getValue(), isServerAction));
    }

    @Override
    public boolean deregister(String diagramType) {
        boolean deregistered = super.deregister(diagramType);
        if (deregistered) {
            this.serverHandledActionKinds.remove(diagramType);
        }
        return deregistered;
    }

    @Override
    public List<String> getServerHandledAction(String diagramType) {
        return this.serverHandledActionKinds.computeIfAbsent(diagramType, k -> new ArrayList());
    }

    @Override
    public Map<String, List<String>> getServerHandledActions() {
        return this.serverHandledActionKinds;
    }

    @Override
    public Map<String, Class<? extends Action>> getAllAsMap() {
        HashMap<String, Class<? extends Action>> result = new HashMap<String, Class<? extends Action>>();
        this.getAll().forEach(actionMap -> result.putAll((Map<String, Class<? extends Action>>)actionMap));
        return result;
    }
}

