/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.layout;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.RecursiveGraphLayoutEngine;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GEdgeLayoutable;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GLayouting;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GPort;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.layout.GLSPLayoutConfigurator;
import org.eclipse.glsp.server.layout.LayoutEngine;
import org.eclipse.glsp.server.model.GModelState;

public class ElkLayoutEngine
implements LayoutEngine {
    public static final IProperty<String> P_TYPE = new Property("org.eclipse.sprotty.layout.type");
    @Inject
    protected GModelState modelState;
    private IGraphLayoutEngine engine = new RecursiveGraphLayoutEngine();
    protected final ElkGraphFactory factory = ElkGraphFactory.eINSTANCE;

    public static void initialize(ILayoutMetaDataProvider ... providers) {
        LayoutMetaDataService.getInstance().registerLayoutMetaDataProviders(providers);
    }

    public void layout() {
        if (this.modelState.getRoot() instanceof GGraph) {
            this.layout((GGraph)this.modelState.getRoot(), null);
        }
    }

    public void layout(GGraph ggraph, GLSPLayoutConfigurator configurator) {
        LayoutContext context = this.transformGraph(ggraph);
        if (configurator != null) {
            ElkUtil.applyVisitors((ElkNode)context.elkGraph, (IGraphElementVisitor[])new IGraphElementVisitor[]{configurator});
        }
        this.applyEngine(context.elkGraph);
        this.transferLayout(context);
    }

    protected LayoutContext transformGraph(GGraph ggraph) {
        ElkNode rootNode;
        LayoutContext context = new LayoutContext();
        context.ggraph = ggraph;
        context.elkGraph = rootNode = this.createGraph(ggraph);
        context.shapeMap.put((GModelElement)ggraph, (ElkShape)rootNode);
        this.processChildren((GModelElement)ggraph, (ElkGraphElement)rootNode, context);
        this.resolveReferences(context);
        return context;
    }

    protected ElkNode createGraph(GGraph ggraph) {
        ElkNode elkGraph = this.factory.createElkNode();
        elkGraph.setIdentifier(GLSPLayoutConfigurator.toElkId(ggraph.getId()));
        elkGraph.setProperty(P_TYPE, (Object)ggraph.getType());
        return elkGraph;
    }

    protected int processChildren(GModelElement sParent, ElkGraphElement elkParent, LayoutContext context) {
        int childrenCount = 0;
        if (sParent.getChildren() != null) {
            for (GModelElement schild : sParent.getChildren()) {
                context.parentMap.put(schild, sParent);
                ElkGraphElement elkChild = null;
                if (this.shouldInclude(schild, sParent, elkParent, context)) {
                    if (schild instanceof GNode) {
                        GNode snode = (GNode)schild;
                        ElkNode elkNode = this.createNode(snode);
                        if (elkParent instanceof ElkNode) {
                            elkNode.setParent((ElkNode)elkParent);
                            ++childrenCount;
                        }
                        context.shapeMap.put((GModelElement)snode, (ElkShape)elkNode);
                        elkChild = elkNode;
                    } else if (schild instanceof GPort) {
                        GPort gport = (GPort)schild;
                        ElkPort elkPort = this.createPort(gport);
                        if (elkParent instanceof ElkNode) {
                            elkPort.setParent((ElkNode)elkParent);
                            ++childrenCount;
                        }
                        context.shapeMap.put((GModelElement)gport, (ElkShape)elkPort);
                        elkChild = elkPort;
                    } else if (schild instanceof GEdge) {
                        GEdge gedge = (GEdge)schild;
                        ElkEdge elkEdge = this.createEdge(gedge);
                        ++childrenCount;
                        context.edgeMap.put(gedge, elkEdge);
                        elkChild = elkEdge;
                    } else if (schild instanceof GLabel) {
                        GLabel glabel = (GLabel)schild;
                        ElkLabel elkLabel = this.createLabel(glabel);
                        elkLabel.setParent(elkParent);
                        ++childrenCount;
                        context.shapeMap.put((GModelElement)glabel, (ElkShape)elkLabel);
                        elkChild = elkLabel;
                    }
                }
                int grandChildrenCount = this.processChildren(schild, elkChild != null ? elkChild : elkParent, context);
                childrenCount += grandChildrenCount;
                if (grandChildrenCount <= 0 || !(sParent instanceof GLayouting) || !(schild instanceof GBoundsAware)) continue;
                this.handleClientLayout((GBoundsAware)schild, (GLayouting)sParent, elkParent, context);
            }
        }
        return childrenCount;
    }

    protected boolean shouldInclude(GModelElement element, GModelElement sParent, ElkGraphElement elkParent, LayoutContext context) {
        String layout;
        if (element instanceof GNode || element instanceof GPort) {
            return elkParent instanceof ElkNode;
        }
        if (element instanceof GEdge) {
            return true;
        }
        return !(sParent instanceof GLayouting ? (layout = ((GLayouting)sParent).getLayout()) != null && !layout.isEmpty() : element instanceof GEdgeLayoutable && ((GEdgeLayoutable)element).getEdgePlacement() != null);
    }

    protected void handleClientLayout(GBoundsAware element, GLayouting sParent, ElkGraphElement elkParent, LayoutContext context) {
        String layout = sParent.getLayout();
        if (layout != null && !layout.isEmpty()) {
            GDimension parentSize;
            GDimension size;
            GPoint position = element.getPosition();
            if (position == null) {
                position = GraphFactory.eINSTANCE.createGPoint();
            }
            if ((size = element.getSize()) == null) {
                size = GraphFactory.eINSTANCE.createGDimension();
            }
            ElkPadding padding = new ElkPadding();
            padding.setLeft(position.getX());
            padding.setTop(position.getY());
            if (sParent instanceof GBoundsAware && (parentSize = ((GBoundsAware)sParent).getSize()) != null) {
                padding.setRight(parentSize.getWidth() - position.getX() - size.getWidth());
                padding.setBottom(parentSize.getHeight() - position.getY() - size.getHeight());
            }
            if (elkParent.hasProperty(CoreOptions.PADDING)) {
                padding.add((Spacing)elkParent.getProperty(CoreOptions.PADDING));
            }
            elkParent.setProperty(CoreOptions.PADDING, (Object)padding);
        }
    }

    protected void resolveReferences(LayoutContext context) {
        HashMap id2NodeMap = Maps.newHashMapWithExpectedSize((int)context.shapeMap.size());
        for (Map.Entry<GModelElement, ElkShape> entry : context.shapeMap.entrySet()) {
            String id = entry.getKey().getId();
            if (id == null || !(entry.getValue() instanceof ElkConnectableShape)) continue;
            id2NodeMap.put(id, (ElkConnectableShape)entry.getValue());
        }
        for (Map.Entry<GModelElement, ElkShape> entry : context.edgeMap.entrySet()) {
            this.resolveReferences((ElkEdge)entry.getValue(), (GEdge)entry.getKey(), id2NodeMap, context);
        }
    }

    protected void resolveReferences(ElkEdge elkEdge, GEdge gedge, Map<String, ElkConnectableShape> id2NodeMap, LayoutContext context) {
        ElkConnectableShape source = id2NodeMap.get(gedge.getSourceId());
        ElkConnectableShape target = id2NodeMap.get(gedge.getTargetId());
        if (source != null && target != null) {
            elkEdge.getSources().add((Object)source);
            elkEdge.getTargets().add((Object)target);
            ElkNode container = ElkGraphUtil.findBestEdgeContainment((ElkEdge)elkEdge);
            if (container != null) {
                elkEdge.setContainingNode(container);
            } else {
                elkEdge.setContainingNode(context.elkGraph);
            }
        }
    }

    protected ElkNode createNode(GNode snode) {
        ElkNode elkNode = this.factory.createElkNode();
        elkNode.setIdentifier(GLSPLayoutConfigurator.toElkId(snode.getId()));
        elkNode.setProperty(P_TYPE, (Object)snode.getType());
        this.applyBounds((GBoundsAware)snode, (ElkShape)elkNode);
        return elkNode;
    }

    protected ElkPort createPort(GPort gport) {
        ElkPort elkPort = this.factory.createElkPort();
        elkPort.setIdentifier(GLSPLayoutConfigurator.toElkId(gport.getId()));
        elkPort.setProperty(P_TYPE, (Object)gport.getType());
        this.applyBounds((GBoundsAware)gport, (ElkShape)elkPort);
        return elkPort;
    }

    protected ElkEdge createEdge(GEdge gedge) {
        ElkEdge elkEdge = this.factory.createElkEdge();
        elkEdge.setIdentifier(GLSPLayoutConfigurator.toElkId(gedge.getId()));
        elkEdge.setProperty(P_TYPE, (Object)gedge.getType());
        return elkEdge;
    }

    protected ElkLabel createLabel(GLabel glabel) {
        ElkLabel elkLabel = this.factory.createElkLabel();
        elkLabel.setIdentifier(GLSPLayoutConfigurator.toElkId(glabel.getId()));
        elkLabel.setProperty(P_TYPE, (Object)glabel.getType());
        elkLabel.setText(glabel.getText());
        this.applyBounds((GBoundsAware)glabel, (ElkShape)elkLabel);
        return elkLabel;
    }

    protected void applyBounds(GBoundsAware bounds, ElkShape elkShape) {
        GDimension size;
        GPoint position = bounds.getPosition();
        if (position != null) {
            elkShape.setX(position.getX());
            elkShape.setY(position.getY());
        }
        if ((size = bounds.getSize()) != null) {
            if (size.getWidth() >= 0.0) {
                elkShape.setWidth(size.getWidth());
            }
            if (size.getHeight() >= 0.0) {
                elkShape.setHeight(size.getHeight());
            }
        }
    }

    public void setEngine(IGraphLayoutEngine engine) {
        if (engine == null) {
            throw new NullPointerException();
        }
        this.engine = engine;
    }

    public IGraphLayoutEngine getEngine() {
        return this.engine;
    }

    protected void applyEngine(ElkNode elkGraph) {
        this.getEngine().layout(elkGraph, (IElkProgressMonitor)new BasicProgressMonitor());
    }

    protected void transferLayout(LayoutContext context) {
        this.transferLayout((GModelElement)context.ggraph, context);
    }

    protected void transferLayout(GModelElement element, LayoutContext context) {
        GLabel glabel;
        ElkLabel elkLabel;
        if (element instanceof GGraph) {
            this.transferGraphLayout((GGraph)element, context.elkGraph, context);
        } else if (element instanceof GNode) {
            GNode snode = (GNode)element;
            ElkNode elkNode = (ElkNode)context.shapeMap.get(snode);
            if (elkNode != null) {
                this.transferNodeLayout(snode, elkNode, context);
            }
        } else if (element instanceof GPort) {
            GPort gport = (GPort)element;
            ElkPort elkPort = (ElkPort)context.shapeMap.get(gport);
            if (elkPort != null) {
                this.transferPortLayout(gport, elkPort, context);
            }
        } else if (element instanceof GEdge) {
            GEdge gedge = (GEdge)element;
            ElkEdge elkEdge = context.edgeMap.get(gedge);
            if (elkEdge != null) {
                this.transferEdgeLayout(gedge, elkEdge, context);
            }
        } else if (element instanceof GLabel && (elkLabel = (ElkLabel)context.shapeMap.get(glabel = (GLabel)element)) != null) {
            this.transferLabelLayout(glabel, elkLabel, context);
        }
        if (element.getChildren() != null) {
            for (GModelElement child : element.getChildren()) {
                this.transferLayout(child, context);
            }
        }
    }

    protected void transferGraphLayout(GGraph ggraph, ElkNode elkGraph, LayoutContext context) {
        ggraph.setPosition(GraphUtil.point((double)elkGraph.getX(), (double)elkGraph.getY()));
        ggraph.setSize(GraphUtil.dimension((double)elkGraph.getWidth(), (double)elkGraph.getHeight()));
    }

    protected void transferNodeLayout(GNode snode, ElkNode elkNode, LayoutContext context) {
        GPoint offset = this.getOffset((GModelElement)snode, (ElkGraphElement)elkNode, context);
        snode.setPosition(GraphUtil.point((double)(elkNode.getX() + offset.getX()), (double)(elkNode.getY() + offset.getY())));
        snode.setSize(GraphUtil.dimension((double)elkNode.getWidth(), (double)elkNode.getHeight()));
    }

    protected void transferPortLayout(GPort gport, ElkPort elkPort, LayoutContext context) {
        GPoint offset = this.getOffset((GModelElement)gport, (ElkGraphElement)elkPort, context);
        gport.setPosition(GraphUtil.point((double)(elkPort.getX() + offset.getX()), (double)(elkPort.getY() + offset.getY())));
        gport.setSize(GraphUtil.dimension((double)elkPort.getWidth(), (double)elkPort.getHeight()));
    }

    protected void transferLabelLayout(GLabel glabel, ElkLabel elkLabel, LayoutContext context) {
        GPoint offset = this.getOffset((GModelElement)glabel, (ElkGraphElement)elkLabel, context);
        glabel.setPosition(GraphUtil.point((double)(elkLabel.getX() + offset.getX()), (double)(elkLabel.getY() + offset.getY())));
        glabel.setSize(GraphUtil.dimension((double)elkLabel.getWidth(), (double)elkLabel.getHeight()));
    }

    protected void transferEdgeLayout(GEdge gedge, ElkEdge elkEdge, LayoutContext context) {
        if (!elkEdge.getSections().isEmpty()) {
            GPoint offset = this.getOffset((GModelElement)gedge, (ElkGraphElement)elkEdge, context);
            ElkEdgeSection section = (ElkEdgeSection)elkEdge.getSections().get(0);
            ArrayList<GPoint> newRoutingPoints = new ArrayList<GPoint>();
            GPoint p1 = GraphUtil.point((double)(section.getStartX() + offset.getX()), (double)(section.getStartY() + offset.getY()));
            newRoutingPoints.add(p1);
            for (ElkBendPoint bendGPoint : section.getBendPoints()) {
                GPoint p2 = GraphUtil.point((double)(bendGPoint.getX() + offset.getX()), (double)(bendGPoint.getY() + offset.getY()));
                newRoutingPoints.add(p2);
            }
            GPoint p3 = GraphUtil.point((double)(section.getEndX() + offset.getX()), (double)(section.getEndY() + offset.getY()));
            newRoutingPoints.add(p3);
            EList routingPoints = gedge.getRoutingPoints();
            routingPoints.clear();
            routingPoints.addAll(newRoutingPoints);
        }
    }

    protected GPoint getOffset(GModelElement gelem, ElkGraphElement elkElem, LayoutContext context) {
        LinkedList<GModelElement> sParents = null;
        GModelElement currentSParent = gelem;
        while (currentSParent != null) {
            if ((currentSParent = context.parentMap.get(currentSParent)) == null) continue;
            ElkShape shapeForSParent = context.shapeMap.get(currentSParent);
            if (shapeForSParent == elkElem.eContainer()) {
                double x = 0.0;
                double y = 0.0;
                if (sParents != null) {
                    for (GModelElement sParent : sParents) {
                        if (!(sParent instanceof GBoundsAware)) continue;
                        GPoint gPoint = ((GBoundsAware)sParent).getPosition();
                        x -= gPoint.getX();
                        y -= gPoint.getY();
                    }
                }
                return GraphUtil.point((double)x, (double)y);
            }
            if (sParents == null) {
                sParents = new LinkedList<GModelElement>();
            }
            sParents.addFirst(currentSParent);
        }
        LinkedList<ElkGraphElement> elkParents = new LinkedList<ElkGraphElement>();
        ElkGraphElement currentElkParent = elkElem;
        while (currentElkParent != null) {
            if ((currentElkParent = currentElkParent.eContainer()) == null) continue;
            elkParents.addFirst(currentElkParent);
        }
        boolean foundMismatch = false;
        do {
            ElkShape shapeForSParent = null;
            int nextSParentIndex = 0;
            while (shapeForSParent == null && nextSParentIndex < sParents.size()) {
                shapeForSParent = context.shapeMap.get(sParents.get(nextSParentIndex++));
            }
            ElkShape elkParentShape = null;
            while (elkParentShape == null && !elkParents.isEmpty()) {
                EObject elkParent = (EObject)elkParents.getFirst();
                if (elkParent instanceof ElkShape) {
                    elkParentShape = (ElkShape)elkParent;
                    continue;
                }
                elkParents.removeFirst();
            }
            if (shapeForSParent != null && shapeForSParent == elkParentShape) {
                int i = 0;
                while (i < nextSParentIndex) {
                    sParents.removeFirst();
                    ++i;
                }
                elkParents.removeFirst();
                continue;
            }
            foundMismatch = true;
        } while (!foundMismatch && !sParents.isEmpty() && !elkParents.isEmpty());
        double x = 0.0;
        double y = 0.0;
        for (EObject eObject : elkParents) {
            if (!(eObject instanceof ElkShape)) continue;
            ElkShape elkShape = (ElkShape)eObject;
            x += elkShape.getX();
            y += elkShape.getY();
        }
        for (GModelElement gModelElement : sParents) {
            if (!(gModelElement instanceof GBoundsAware)) continue;
            GPoint position = ((GBoundsAware)gModelElement).getPosition();
            x -= position.getX();
            y -= position.getY();
        }
        return GraphUtil.point((double)x, (double)y);
    }

    protected static class LayoutContext {
        public GGraph ggraph;
        public ElkNode elkGraph;
        public final Map<GModelElement, GModelElement> parentMap = Maps.newHashMap();
        public final Map<GModelElement, ElkShape> shapeMap = Maps.newLinkedHashMap();
        public final Map<GEdge, ElkEdge> edgeMap = Maps.newLinkedHashMap();

        protected LayoutContext() {
        }
    }
}

