/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.common.factory.OConfigurableStatefulFactory;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.intent.OIntentMassiveRead;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.orientdb.OrientEdge;
import org.eclipse.hawk.orientdb.OrientIndexStore;
import org.eclipse.hawk.orientdb.OrientNode;
import org.eclipse.hawk.orientdb.OrientNodeIterable;
import org.eclipse.hawk.orientdb.OrientTransaction;
import org.eclipse.hawk.orientdb.cache.ORecordCacheGuava;
import org.eclipse.hawk.orientdb.indexes.OrientNodeIndex;
import org.eclipse.hawk.orientdb.util.OrientClusterDocumentIterable;
import org.eclipse.hawk.orientdb.util.OrientNameCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDatabase
implements IGraphDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientDatabase.class);
    private static final String EDGE_TYPE = "E";
    private static final String VCLASS = "hawkIndexStore";
    static final String VERTEX_TYPE_PREFIX = "V_";
    static final String METAMODEL_IDX_NAME = "hawkMetamodelIndex";
    static final String FILE_IDX_NAME = "hawkFileIndex";
    private static final String SIZE_THRESHOLD_PROPERTY = "hawk.orient.periodicSaveThreshold";
    private static final int DEFAULT_SIZE_THRESHOLD = 200000;
    private static final int SIZE_THRESHOLD;
    private File storageFolder;
    private File tempFolder;
    private IConsole console;
    private IGraphNodeIndex metamodelIndex;
    private IGraphNodeIndex fileIndex;
    private IGraphDatabase.Mode currentMode;
    private Map<String, OrientNode> dirtyNodes = new HashMap<String, OrientNode>(SIZE_THRESHOLD);
    private Map<String, OrientEdge> dirtyEdges = new HashMap<String, OrientEdge>(SIZE_THRESHOLD);
    private final ThreadLocal<ODatabaseDocumentTx> dbConn = new ThreadLocal();
    private GenericObjectPool<ODatabaseDocumentTx> pool;
    private final Set<ODatabaseDocumentTx> allConns = Collections.newSetFromMap(new ConcurrentHashMap(Runtime.getRuntime().availableProcessors() * 2, 0.9f, 1));
    private static final String POOL_SIZE_PROPERTY = "hawk.orient.maxConnections";
    protected String dbURL;
    private Set<OrientNodeIndex> postponedIndexes = new HashSet<OrientNodeIndex>();
    private OrientIndexStore indexStore;

    static {
        String sPropThreshold = System.getProperty(SIZE_THRESHOLD_PROPERTY);
        int threshold = 200000;
        if (sPropThreshold != null) {
            try {
                threshold = Integer.valueOf(sPropThreshold);
            }
            catch (NumberFormatException ex) {
                LOGGER.error(String.format("Invalid value for -D%s: '%s' is not an integer", SIZE_THRESHOLD_PROPERTY, sPropThreshold));
            }
        }
        SIZE_THRESHOLD = threshold;
        OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.setValue((Object)true);
        OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.setValue((Object)102400);
        OConfigurableStatefulFactory factory = (OConfigurableStatefulFactory)Orient.instance().getLocalRecordCache();
        factory.register((Object)ORecordCacheGuava.class.getName(), ORecordCacheGuava.class);
        if (System.getProperty(OGlobalConfiguration.CACHE_LOCAL_IMPL.getKey()) == null) {
            OGlobalConfiguration.CACHE_LOCAL_IMPL.setValue((Object)ORecordCacheGuava.class.getName());
        }
    }

    public String getPath() {
        return this.storageFolder.getPath();
    }

    public void run(File parentfolder, IConsole c) {
        try {
            this.run("plocal:" + parentfolder.getAbsolutePath(), parentfolder, c);
        }
        catch (Exception e) {
            c.printerrln((Throwable)e);
        }
    }

    public void run(String iURL, File parentfolder, IConsole c) throws Exception {
        this.storageFolder = parentfolder;
        this.tempFolder = new File(this.storageFolder, "temp");
        this.console = c;
        this.console.println("Starting database " + iURL);
        this.dbURL = iURL;
        this.pool = new GenericObjectPool((PooledObjectFactory)new OrientConnectionFactory());
        this.pool.setMinIdle(0);
        this.pool.setMaxIdle(2);
        this.pool.setMaxTotal(this.getPoolSize());
        this.pool.setMinEvictableIdleTimeMillis(20000L);
        this.pool.setBlockWhenExhausted(true);
        this.metamodelIndex = this.getOrCreateNodeIndex(METAMODEL_IDX_NAME);
        this.fileIndex = this.getOrCreateNodeIndex(FILE_IDX_NAME);
        this.exitBatchMode();
    }

    protected int getPoolSize() {
        int poolSize = Runtime.getRuntime().availableProcessors() * 2;
        String sPoolSize = System.getProperty(POOL_SIZE_PROPERTY);
        if (sPoolSize != null) {
            try {
                poolSize = Math.max(1, Integer.valueOf(sPoolSize));
            }
            catch (NumberFormatException ex) {
                LOGGER.error("{} has invalid value '{}': falling back to {}", new Object[]{POOL_SIZE_PROPERTY, sPoolSize, poolSize});
            }
        }
        return poolSize;
    }

    public void shutdown() throws Exception {
        this.shutdown(false);
    }

    public void delete() throws Exception {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean delete) throws Exception {
        if (this.pool == null || this.pool.isClosed()) {
            return;
        }
        ODatabaseDocumentTx db = this.getGraphNoCreate();
        if (delete) {
            this.discardDirty();
        } else {
            this.saveDirty();
        }
        Set<ODatabaseDocumentTx> set = this.allConns;
        synchronized (set) {
            for (ODatabaseDocumentTx conn : this.allConns) {
                if (conn == db) continue;
                this.pool.invalidateObject((Object)conn);
            }
            this.dbConn.get().activateOnCurrentThread();
            OStorage storage = db.getStorage();
            if (delete) {
                db.drop();
            } else {
                db.close();
            }
            storage.close(true, false);
            Orient.instance().unregisterStorage(storage);
            this.pool.invalidateObject((Object)db);
            if (delete && this.storageFolder != null) {
                try {
                    OrientDatabase.deleteRecursively(this.storageFolder);
                }
                catch (IOException e) {
                    this.console.printerrln((Throwable)e);
                }
            }
            this.pool.clear();
        }
        this.fileIndex = null;
        this.metamodelIndex = null;
        this.tempFolder = null;
        this.storageFolder = null;
    }

    public IGraphNodeIndex getOrCreateNodeIndex(String name) {
        return new OrientNodeIndex(name, this);
    }

    public IGraphNodeIndex getMetamodelIndex() {
        return this.metamodelIndex;
    }

    public IGraphNodeIndex getFileIndex() {
        return this.fileIndex;
    }

    public OrientTransaction beginTransaction() {
        if (!this.getGraph().getTransaction().isActive()) {
            this.exitBatchMode();
        }
        return new OrientTransaction(this);
    }

    public boolean isTransactional() {
        return true;
    }

    public void enterBatchMode() {
        ODatabaseDocumentTx db = this.getGraph();
        if (db.getTransaction().isActive()) {
            this.saveDirty();
            db.commit();
        }
        this.currentMode = IGraphDatabase.Mode.NO_TX_MODE;
    }

    protected void releaseConnection() {
        ODatabaseDocumentTx db = this.dbConn.get();
        if (db != null) {
            if (db.getTransaction().isActive()) {
                db.getTransaction().close();
            }
            this.pool.returnObject((Object)db);
        }
    }

    public void saveDirty() {
        boolean hadDirty = !this.dirtyNodes.isEmpty() || !this.dirtyEdges.isEmpty();
        Iterator<OrientNode> itNode = this.dirtyNodes.values().iterator();
        while (itNode.hasNext()) {
            OrientNode on = itNode.next();
            on.save();
            itNode.remove();
        }
        Iterator<OrientEdge> itEdge = this.dirtyEdges.values().iterator();
        while (itEdge.hasNext()) {
            OrientEdge oe = itEdge.next();
            oe.save();
            itEdge.remove();
        }
        if (hadDirty) {
            ODatabaseDocumentTx conn2;
            for (ODatabaseDocumentTx conn2 : this.allConns) {
                conn2.activateOnCurrentThread();
                conn2.getLocalCache().invalidate();
            }
            conn2 = this.dbConn.get();
            if (conn2 != null) {
                conn2.activateOnCurrentThread();
            }
        }
    }

    public void exitBatchMode() {
        ODatabaseDocumentTx db = this.getGraph();
        if (!db.getTransaction().isActive()) {
            this.saveDirty();
            this.getGraph().commit();
        }
        this.currentMode = IGraphDatabase.Mode.TX_MODE;
    }

    public OrientNodeIterable allNodes(String label) {
        String vertexTypeName = this.getVertexTypeName(label);
        return new OrientNodeIterable(new OrientClusterDocumentIterable(vertexTypeName, this), this);
    }

    public OrientNode createNode(Map<String, Object> properties, String label) {
        String vertexTypeName = this.getVertexTypeName(label);
        this.ensureClassExists(vertexTypeName);
        ODocument newDoc = new ODocument(vertexTypeName);
        if (properties != null) {
            OrientNode.setProperties(newDoc, properties);
        }
        newDoc.save(vertexTypeName);
        if (newDoc.getIdentity().isPersistent()) {
            return new OrientNode(newDoc.getIdentity(), this);
        }
        return new OrientNode(newDoc, this);
    }

    private void ensureClassExists(String className) {
        ODatabaseDocumentTx db = this.getGraph();
        OSchemaProxy schema = db.getMetadata().getSchema();
        if (!schema.existsClass(className)) {
            boolean wasInTX = db.getTransaction().isActive();
            if (wasInTX) {
                LOGGER.warn("Warning: premature commit needed to create class {}", (Object)className);
                this.saveDirty();
                this.getGraph().commit();
            }
            OClass oClass = schema.createClass(className);
            if (className.startsWith(VERTEX_TYPE_PREFIX)) {
                OClass baseVertexClass = schema.getClass("V");
                if (baseVertexClass == null) {
                    baseVertexClass = schema.createClass("V");
                    baseVertexClass.setOverSize(2.0f);
                }
                oClass.addSuperClass(baseVertexClass);
                OrientNode.setupDocumentClass(oClass);
            } else if (EDGE_TYPE.equals(className)) {
                OrientEdge.setupDocumentClass(oClass);
            }
            if (wasInTX) {
                db.begin();
            }
        }
    }

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type) {
        Map<String, Object> props = Collections.emptyMap();
        return this.createRelationship(start, end, type, props);
    }

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type, Map<String, Object> props) {
        OrientNode oStart = (OrientNode)start;
        OrientNode oEnd = (OrientNode)end;
        String edgeTypeName = this.getEdgeTypeName(type);
        this.ensureClassExists(edgeTypeName);
        IGraphEdge newEdge = OrientEdge.create(this, oStart, oEnd, type, edgeTypeName, props);
        this.dirtyNodes.put(oStart.getId().toString(), oStart);
        this.dirtyNodes.put(oEnd.getId().toString(), oEnd);
        this.saveIfBig();
        return newEdge;
    }

    private void saveIfBig() {
        int totalSize = this.dirtyNodes.size() + this.dirtyEdges.size();
        if (totalSize > SIZE_THRESHOLD) {
            this.saveDirty();
        }
    }

    private String getVertexTypeName(String label) {
        return OrientNameCleaner.escapeClass(VERTEX_TYPE_PREFIX + label);
    }

    private String getEdgeTypeName(String label) {
        return EDGE_TYPE;
    }

    public ODatabaseDocumentTx getGraph() {
        ODatabaseDocumentTx db = this.getGraphNoCreate();
        if (!this.exists(db)) {
            db.create();
            db.command((OCommandRequest)new OCommandSQL("ALTER DATABASE CUSTOM useLightweightEdges = true")).execute(new Object[0]);
        }
        return db;
    }

    protected boolean exists(ODatabaseDocumentTx db) {
        return db.exists();
    }

    protected ODatabaseDocumentTx getGraphNoCreate() {
        ODatabaseDocumentTx conn = this.dbConn.get();
        if (conn != null) {
            conn.activateOnCurrentThread();
            if (!conn.isClosed()) {
                return conn;
            }
        }
        try {
            return (ODatabaseDocumentTx)this.pool.borrowObject();
        }
        catch (Exception e) {
            LOGGER.error("Error opening connection to Orient", (Throwable)e);
            return null;
        }
    }

    public OrientNode getNodeById(Object id) {
        String sID;
        OrientNode result;
        if (id instanceof String) {
            id = new ORecordId(id.toString());
        }
        if ((result = this.dirtyNodes.get(sID = id instanceof ODocument ? ((ODocument)id).getIdentity().toString() : id.toString())) == null) {
            result = id instanceof ODocument ? new OrientNode(((ODocument)id).getIdentity(), this) : new OrientNode((ORID)id, this);
        }
        return result;
    }

    public OrientEdge getEdgeById(Object id) {
        String sID;
        OrientEdge dirtyEdge;
        if (id instanceof String) {
            id = new ORecordId(id.toString());
        }
        if ((dirtyEdge = this.dirtyEdges.get(sID = id instanceof ODocument ? ((ODocument)id).getIdentity().toString() : id.toString())) != null) {
            return dirtyEdge;
        }
        if (id instanceof ODocument) {
            return new OrientEdge((ODocument)id, this);
        }
        return new OrientEdge((ORID)id, this);
    }

    public boolean nodeIndexExists(String name) {
        return this.getIndexStore().getNodeIndexNames().contains(name);
    }

    public String getHumanReadableName() {
        return "OrientDB Database";
    }

    public String getTempDir() {
        return this.tempFolder.getAbsolutePath();
    }

    public IGraphDatabase.Mode currentMode() {
        return this.currentMode;
    }

    public Set<String> getNodeIndexNames() {
        return new HashSet<String>(this.getIndexStore().getNodeIndexNames());
    }

    public Set<String> getKnownMMUris() {
        HashSet<String> mmURIs = new HashSet<String>();
        for (IGraphNode node : this.getMetamodelIndex().query("*", (Object)"*")) {
            String mmURI = (String)node.getProperty("_hawkid");
            mmURIs.add(mmURI);
        }
        return mmURIs;
    }

    public OrientIndexStore getIndexStore() {
        if (this.indexStore != null) {
            return this.indexStore;
        }
        ODocument idIndexStore = (ODocument)this.getGraph().getDictionary().get(VCLASS);
        if (idIndexStore == null) {
            HashMap idxStoreProps = new HashMap();
            IGraphNode vIndexStore = this.createNode((Map)idxStoreProps, VCLASS);
            this.getGraph().getDictionary().put(VCLASS, (Object)vIndexStore.getDocument());
            this.indexStore = new OrientIndexStore((OrientNode)vIndexStore);
        } else {
            this.indexStore = new OrientIndexStore(new OrientNode(idIndexStore.getIdentity(), this));
        }
        return this.indexStore;
    }

    private static void deleteRecursively(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public <T> T getElementById(ORID id, Class<T> klass) {
        if (klass == OrientEdge.class || klass == IGraphEdge.class) {
            return (T)this.getEdgeById(id);
        }
        if (klass == OrientNode.class || klass == IGraphNode.class) {
            return (T)this.getNodeById(id);
        }
        return null;
    }

    public void markNodeAsDirty(OrientNode orientNode) {
        ORID id = orientNode.getId();
        this.dirtyNodes.put(id.toString(), orientNode);
        this.deleteFromAllCaches(id);
        this.saveIfBig();
    }

    public void unmarkNodeAsDirty(OrientNode orientNode) {
        this.dirtyNodes.remove("" + orientNode.getId());
    }

    public void markEdgeAsDirty(OrientEdge orientEdge) {
        ORID id = orientEdge.getId();
        this.dirtyEdges.put(id.toString(), orientEdge);
        this.deleteFromAllCaches(id);
        this.saveIfBig();
    }

    public void unmarkEdgeAsDirty(OrientEdge orientEdge) {
        this.dirtyEdges.remove("" + orientEdge.getId());
    }

    public void discardDirty() {
        this.dirtyNodes.clear();
        this.dirtyEdges.clear();
    }

    protected void deleteFromAllCaches(ORID id) {
        for (ODatabaseDocumentTx conn : this.allConns) {
            conn.activateOnCurrentThread();
            conn.getLocalCache().deleteRecord(id);
        }
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void addPostponedIndex(OrientNodeIndex orientNodeIndex) {
        this.postponedIndexes.add(orientNodeIndex);
    }

    public void clearPostponedIndexes() {
        for (OrientNodeIndex idx : this.postponedIndexes) {
            idx.getPostponedIndexAdditions().clear();
        }
        this.postponedIndexes.clear();
    }

    public void processPostponedIndexes() {
        if (this.postponedIndexes.isEmpty()) {
            return;
        }
        for (OrientNodeIndex idx : this.postponedIndexes) {
            for (OrientNodeIndex.PostponedIndexAdd addition : idx.getPostponedIndexAdditions()) {
                addition.getIndex().put(addition.getKey(), addition.getValue());
            }
            idx.getPostponedIndexAdditions().clear();
        }
    }

    private final class OrientConnectionFactory
    extends BasePooledObjectFactory<ODatabaseDocumentTx> {
        private OrientConnectionFactory() {
        }

        public void destroyObject(PooledObject<ODatabaseDocumentTx> pooled) throws Exception {
            ODatabaseDocumentTx db = (ODatabaseDocumentTx)pooled.getObject();
            OrientDatabase.this.allConns.remove(db);
            db.activateOnCurrentThread();
            db.close();
        }

        public void passivateObject(PooledObject<ODatabaseDocumentTx> p) throws Exception {
            super.passivateObject(p);
            OrientDatabase.this.dbConn.set(null);
        }

        public void activateObject(PooledObject<ODatabaseDocumentTx> p) throws Exception {
            super.activateObject(p);
            ODatabaseDocumentTx db = (ODatabaseDocumentTx)p.getObject();
            OrientDatabase.this.dbConn.set(db);
            db.activateOnCurrentThread();
        }

        public ODatabaseDocumentTx create() throws Exception {
            ODatabaseDocumentTx db = new ODatabaseDocumentTx(OrientDatabase.this.dbURL);
            if (OrientDatabase.this.exists(db)) {
                db.open("admin", "admin");
            }
            db.declareIntent((OIntent)(OrientDatabase.this.currentMode == IGraphDatabase.Mode.NO_TX_MODE ? new OIntentMassiveInsert() : new OIntentMassiveRead()));
            OrientDatabase.this.allConns.add(db);
            return db;
        }

        public PooledObject<ODatabaseDocumentTx> wrap(ODatabaseDocumentTx db) {
            return new DefaultPooledObject((Object)db);
        }
    }
}

