/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.orientdb.OrientDatabase;

public class OrientTransaction
implements IGraphTransaction {
    private OrientDatabase graph;

    public OrientTransaction(OrientDatabase orientDatabase) {
        this.graph = orientDatabase;
        ODatabaseDocumentTx db = this.graph.getGraph();
        if (!db.getTransaction().isActive()) {
            this.graph.clearPostponedIndexes();
            db.begin();
        }
    }

    public void success() {
        this.graph.saveDirty();
        this.graph.processPostponedIndexes();
        this.graph.getGraph().commit();
    }

    public void failure() {
        this.graph.discardDirty();
        this.graph.clearPostponedIndexes();
        this.graph.getGraph().rollback();
    }

    public void close() {
        this.graph.releaseConnection();
    }

    public ODatabaseDocumentTx getOrientGraph() {
        return this.graph.getGraph();
    }
}

