/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.jgit;

import java.io.File;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.git.JGitRepository;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.dialog.HVCSDialog;
import org.eclipse.hawk.ui2.vcs.IVcsConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JGitConfigurationBlock
implements IVcsConfigurationBlock {
    private HVCSDialog dialog;
    private Text txtGitRepo;
    private Text txtBranch;
    private Button btnBrowse;

    public boolean isApplicableTo(IVcsManager manager) {
        return manager instanceof JGitRepository;
    }

    public void createBlock(final Composite container, HVCSDialog dialog) {
        this.dialog = dialog;
        JGitRepository managerToEdit = (JGitRepository)dialog.getManagerToEdit();
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 3;
        container.setLayout((Layout)containerLayout);
        Label lblLocation = new Label(container, 0);
        lblLocation.setText("Repository folder:");
        this.txtGitRepo = new Text(container, 2048);
        GridData txtVCSLocationLayoutData = new GridData(4, 0x1000000, true, false);
        txtVCSLocationLayoutData.widthHint = 300;
        this.txtGitRepo.setLayoutData((Object)txtVCSLocationLayoutData);
        if (managerToEdit != null) {
            this.txtGitRepo.setText(managerToEdit.getLocation());
            this.txtGitRepo.setEnabled(false);
        }
        this.txtGitRepo.addModifyListener(e -> this.updateDialog());
        this.txtGitRepo.setToolTipText("Path to the root folder of the repository (only local repositories are supported)");
        this.btnBrowse = new Button(container, 8);
        GridData gridDataB = new GridData();
        this.btnBrowse.setLayoutData((Object)gridDataB);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(container.getShell(), 4096);
                dd.setMessage("Select a Git repository root to add to the indexer");
                dd.setText("Select a directory");
                String result = dd.open();
                if (result != null) {
                    JGitConfigurationBlock.this.txtGitRepo.setText(result);
                }
            }
        });
        this.btnBrowse.setEnabled(false);
        Label lblBranch = new Label(container, 0);
        lblBranch.setText("Branch (optional):");
        this.txtBranch = new Text(container, 2048);
        GridData txtBranchLayoutData = new GridData(4, 0x1000000, true, false);
        txtBranchLayoutData.horizontalSpan = 2;
        this.txtBranch.setLayoutData((Object)txtBranchLayoutData);
        if (managerToEdit != null) {
            if (managerToEdit.getBranch() != null) {
                this.txtBranch.setText(managerToEdit.getBranch());
            }
            this.txtBranch.setEnabled(false);
        }
        this.txtBranch.addModifyListener(e -> this.updateDialog());
        this.txtBranch.setToolTipText("Branch to be checked out (current branch if empty)");
        this.updateDialog();
    }

    public void okPressed(HModel hawkModel, boolean isFrozen) {
        IVcsManager managerToEdit;
        String vcsType = this.dialog.getSelectedVCSManager().getClass().getName();
        String location = this.txtGitRepo.getText();
        String sBranch = this.txtBranch.getText().trim();
        if (sBranch.length() > 0) {
            location = String.format("%s?%s=%s", new File(location).toURI().toString(), "branch", sBranch);
        }
        if ((managerToEdit = this.dialog.getManagerToEdit()) == null) {
            hawkModel.addVCS(location, vcsType, null, null, isFrozen);
        } else {
            managerToEdit.setFrozen(isFrozen);
        }
    }

    private void updateDialog() {
        if (this.dialog.getManagerToEdit() == null) {
            IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
            this.btnBrowse.setEnabled(vcsManager != null && vcsManager.isPathLocationAccepted());
        }
        if (!this.isLocationValid()) {
            this.dialog.setErrorMessage("The location is not valid");
        } else if (this.dialog.getSelectedVCSManager() == null) {
            this.dialog.setErrorMessage("No VCS manager type has been selected");
        } else {
            this.dialog.setErrorMessage(null);
        }
    }

    private boolean isLocationValid() {
        File f = new File(this.txtGitRepo.getText());
        return f.isDirectory() && f.exists();
    }
}

