/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelElementNode {
    public static final String OBJECT_VERTEX_LABEL = "eobject";
    public static final String EDGE_PROPERTY_CONTAINER = "isContainer";
    public static final String EDGE_PROPERTY_CONTAINMENT = "isContainment";
    public static final String EDGE_LABEL_FILE = "_hawkFile";
    public static final String EDGE_LABEL_OFKIND = "_hawkOfKind";
    public static final String EDGE_LABEL_OFTYPE = "_hawkOfType";
    public static final List<String> TRANSIENT_EDGE_LABELS = Arrays.asList("_hawkFile", "_hawkOfKind", "_hawkOfType");
    public static final Set<String> TRANSIENT_ATTRIBUTES = new HashSet<String>(Arrays.asList("_hawkid", "_hawksignature"));
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelElementNode.class);
    private final IGraphNode node;
    private TypeNode typeNode;
    private FileNode fileNode;
    public static final String DERIVED_EDGE_PREFIX = "de";

    public ModelElementNode(IGraphNode node) {
        this.node = node;
    }

    public TypeNode getTypeNode() {
        if (this.typeNode == null) {
            IGraphNode rawTypeNode = this.getFirstEndNode(EDGE_LABEL_OFTYPE);
            this.typeNode = new TypeNode(rawTypeNode);
        }
        return this.typeNode;
    }

    public List<TypeNode> getKindNodes() {
        ArrayList<TypeNode> nodes = new ArrayList<TypeNode>();
        for (IGraphEdge outEdge : this.node.getOutgoingWithType(EDGE_LABEL_OFKIND)) {
            nodes.add(new TypeNode(outEdge.getEndNode()));
        }
        return nodes;
    }

    public FileNode getFileNode() {
        if (this.fileNode == null) {
            IGraphNode rawFileNode = this.getFirstEndNode(EDGE_LABEL_FILE);
            this.fileNode = new FileNode(rawFileNode);
        }
        return this.fileNode;
    }

    public List<FileNode> getFileNodes() {
        ArrayList<FileNode> nodes = new ArrayList<FileNode>();
        for (IGraphEdge outEdge : this.node.getOutgoingWithType(EDGE_LABEL_FILE)) {
            nodes.add(new FileNode(outEdge.getEndNode()));
        }
        return nodes;
    }

    public void getSlotValues(Map<String, Object> attributeValues, Map<String, Object> referenceValues, Map<String, Object> mixedValues, Map<String, Object> derivedValues) {
        Collection<Slot> slots = this.getTypeNode().getSlots().values();
        for (Slot s : slots) {
            Object value;
            if (s.isAttribute() && attributeValues != null) {
                value = this.getSlotValue(s);
                if (value == null) continue;
                attributeValues.put(s.getName(), value);
                continue;
            }
            if (s.isReference() && referenceValues != null) {
                value = this.getSlotValue(s);
                if (value == null) continue;
                referenceValues.put(s.getName(), value);
                continue;
            }
            if (s.isMixed() && mixedValues != null) {
                value = this.getSlotValue(s);
                if (value == null) continue;
                mixedValues.put(s.getName(), value);
                continue;
            }
            if (!s.isDerived() || (value = this.getSlotValue(s)) == null) continue;
            derivedValues.put(s.getName(), value);
        }
    }

    public Object getSlotValue(Slot slot) {
        Object rawValue = null;
        if (slot.isDerived()) {
            for (IGraphEdge r : this.node.getOutgoingWithType(slot.getName())) {
                if (rawValue == null) {
                    Iterator dEdges;
                    IGraphNode dpNode = r.getEndNode();
                    rawValue = dpNode.getProperty(slot.getName());
                    if (rawValue != null || !(dEdges = dpNode.getOutgoingWithType(DERIVED_EDGE_PREFIX + slot.getName()).iterator()).hasNext()) continue;
                    ArrayList<IGraphNode> targets = new ArrayList<IGraphNode>();
                    while (dEdges.hasNext()) {
                        targets.add(((IGraphEdge)dEdges.next()).getEndNode());
                    }
                    return targets;
                }
                throw new IllegalStateException("WARNING: a derived property node (arity 1) -- ( " + slot.getName() + " ) has more than 1 links in store!");
            }
        } else {
            rawValue = this.node.getProperty(slot.getName());
        }
        return this.decodeRawValue(slot, rawValue);
    }

    protected Object decodeRawValue(Slot slot, Object rawValue) {
        Collection<Object> collection = slot.getCollection();
        if (slot.isMany() && rawValue != null && (slot.isAttribute() || slot.isMixed() || slot.isDerived())) {
            int n;
            int n2;
            Object[] objectArray;
            Class<?> componentType = rawValue.getClass().getComponentType();
            if (componentType == null) {
                return null;
            }
            if (!componentType.isPrimitive()) {
                collection.addAll(Arrays.asList((Object[])rawValue));
            } else if (componentType == Double.TYPE) {
                objectArray = (double[])rawValue;
                int n3 = objectArray.length;
                n2 = 0;
                while (n2 < n3) {
                    double v = objectArray[n2];
                    collection.add(v);
                    ++n2;
                }
            } else if (componentType == Float.TYPE) {
                float[] fArray = (float[])rawValue;
                n2 = fArray.length;
                n = 0;
                while (n < n2) {
                    float v = fArray[n];
                    collection.add(Float.valueOf(v));
                    ++n;
                }
            } else if (componentType == Long.TYPE) {
                long[] lArray = (long[])rawValue;
                objectArray = lArray;
                int n4 = lArray.length;
                n2 = 0;
                while (n2 < n4) {
                    double v = objectArray[n2];
                    collection.add((long)v);
                    ++n2;
                }
            } else if (componentType == Integer.TYPE) {
                int[] nArray = (int[])rawValue;
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    int v = nArray[n];
                    collection.add(v);
                    ++n;
                }
            } else if (componentType == Short.TYPE) {
                short[] sArray = (short[])rawValue;
                n2 = sArray.length;
                n = 0;
                while (n < n2) {
                    short v = sArray[n];
                    collection.add(v);
                    ++n;
                }
            } else if (componentType == Byte.TYPE) {
                byte[] byArray = (byte[])rawValue;
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    byte v = byArray[n];
                    collection.add(v);
                    ++n;
                }
            } else if (componentType == Character.TYPE) {
                char[] cArray = (char[])rawValue;
                n2 = cArray.length;
                n = 0;
                while (n < n2) {
                    char v = cArray[n];
                    collection.add(Character.valueOf(v));
                    ++n;
                }
            } else if (componentType == Byte.TYPE) {
                byte[] byArray = (byte[])rawValue;
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    byte v = byArray[n];
                    collection.add(v);
                    ++n;
                }
            } else if (componentType == Boolean.TYPE) {
                boolean[] blArray = (boolean[])rawValue;
                n2 = blArray.length;
                n = 0;
                while (n < n2) {
                    boolean v = blArray[n];
                    collection.add(v);
                    ++n;
                }
            }
        }
        if (slot.isReference() || slot.isMixed()) {
            for (IGraphEdge r : this.node.getOutgoingWithType(slot.getName())) {
                Object id = r.getEndNode().getId();
                collection.add(id);
            }
        }
        if (slot.isMany()) {
            return collection;
        }
        if (slot.isAttribute()) {
            return rawValue;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        if (collection.isEmpty()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("A relationship with arity 1 (%s) had %d links", slot.getName(), collection.size()));
    }

    public IGraphNode getNode() {
        return this.node;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelElementNode other = (ModelElementNode)obj;
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }

    public boolean isRoot() {
        return this.getFileNode().isRoot(this);
    }

    public ModelElementNode getContainer() {
        for (IGraphEdge edge : this.node.getOutgoing()) {
            if (edge.getProperty(EDGE_PROPERTY_CONTAINER) == null) continue;
            return new ModelElementNode(edge.getEndNode());
        }
        for (IGraphEdge edge : this.node.getIncoming()) {
            if (edge.getProperty(EDGE_PROPERTY_CONTAINMENT) == null) continue;
            return new ModelElementNode(edge.getStartNode());
        }
        return null;
    }

    public boolean isContainment(String featureName) {
        return this.outgoingEdgeWithTypeHasProperty(featureName, EDGE_PROPERTY_CONTAINMENT);
    }

    public boolean isContainer(String featureName) {
        return this.outgoingEdgeWithTypeHasProperty(featureName, EDGE_PROPERTY_CONTAINER);
    }

    protected IGraphNode getFirstEndNode(String edgeLabel) {
        IGraphNode rawTypeNode = ((IGraphEdge)this.node.getOutgoingWithType(edgeLabel).iterator().next()).getEndNode();
        return rawTypeNode;
    }

    private boolean outgoingEdgeWithTypeHasProperty(String featureName, String propertyName) {
        Iterable edges = this.getNode().getOutgoingWithType(featureName);
        for (IGraphEdge edge : edges) {
            if (!featureName.equals(edge.getType())) continue;
            return edge.getProperty(propertyName) != null;
        }
        return false;
    }

    public String getNodeId() {
        return this.getNode().getId().toString();
    }

    public String getElementId() {
        return this.getNode().getProperty("_hawkid").toString();
    }

    public boolean isContained() {
        return this.getContainer() != null;
    }

    public boolean hasChildren() {
        for (IGraphEdge edge : this.node.getOutgoing()) {
            if (edge.getProperty(EDGE_PROPERTY_CONTAINMENT) == null) continue;
            return true;
        }
        for (IGraphEdge edge : this.node.getIncoming()) {
            if (edge.getProperty(EDGE_PROPERTY_CONTAINER) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedWithin(String containerRepository, String containerPath) {
        ModelElementNode men = this;
        while (men != null) {
            FileNode fn = men.getFileNode();
            String repositoryURL = fn.getRepositoryURL();
            String filePath = fn.getFilePath();
            if ((containerRepository == null || repositoryURL.equals(containerRepository)) && (containerPath == null || filePath.equals(containerPath))) {
                return true;
            }
            men = men.getContainer();
        }
        return false;
    }

    public boolean isOfKind(String metaClass) {
        return this.isOf(metaClass, EDGE_LABEL_OFKIND) || this.isOf(metaClass, EDGE_LABEL_OFTYPE);
    }

    public boolean isOfType(String metaClass) {
        return this.isOf(metaClass, EDGE_LABEL_OFTYPE);
    }

    public boolean isOfKind(IGraphNode typeNode) {
        return this.isOf(typeNode, EDGE_LABEL_OFKIND) || this.isOf(typeNode, EDGE_LABEL_OFTYPE);
    }

    public boolean isOfType(IGraphNode typeNode) {
        return this.isOf(typeNode, EDGE_LABEL_OFTYPE);
    }

    public boolean isOfKind(TypeNode targetTypeNode) {
        return this.isOfKind(targetTypeNode.getNode());
    }

    public boolean isOfType(TypeNode typeNode) {
        return this.isOfType(typeNode.getNode());
    }

    protected boolean isOf(IGraphNode typeNode, String edgeLabelOftype) {
        for (IGraphEdge edge : this.node.getOutgoingWithType(edgeLabelOftype)) {
            if (!edge.getEndNode().getId().equals(typeNode.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean isOf(String metaClass, String edgeLabel) {
        for (IGraphEdge edge : this.node.getOutgoingWithType(edgeLabel)) {
            TypeNode tn = new TypeNode(edge.getEndNode());
            if (!metaClass.equals(tn.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public ModelElementNode getLocalRoot() {
        FileNode fileNode = this.getFileNode();
        ModelElementNode localRoot = this;
        ModelElementNode container = localRoot.getContainer();
        while (container != null && container.getFileNode().equals(fileNode)) {
            localRoot = container;
            container = localRoot.getContainer();
        }
        return localRoot;
    }

    public List<ProxyReferenceList> getProxies() {
        ArrayList<ProxyReferenceList> proxies = new ArrayList<ProxyReferenceList>();
        for (String propertyKey : this.node.getPropertyKeys()) {
            if (!propertyKey.startsWith("hawkProxyRef:")) continue;
            String[] propertyValue = (String[])this.node.getProperty(propertyKey);
            if (propertyValue.length > 0) {
                proxies.add(new ProxyReferenceList(this.node, propertyValue));
                continue;
            }
            LOGGER.warn("Proxy ref list is empty: node {}, key {}", (Object)this.node, (Object)propertyKey);
        }
        return proxies;
    }
}

