/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.OrientEdge;
import org.eclipse.hawk.orientdb.OrientIterable;
import org.eclipse.hawk.orientdb.OrientLightEdge;
import org.eclipse.hawk.orientdb.OrientNode;

public class OrientEdgeIterable
extends OrientIterable<IGraphEdge, OIdentifiable> {
    private final OrientNode start;
    private final String edgeLabel;

    public OrientEdgeIterable(OrientNode start, String edgeLabel, Iterable<OIdentifiable> ret, OrientDatabase graph) {
        super(ret, graph);
        this.start = start;
        this.edgeLabel = edgeLabel;
    }

    @Override
    protected IGraphEdge convert(OIdentifiable o) {
        OrientNode n = this.graph.getNodeById(o);
        ODocument doc = n.getDocument();
        if (doc.getSchemaClass().getName().startsWith("V_")) {
            return new OrientLightEdge(this.start, n, this.edgeLabel);
        }
        return new OrientEdge(doc, this.getGraph());
    }
}

