/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.eclipse.hawk.timeaware.graph.VCSManagerIndex;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VCSManagerIndexTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public TestName testName = new TestName();
    private final IGraphDatabaseFactory dbFactory;
    private IGraphDatabase db;
    private VCSManagerIndex idx;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public VCSManagerIndexTest(File baseDir, IGraphDatabaseFactory factory) {
        this.dbFactory = factory;
    }

    @Before
    public void setUp() throws Exception {
        this.db = this.dbFactory.create();
        File indexerFolder = this.tempFolder.getRoot();
        File dbFolder = new File(indexerFolder, "test_" + this.testName.getMethodName());
        dbFolder.mkdir();
        this.db.run(dbFolder, (IConsole)new DefaultConsole());
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            this.idx = new VCSManagerIndex((ITimeAwareGraphDatabase)this.db);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void create() throws Exception {
        VCSManagerIndex.RepositoryNode node;
        IGraphTransaction tx;
        String repoURI = "platform:/resource";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("platform:/resource");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((Object)"platform:/resource", (Object)node.getURI());
                Assert.assertNull((Object)node.getRevision());
                Assert.assertEquals((Object)node.getId(), (Object)this.idx.getOrCreateRepositoryNode("platform:/resource").getId());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void changeLastRevision() throws Exception {
        VCSManagerIndex.RepositoryNode node;
        IGraphTransaction tx;
        String repoURI = "file:/tmp/example";
        String lastRev = "1";
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("file:/tmp/example");
                node.setRevision("1");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("file:/tmp/example");
                Assert.assertEquals((Object)"1", (Object)node.getRevision());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void recreate() throws Exception {
        Object firstId;
        VCSManagerIndex.RepositoryNode node;
        IGraphTransaction tx;
        String repoURI = "svn:/host/path";
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("svn:/host/path");
                firstId = node.getId();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("svn:/host/path");
                Assert.assertEquals((Object)firstId, (Object)node.getId());
                this.idx.removeRepositoryNode("svn:/host/path");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                node = this.idx.getOrCreateRepositoryNode("svn:/host/path");
                Assert.assertNotEquals((Object)firstId, (Object)node.getId());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

