/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.engine.python.generator;

import activity.Move;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import machine.IResource;
import machine.PeripheralType;
import machine.SetPoint;
import machine.SymbolicPosition;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.graph.directed.util.DirectedGraphQueries;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependencyType;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.timing.util.AxesLocation;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import setting.Settings;

public class GeneratorServices {
    private static final DecimalFormat FORMAT = new DecimalFormat("0000");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy");

    public static final String format(Integer number) {
        return FORMAT.format(number);
    }

    public static final String currentDate() {
        return DATE_FORMAT.format(new Date());
    }

    public static Map<SetPoint, BigDecimal> getSourceSetPoints(Move move, Settings settings) {
        return GeneratorServices.getSetPoints(move.getResource(), move.getSourcePosition(), settings);
    }

    public static Map<SetPoint, BigDecimal> getTargetSetPoints(Move move, Settings settings) {
        return GeneratorServices.getSetPoints(move.getResource(), move.getTargetPosition(), settings);
    }

    private static Map<SetPoint, BigDecimal> getSetPoints(IResource resource, SymbolicPosition position, Settings settings) {
        try {
            MotionCalculatorHelper helper = new MotionCalculatorHelper(settings, null);
            AxesLocation axesLocation = helper.getAxesLocation(resource, position);
            return MotionCalculatorHelper.toSetPoint((PeripheralType)position.getPeripheral().getType(), (Map)axesLocation);
        }
        catch (SpecificationException e) {
            return Collections.emptyMap();
        }
    }

    public static BigDecimal getValue(Map<SetPoint, BigDecimal> map, SetPoint setPoint) {
        return map.get(setPoint);
    }

    public static BigDecimal getDelay(ScheduledTask<?> task) {
        return (BigDecimal)IterableUtil.min((Iterable)QueryableIterable.from((Iterable)task.getIncomingEdges()).collectOne(GeneratorServices::getDelay), (Comparable)BigDecimal.ZERO);
    }

    private static BigDecimal getDelay(Edge edge) {
        ScheduledDependency dep;
        if (edge instanceof ScheduledDependency && ScheduledDependencyType.SOURCE_NODE_ENDS_BEFORE_TARGET_NODE_STARTS.equals((Object)(dep = (ScheduledDependency)edge).getType())) {
            return ((ScheduledTask)edge.getTargetNode()).getStartTime().subtract(((ScheduledTask)edge.getSourceNode()).getEndTime());
        }
        return BigDecimal.ZERO;
    }

    public static <N extends Node> List<N> allNodesInReverseTopologicalOrder(DirectedGraph<N, ?> graph) {
        return DirectedGraphQueries.reverseTopologicalOrdering((Iterable)DirectedGraphQueries.allSubNodes(graph), Comparator.comparing(Node::getName));
    }
}

