/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CallableKind implements Enumerator
{
    EXTERNAL(0, "external", "external"),
    REGULAR(1, "regular", "regular"),
    OPERATOR(2, "operator", "operator"),
    STORED(3, "stored", "stored"),
    UNKNOWN(4, "unknown", "unknown");

    public static final int EXTERNAL_VALUE = 0;
    public static final int REGULAR_VALUE = 1;
    public static final int OPERATOR_VALUE = 2;
    public static final int STORED_VALUE = 3;
    public static final int UNKNOWN_VALUE = 4;
    private static final CallableKind[] VALUES_ARRAY;
    public static final List<CallableKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CallableKind[]{EXTERNAL, REGULAR, OPERATOR, STORED, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CallableKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallableKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallableKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallableKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallableKind get(int value) {
        switch (value) {
            case 0: {
                return EXTERNAL;
            }
            case 1: {
                return REGULAR;
            }
            case 2: {
                return OPERATOR;
            }
            case 3: {
                return STORED;
            }
            case 4: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private CallableKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

