/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.Messages;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.exception.JavaReverseException;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.spi.IContextualServiceRegistryTracker;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractExecuteInJobHandler
extends AbstractHandler {
    protected static final String EDITOR_ID = "org.eclipse.papyrus.infra.core";
    protected ExecutionEvent event;
    protected ServicesRegistry registry;
    protected TransactionalEditingDomain domain;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        try {
            this.registry = this.lookupServiceRegistry(event);
            this.domain = this.getEditingDomain();
        }
        catch (ServiceException e) {
            Shell shell = this.getShell();
            Status errorStatus = new Status(4, EDITOR_ID, Messages.ReverseCodeHandler_NoPapyrusEditor_Title);
            ErrorDialog.openError((Shell)shell, (String)"", (String)Messages.ReverseCodeHandler_NoPapyrusEditor_Message, (IStatus)errorStatus);
            return null;
        }
        boolean isStatusOk = this.doPrepareExecute(event);
        if (!isStatusOk) {
            return null;
        }
        JobForHandler job = new JobForHandler(this.getJobName(), this.domain);
        job.setUser(true);
        job.schedule();
        return null;
    }

    abstract String getJobName();

    protected abstract boolean doPrepareExecute(ExecutionEvent var1);

    protected abstract void doExecuteTransactionInJob(IProgressMonitor var1);

    protected Shell getShell() {
        if (this.event != null) {
            return HandlerUtil.getActiveShell((ExecutionEvent)this.event);
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell();
    }

    protected ServicesRegistry lookupServiceRegistry(ExecutionEvent event) throws ServiceException {
        ServicesRegistry registry;
        try {
            registry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
        }
        catch (ServiceException e1) {
            registry = this.getContextualServiceRegistry();
        }
        return registry;
    }

    protected String getSelectedProjectName() throws JavaReverseException {
        ISelection selection = this.getCurrentSelection();
        TreeSelection treeSelection = (TreeSelection)selection;
        IJavaProject javaProject = this.getNodeEnclosingIJavaProject(treeSelection.getFirstElement());
        String name = javaProject.getAncestor(2).getElementName();
        return name;
    }

    protected IJavaProject getNodeEnclosingIJavaProject(Object node) throws JavaReverseException {
        if (node instanceof IJavaElement) {
            return (IJavaProject)((IJavaElement)node).getAncestor(2);
        }
        if (node instanceof IProject) {
            IProject project = (IProject)node;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                    return javaProject;
                }
            }
            catch (CoreException e) {
                throw new JavaReverseException(String.format("Can't find enclosing Project for node '%s'", node), e);
            }
        }
        throw new JavaReverseException(String.format("Can't find enclosing Project for node '%s'", node));
    }

    protected ISelection getCurrentSelection() {
        Object context;
        ISelection selection = null;
        if (this.event != null && (context = this.event.getApplicationContext()) instanceof IEvaluationContext) {
            IEvaluationContext evaluationContext = (IEvaluationContext)context;
            selection = (ISelection)evaluationContext.getVariable("selection");
        }
        if (selection == null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            selection = page.getSelection();
        }
        return selection;
    }

    protected UmlModel getUmlModel() throws ServiceException {
        this.checkServiceRegistry();
        UmlModel umlModel = (UmlModel)ServiceUtils.getInstance().getModelSet((Object)this.registry).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        return umlModel;
    }

    protected IEditorPart getNestedActiveIEditorPart() throws ServiceException {
        this.checkServiceRegistry();
        return ((ISashWindowsContainer)ServiceUtils.getInstance().getService(ISashWindowsContainer.class, (Object)this.registry)).getActiveEditor();
    }

    protected TransactionalEditingDomain getEditingDomain() throws ServiceException {
        this.checkServiceRegistry();
        return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.registry);
    }

    protected ServicesRegistry getContextualServiceRegistry() throws ServiceException {
        IContextualServiceRegistryTracker tracker = Activator.getDefault().getContextualServiceRegistryTracker();
        if (tracker != null) {
            return tracker.getServiceRegistry();
        }
        throw new ServiceException("Can't get ServiceRegistry from Tracker");
    }

    protected void checkServiceRegistry() throws ServiceException {
        if (this.registry == null) {
            throw new ServiceException("ServiceRegistry must be set prior using this method.");
        }
    }

    protected class JobForHandler
    extends Job {
        private TransactionalEditingDomain domain;

        public JobForHandler(String name, TransactionalEditingDomain domain) {
            super(name);
            this.domain = domain;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RecordingCommandForHandler command = new RecordingCommandForHandler(this.domain, monitor);
                this.domain.getCommandStack().execute((Command)command);
            }
            catch (Exception e) {
                return new Status(4, AbstractExecuteInJobHandler.EDITOR_ID, e.getMessage(), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    protected class RecordingCommandForHandler
    extends RecordingCommand {
        protected IProgressMonitor monitor;

        public RecordingCommandForHandler(TransactionalEditingDomain domain, IProgressMonitor monitor) {
            super(domain);
            this.monitor = null;
            this.monitor = monitor;
        }

        protected void doExecute() {
            AbstractExecuteInJobHandler.this.doExecuteTransactionInJob(this.monitor);
        }
    }
}

