/**
 * Copyright (c) 2017, 2021 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Ansgar Radermacher - Initial API and implementation
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - Bug 530251
 *     Ported from C++ code - Bug 568883
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.common.base.StringConstants;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.java.library.JavaLibUriConstants;
import org.eclipse.papyrus.designer.languages.java.profile.JavaProfileResource;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.ChangeEventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.ConcurrencyGenerator;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.EventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.LifeCycleUtil;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.MonitoringTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.PseudostateGenerator;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SMJavaCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.library.xtend.BehaviorUtil;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.transformation.vsl.ParseVSL;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * Java variant of main SM transformation
 */
@SuppressWarnings("all")
public class SM2ClassesTransformationCore {
  @Extension
  protected CDefinitions cdefs;
  
  public int MAX_NUMBER_ORTHOGONAL_REGIONS = 1;
  
  private StateMachine sm;
  
  public Type boolType;
  
  public Type threadFuncEnum;
  
  private Type state_t;
  
  public org.eclipse.uml2.uml.Class superContext;
  
  private List<Transition> transitions = new ArrayList<Transition>();
  
  private List<OpaqueBehavior> actions = new ArrayList<OpaqueBehavior>();
  
  public Region topRegion;
  
  public List<State> states = new ArrayList<State>();
  
  private List<Vertex> vertexes = new ArrayList<Vertex>();
  
  public LazyCopier copier;
  
  private String langID = "JAVA";
  
  public Semaphore sema = new Semaphore(1);
  
  public boolean generateActionLog = false;
  
  private boolean createDoActivity = true;
  
  public Type voidType;
  
  private Enumeration stateIdEnum;
  
  public Type intType;
  
  public Type charType;
  
  public Type stringType;
  
  private Enumeration eventIdEnum;
  
  public Type sockAddrInType;
  
  public static org.eclipse.uml2.uml.Package umlPrimitiveLibrary;
  
  public static org.eclipse.uml2.uml.Package javaLibrary;
  
  public List<TimeEvent> timeEvents = new ArrayList<TimeEvent>();
  
  public List<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
  
  public List<CallEvent> callEvents = new ArrayList<CallEvent>();
  
  private List<SignalEvent> signalEvents = new ArrayList<SignalEvent>();
  
  private List<AnyReceiveEvent> anyEvents = new ArrayList<AnyReceiveEvent>();
  
  private List<Pseudostate> junctions = new ArrayList<Pseudostate>();
  
  public ConcurrencyGenerator concurrency;
  
  public EventTransformation eventTransform;
  
  public PseudostateGenerator pseudostateGenerator;
  
  public MonitoringTransformation monitoringTransformation;
  
  public List<Behavior> doActivityList = new ArrayList<Behavior>();
  
  public org.eclipse.uml2.uml.Package smPack;
  
  private List<Region> regions = new ArrayList<Region>();
  
  public List<Transition> parallelTransitions = new ArrayList<Transition>();
  
  public Map<State, List<TimeEvent>> states2TimeEvents = new HashMap<State, List<TimeEvent>>();
  
  private Type threadStructType;
  
  private Type event_t;
  
  public SM2ClassesTransformationCore(final LazyCopier copier, final StateMachine sm, final org.eclipse.uml2.uml.Class tmClass) {
    this.copier = copier;
    this.superContext = tmClass;
    this.sm = sm;
    final ResourceSet resourceSet = this.getTargetPacket().eResource().getResourceSet();
    CDefinitions _cDefinitions = new CDefinitions(this.superContext);
    this.cdefs = _cDefinitions;
    SM2ClassesTransformationCore.umlPrimitiveLibrary = ElementUtils.loadPackage(StdUriConstants.UML_PRIM_TYPES_URI, resourceSet);
    SM2ClassesTransformationCore.javaLibrary = ElementUtils.loadPackage(JavaLibUriConstants.LIBRARY_PATH_URI, resourceSet);
    this.boolType = SM2ClassesTransformationCore.umlPrimitiveLibrary.getOwnedType("Boolean");
    this.voidType = SM2ClassesTransformationCore.umlPrimitiveLibrary.getOwnedType("Object");
    this.intType = SM2ClassesTransformationCore.umlPrimitiveLibrary.getOwnedType("Integer");
    this.stringType = SM2ClassesTransformationCore.umlPrimitiveLibrary.getOwnedType("String");
    this.charType = SM2ClassesTransformationCore.javaLibrary.getOwnedType("char");
  }
  
  public org.eclipse.uml2.uml.Package setSmPack(final org.eclipse.uml2.uml.Package smPack) {
    return this.smPack = smPack;
  }
  
  public Type getThreadStructType() {
    return this.threadStructType;
  }
  
  public Type setThreadStructType(final Type threadStructType) {
    return this.threadStructType = threadStructType;
  }
  
  public Type setState_t(final Type state_t) {
    return this.state_t = state_t;
  }
  
  public Type setEvent_t(final Type event_t) {
    return this.event_t = event_t;
  }
  
  public org.eclipse.uml2.uml.Package getRoot() {
    return TransformationContext.current.copier.source;
  }
  
  public org.eclipse.uml2.uml.Package getTargetPacket() {
    return this.copier.target;
  }
  
  public org.eclipse.uml2.uml.Package getExternalPackage(final org.eclipse.uml2.uml.Package parentPack) {
    org.eclipse.uml2.uml.Package _nestedPackage = parentPack.getNestedPackage("external");
    boolean _tripleEquals = (_nestedPackage == null);
    if (_tripleEquals) {
      org.eclipse.uml2.uml.Package createdPack = parentPack.createNestedPackage("external");
      StereotypeUtil.apply(createdPack, NoCodeGen.class);
    }
    return parentPack.getNestedPackage("external");
  }
  
  public void createIntConstant(final String name, final int defaultValue) {
    final Property constant = this.superContext.createOwnedAttribute(name, this.intType);
    constant.setIsStatic(true);
    constant.setIsLeaf(true);
    ValueSpecification _createDefaultValue = constant.createDefaultValue(null, null, 
      UMLPackage.eINSTANCE.getLiteralInteger());
    final LiteralInteger defaultValueUML = ((LiteralInteger) _createDefaultValue);
    defaultValueUML.setValue(defaultValue);
  }
  
  public void transform() {
    final org.eclipse.uml2.uml.Package targetPack = this.getTargetPacket();
    final ResourceSet resourceSet = targetPack.eResource().getResourceSet();
    final org.eclipse.uml2.uml.Package profile = ElementUtils.loadPackage(StdUriConstants.UML_STD_PROFILE_URI, resourceSet);
    if ((profile instanceof Profile)) {
      PackageUtil.applyProfile(targetPack, ((Profile) profile), true);
    }
    final org.eclipse.uml2.uml.Package javaProfile = PackageUtil.loadPackage(JavaProfileResource.PROFILE_PATH_URI, resourceSet);
    if ((javaProfile instanceof Profile)) {
      PackageUtil.applyProfile(targetPack, ((Profile) javaProfile), true);
    }
    this.topRegion = IterableExtensions.<Region>head(this.sm.getRegions());
    ConcurrencyGenerator _concurrencyGenerator = new ConcurrencyGenerator(this);
    this.concurrency = _concurrencyGenerator;
    EventTransformation _eventTransformation = new EventTransformation(this);
    this.eventTransform = _eventTransformation;
    PseudostateGenerator _pseudostateGenerator = new PseudostateGenerator(this);
    this.pseudostateGenerator = _pseudostateGenerator;
    MonitoringTransformation _monitoringTransformation = new MonitoringTransformation(this);
    this.monitoringTransformation = _monitoringTransformation;
    Map<Event, List<Transition>> eventMap = this.getAllEvents(this.topRegion);
    final BiConsumer<Event, List<Transition>> _function = new BiConsumer<Event, List<Transition>>() {
      @Override
      public void accept(final Event e, final List<Transition> k) {
        if ((e instanceof TimeEvent)) {
          SM2ClassesTransformationCore.this.timeEvents.add(((TimeEvent)e));
        } else {
          if ((e instanceof CallEvent)) {
            SM2ClassesTransformationCore.this.callEvents.add(((CallEvent)e));
          } else {
            if ((e instanceof SignalEvent)) {
              SM2ClassesTransformationCore.this.signalEvents.add(((SignalEvent)e));
            } else {
              if ((e instanceof ChangeEvent)) {
                SM2ClassesTransformationCore.this.changeEvents.add(((ChangeEvent)e));
              } else {
                if ((e instanceof AnyReceiveEvent)) {
                  SM2ClassesTransformationCore.this.anyEvents.add(((AnyReceiveEvent)e));
                }
              }
            }
          }
        }
      }
    };
    eventMap.forEach(_function);
    Classifier _createNestedClassifier = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.EVENT_ID, UMLPackage.Literals.ENUMERATION);
    this.eventIdEnum = ((Enumeration) _createNestedClassifier);
    this.createIntConstant(this.cdefs.TIME_EVENT_LOWER_BOUND(), 0);
    final Consumer<TimeEvent> _function_1 = new Consumer<TimeEvent>() {
      @Override
      public void accept(final TimeEvent it) {
        SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID(it));
      }
    };
    this.timeEvents.forEach(_function_1);
    final Consumer<ChangeEvent> _function_2 = new Consumer<ChangeEvent>() {
      @Override
      public void accept(final ChangeEvent it) {
        SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID(it));
      }
    };
    this.changeEvents.forEach(_function_2);
    this.createIntConstant(this.cdefs.CHANGE_EVENT_LOWER_BOUND(), this.timeEvents.size());
    Operation teIndex = this.superContext.createOwnedOperation(this.cdefs.TE_INDEX(), null, null);
    teIndex.setIsStatic(true);
    teIndex.setIsLeaf(true);
    teIndex.createOwnedParameter("id", this.intType);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return id - ");
    String _TIME_EVENT_LOWER_BOUND = this.cdefs.TIME_EVENT_LOWER_BOUND();
    _builder.append(_TIME_EVENT_LOWER_BOUND);
    _builder.append(";");
    this.createOpaqueBehavior(this.superContext, teIndex, _builder.toString());
    final Parameter retType = teIndex.createOwnedParameter("ret", this.intType);
    retType.setDirection(ParameterDirectionKind.RETURN_LITERAL);
    this.superContext.createOwnedAttribute("currentEvent", this.event_t);
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("import statemachineJava.EventPriority_t;");
    _builder_1.newLine();
    _builder_1.append("import statemachineJava.EventType_t;");
    _builder_1.newLine();
    this.appendImport(_builder_1.toString());
    final Consumer<SignalEvent> _function_3 = new Consumer<SignalEvent>() {
      @Override
      public void accept(final SignalEvent it) {
        SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID(it));
      }
    };
    this.signalEvents.forEach(_function_3);
    final Consumer<CallEvent> _function_4 = new Consumer<CallEvent>() {
      @Override
      public void accept(final CallEvent it) {
        SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID(it));
      }
    };
    this.callEvents.forEach(_function_4);
    final Consumer<AnyReceiveEvent> _function_5 = new Consumer<AnyReceiveEvent>() {
      @Override
      public void accept(final AnyReceiveEvent it) {
        SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID(it));
      }
    };
    this.anyEvents.forEach(_function_5);
    String _upperCase = SMCodeGeneratorConstants.COMPLETION_EVENT.toUpperCase();
    String _plus = (_upperCase + "_ID");
    this.eventIdEnum.createOwnedLiteral(_plus);
    this.getAllActionsTransitionsStates(this.topRegion);
    final Function1<State, Boolean> _function_6 = new Function1<State, Boolean>() {
      @Override
      public Boolean apply(final State it) {
        return Boolean.valueOf(it.isOrthogonal());
      }
    };
    final Consumer<State> _function_7 = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        int _size = it.getRegions().size();
        boolean _greaterThan = (_size > SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS);
        if (_greaterThan) {
          SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS = it.getRegions().size();
        }
      }
    };
    IterableExtensions.<State>filter(this.states, _function_6).forEach(_function_7);
    final Consumer<State> _function_8 = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        final ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        final Consumer<Transition> _function = new Consumer<Transition>() {
          @Override
          public void accept(final Transition it) {
            triggers.addAll(it.getTriggers());
          }
        };
        it.getOutgoings().forEach(_function);
        final Function1<Trigger, Event> _function_1 = new Function1<Trigger, Event>() {
          @Override
          public Event apply(final Trigger it) {
            return it.getEvent();
          }
        };
        final List<Event> events = ListExtensions.<Trigger, Event>map(triggers, _function_1);
        final List<TimeEvent> timeEvents = IterableExtensions.<TimeEvent>toList(Iterables.<TimeEvent>filter(events, TimeEvent.class));
        SM2ClassesTransformationCore.this.states2TimeEvents.put(it, timeEvents);
      }
    };
    this.states.forEach(_function_8);
    final Consumer<Pseudostate> _function_9 = new Consumer<Pseudostate>() {
      @Override
      public void accept(final Pseudostate it) {
        PseudostateKind _kind = it.getKind();
        boolean _equals = Objects.equal(_kind, PseudostateKind.JUNCTION_LITERAL);
        if (_equals) {
          SM2ClassesTransformationCore.this.junctions.add(it);
        }
      }
    };
    Iterables.<Pseudostate>filter(this.vertexes, Pseudostate.class).forEach(_function_9);
    final Consumer<Pseudostate> _function_10 = new Consumer<Pseudostate>() {
      @Override
      public void accept(final Pseudostate it) {
        SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(it.getName(), SM2ClassesTransformationCore.this.intType);
      }
    };
    this.junctions.forEach(_function_10);
    Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("StateIDEnum", UMLPackage.Literals.ENUMERATION);
    this.stateIdEnum = ((Enumeration) _createNestedClassifier_1);
    this.monitoringTransformation.createMonitorAttributes();
    this.createStateStruct();
    this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, this.stateIdEnum);
    this.superContext.createOwnedAttribute("dispatchStruct", this.threadStructType);
    final Property smAttr = ((org.eclipse.uml2.uml.Class) this.threadStructType).getOwnedAttribute("sm", null);
    final Type smType = smAttr.getType();
    smType.setName(this.superContext.getName());
    final External extSM = UMLUtil.<External>getStereotypeApplication(smType, External.class);
    extSM.setName(this.superContext.getQualifiedName().replace(NamedElement.SEPARATOR, StringConstants.DOT));
    final Operation teGetter = this.superContext.createOwnedOperation("getTEIndex", null, null);
    teGetter.createOwnedParameter("id", this.intType);
    teGetter.createOwnedParameter("ret", this.intType).setDirection(ParameterDirectionKind.RETURN_LITERAL);
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("return ");
    String _upperCase_1 = this.superContext.getName().toUpperCase();
    _builder_2.append(_upperCase_1);
    _builder_2.append("_TE_INDEX(id);");
    BehaviorUtil.set(teGetter, this.langID, _builder_2.toString());
    final Operation smMax = this.superContext.createOwnedOperation("getStateMax", null, null);
    smMax.createOwnedParameter("ret", this.intType).setDirection(ParameterDirectionKind.RETURN_LITERAL);
    BehaviorUtil.set(smMax, this.langID, "return StateIDEnum.STATE_MAX.ordinal();");
    Property state = this.superContext.createOwnedAttribute("states", this.state_t);
    state.setUpper(this.states.size());
    this.createOpaqueExpressionDefaultValue(state, "state", "new State_t[StateIDEnum.STATE_MAX.ordinal()];");
    Property threadStructs = this.superContext.createOwnedAttribute("threadStructs", this.threadStructType);
    threadStructs.setUpper(this.states.size());
    this.createOpaqueExpressionDefaultValue(threadStructs, "threadStructs", 
      "new StructForThread_t[StateIDEnum.STATE_MAX.ordinal()];");
    Property flags = this.superContext.createOwnedAttribute("flags", this.boolType);
    flags.setUpper(this.states.size());
    this.createOpaqueExpressionDefaultValue(flags, "flags", "new boolean[StateIDEnum.STATE_MAX.ordinal()];");
    Property timeEventFlags = this.superContext.createOwnedAttribute("timeEventFlags", this.boolType);
    timeEventFlags.setUpper(this.states.size());
    this.createOpaqueExpressionDefaultValue(timeEventFlags, "timeEventFlags", 
      "new boolean[StateIDEnum.STATE_MAX.ordinal()];");
    Property timeEventThreadStructs = this.superContext.createOwnedAttribute("timeEventThreadStructs", this.threadStructType);
    timeEventThreadStructs.setUpper(this.states.size());
    this.createOpaqueExpressionDefaultValue(timeEventThreadStructs, "timeEventThreadStructs", 
      "new StructForThread_t[2];");
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.superContext, SMJavaCodeGeneratorConstants.SEMAPHORE_QNAME);
    Type semaphore = ((Type) _qualifiedElementFromRS);
    Property sem = this.superContext.createOwnedAttribute("sem", semaphore);
    this.createOpaqueExpressionDefaultValue(sem, "sem", "new Semaphore(1);");
    NamedElement _qualifiedElementFromRS_1 = ElementUtils.getQualifiedElementFromRS(this.superContext, 
      "statemachineJava::extern::PriorityBlockingQueue<Event_t>");
    Type queue = ((Type) _qualifiedElementFromRS_1);
    Property eventQueue = this.superContext.createOwnedAttribute("eventQueue", queue);
    this.createOpaqueExpressionDefaultValue(eventQueue, "eventQueue", "new PriorityBlockingQueue<Event_t>();");
    this.createRegionMethods();
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("startBehavior();");
    final String startCode = _builder_3.toString();
    boolean _supportsLifeCycle = LifeCycleUtil.supportsLifeCycle(this.superContext);
    if (_supportsLifeCycle) {
      LifeCycleUtil.addUnimplemented(this.superContext);
      Operation activateOp = this.superContext.getOperation(LifeCycleUtil.M_ACTIVATE, null, null);
      BehaviorUtil.appendBody(activateOp, startCode);
    } else {
      final Function1<Operation, Boolean> _function_11 = new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf((StereotypeUtil.isApplied(it, Create.class) && Objects.equal(it.getName(), SM2ClassesTransformationCore.this.superContext.getName())));
        }
      };
      final Iterable<Operation> constructors = IterableExtensions.<Operation>filter(this.superContext.getOwnedOperations(), _function_11);
      boolean _isEmpty = IterableExtensions.isEmpty(constructors);
      if (_isEmpty) {
        Operation ctor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
        StereotypeUtil.apply(ctor, Create.class);
        StringConcatenation _builder_4 = new StringConcatenation();
        {
          for(final State s : this.states) {
            {
              boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(s.getEntry());
              if (_isBehaviorExist) {
                String _name = s.getName();
                String _plus_1 = (_name + "_");
                String _plus_2 = (_plus_1 + SMCodeGeneratorConstants.ENTRY_NAME);
                _builder_4.append(_plus_2);
                _builder_4.append("= new ");
                String _name_1 = s.getName();
                String _plus_3 = (_name_1 + "_");
                String _plus_4 = (_plus_3 + SMCodeGeneratorConstants.ENTRY_NAME);
                _builder_4.append(_plus_4);
                _builder_4.append("();");
                _builder_4.newLineIfNotEmpty();
              }
            }
            {
              boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(s.getExit());
              if (_isBehaviorExist_1) {
                String _name_2 = s.getName();
                String _plus_5 = (_name_2 + "_");
                String _plus_6 = (_plus_5 + SMCodeGeneratorConstants.EXIT_NAME);
                _builder_4.append(_plus_6);
                _builder_4.append("= new ");
                String _name_3 = s.getName();
                String _plus_7 = (_name_3 + "_");
                String _plus_8 = (_plus_7 + SMCodeGeneratorConstants.EXIT_NAME);
                _builder_4.append(_plus_8);
                _builder_4.append("();");
                _builder_4.newLineIfNotEmpty();
              }
            }
            {
              boolean _isBehaviorExist_2 = TransformationUtil.isBehaviorExist(s.getDoActivity());
              if (_isBehaviorExist_2) {
                String _name_4 = s.getName();
                String _plus_9 = (_name_4 + "_");
                String _plus_10 = (_plus_9 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
                _builder_4.append(_plus_10);
                _builder_4.append("= new ");
                String _name_5 = s.getName();
                String _plus_11 = (_name_5 + "_");
                String _plus_12 = (_plus_11 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
                _builder_4.append(_plus_12);
                _builder_4.append("();");
                _builder_4.newLineIfNotEmpty();
              }
            }
            _builder_4.newLine();
          }
        }
        _builder_4.append("entry_dft = new Entry_dft();");
        _builder_4.newLine();
        _builder_4.append("doActivity_dft = new DoActivity_dft();");
        _builder_4.newLine();
        _builder_4.append("exit_dft = new Exit_dft();");
        _builder_4.newLine();
        _builder_4.append("startBehavior();");
        _builder_4.newLine();
        this.createOpaqueBehavior(this.superContext, ctor, _builder_4.toString());
      } else {
        final Consumer<Operation> _function_12 = new Consumer<Operation>() {
          @Override
          public void accept(final Operation it) {
            BehaviorUtil.appendBody(it, startCode);
          }
        };
        constructors.forEach(_function_12);
      }
    }
    this.monitoringTransformation.createConstructor();
    this.monitoringTransformation.createDestructor();
    Operation startBehavior = this.superContext.createOwnedOperation("startBehavior", null, null);
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
    _builder_5.append(" = statemachineJava.SystemStateEnum_t.IDLE;");
    _builder_5.newLineIfNotEmpty();
    _builder_5.newLine();
    _builder_5.append("// initialize all threads, the threads wait until the associated flag is set");
    _builder_5.newLine();
    _builder_5.append("\t\t");
    _builder_5.append("for (int i = 0; i < (int) StateIDEnum.STATE_MAX.ordinal(); i++) {");
    _builder_5.newLine();
    _builder_5.append("\t\t\t");
    _builder_5.append("states[i] = new State_t(this);");
    _builder_5.newLine();
    _builder_5.append("\t\t");
    _builder_5.append("}");
    _builder_5.newLine();
    {
      for(final State s_1 : this.states) {
        {
          boolean _isBehaviorExist_3 = TransformationUtil.isBehaviorExist(s_1.getEntry());
          if (_isBehaviorExist_3) {
            _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_5.append("[StateIDEnum.");
            String _upperCase_2 = s_1.getName().toUpperCase();
            _builder_5.append(_upperCase_2);
            _builder_5.append("_ID.ordinal()].");
            _builder_5.append(SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_5.append(" = ");
            String _name_6 = s_1.getName();
            String _plus_13 = (_name_6 + "_");
            String _plus_14 = (_plus_13 + SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_5.append(_plus_14);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
        {
          boolean _isBehaviorExist_4 = TransformationUtil.isBehaviorExist(s_1.getExit());
          if (_isBehaviorExist_4) {
            _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_5.append("[StateIDEnum.");
            String _upperCase_3 = s_1.getName().toUpperCase();
            _builder_5.append(_upperCase_3);
            _builder_5.append("_ID.ordinal()].");
            _builder_5.append(SMCodeGeneratorConstants.EXIT_NAME);
            _builder_5.append(" = ");
            String _name_7 = s_1.getName();
            String _plus_15 = (_name_7 + "_");
            String _plus_16 = (_plus_15 + SMCodeGeneratorConstants.EXIT_NAME);
            _builder_5.append(_plus_16);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
        {
          boolean _isBehaviorExist_5 = TransformationUtil.isBehaviorExist(s_1.getDoActivity());
          if (_isBehaviorExist_5) {
            _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_5.append("[StateIDEnum.");
            String _upperCase_4 = s_1.getName().toUpperCase();
            _builder_5.append(_upperCase_4);
            _builder_5.append("_ID.ordinal()].");
            _builder_5.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
            _builder_5.append(" = ");
            String _name_8 = s_1.getName();
            String _plus_17 = (_name_8 + "_");
            String _plus_18 = (_plus_17 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
            _builder_5.append(_plus_18);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder_5.newLine();
    _builder_5.append("for(int i = 0; i < (int) StateIDEnum.");
    _builder_5.append(SMCodeGeneratorConstants.STATE_MAX);
    _builder_5.append(".ordinal(); i++) {");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t");
    _builder_5.append("if (");
    _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder_5.append("[i].");
    _builder_5.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "\t");
    _builder_5.append(" != doActivity_dft) {");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t");
    _builder_5.newLine();
    _builder_5.append("\t\t");
    _builder_5.append("StructForThread_t threadstructs = new StructForThread_t(this, ThreadFunctions.TF_DO_ACTIVITY,  i,sem);");
    _builder_5.newLine();
    _builder_5.append("\t\t");
    _builder_5.append("threadStructs[i] = threadstructs;");
    _builder_5.newLine();
    _builder_5.append("\t\t");
    _builder_5.append("threadStructs[i].start();");
    _builder_5.newLine();
    _builder_5.append("\t");
    _builder_5.append("}");
    _builder_5.newLine();
    _builder_5.append("}");
    _builder_5.newLine();
    _builder_5.append("\t");
    _builder_5.newLine();
    {
      int _size = this.timeEvents.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder_5.newLine();
        _builder_5.append("for(int i = ");
        String _TIME_EVENT_LOWER_BOUND_1 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder_5.append(_TIME_EVENT_LOWER_BOUND_1);
        _builder_5.append("; i < ");
        int _size_1 = this.timeEvents.size();
        _builder_5.append(_size_1);
        _builder_5.append("; i++) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("timeEventThreadStructs[i] = new StructForThread_t(this,  ThreadFunctions.TF_TIME_EVENT,i,sem );");
        _builder_5.newLine();
        _builder_5.append("}");
        _builder_5.newLine();
        {
          for(final TimeEvent e : this.timeEvents) {
            ValueSpecification _expr = e.getWhen().getExpr();
            long duration = ParseVSL.getMsDurationFromVSL(((OpaqueExpression) _expr).getBodies().get(0));
            _builder_5.newLineIfNotEmpty();
            _builder_5.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT);
            _builder_5.append("[");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder_5.append(_TE_INDEX);
            _builder_5.append("(EventId_t.");
            String _eventID = TransformationUtil.eventID(e);
            _builder_5.append(_eventID);
            _builder_5.append(".ordinal())].duration = ");
            _builder_5.append(duration);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
        _builder_5.append("for(int i = ");
        String _TIME_EVENT_LOWER_BOUND_2 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder_5.append(_TIME_EVENT_LOWER_BOUND_2);
        _builder_5.append("; i < ");
        int _size_2 = this.timeEvents.size();
        _builder_5.append(_size_2);
        _builder_5.append("; i++) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("timeEventThreadStructs[i].start();");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("while (timeEventFlags[");
        String _TE_INDEX_1 = this.cdefs.TE_INDEX();
        _builder_5.append(_TE_INDEX_1, "\t");
        _builder_5.append("(i)]) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("dispatchStruct = new StructForThread_t(this, 0, ThreadFunctions.TF_STATE_MACHINE_TYPE);");
        _builder_5.newLine();
        _builder_5.append("dispatchStruct.start();");
        _builder_5.newLine();
      }
    }
    _builder_5.newLine();
    {
      boolean _isEmpty_1 = this.orthogonalRegions.isEmpty();
      boolean _not = (!_isEmpty_1);
      if (_not) {
        {
          for(final Region r : this.orthogonalRegions) {
            _builder_5.append(SMCodeGeneratorConstants.REGION_TABLE);
            _builder_5.append("[");
            String _regionMacroId = this.getRegionMacroId(r);
            _builder_5.append(_regionMacroId);
            _builder_5.append("] = &");
            String _name_9 = this.superContext.getName();
            _builder_5.append(_name_9);
            _builder_5.append("::");
            String _regionMethodName = this.getRegionMethodName(r);
            _builder_5.append(_regionMethodName);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append(SMCodeGeneratorConstants.REGION_TABLE_EXIT);
            _builder_5.append("[");
            String _regionMacroId_1 = this.getRegionMacroId(r);
            _builder_5.append(_regionMacroId_1);
            _builder_5.append("] = &");
            String _name_10 = this.superContext.getName();
            _builder_5.append(_name_10);
            _builder_5.append("::");
            String _regionMethodExitName = this.getRegionMethodExitName(r);
            _builder_5.append(_regionMethodExitName);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      boolean _isEmpty_2 = this.parallelTransitions.isEmpty();
      boolean _not_1 = (!_isEmpty_2);
      if (_not_1) {
        {
          for(final Transition t : this.parallelTransitions) {
            _builder_5.append(SMCodeGeneratorConstants.PARALLEL_TRANSITION_TABLE);
            _builder_5.append("[");
            String _parallelTransitionId = this.concurrency.parallelTransitionId(t);
            _builder_5.append(_parallelTransitionId);
            _builder_5.append("] = &");
            String _name_11 = this.superContext.getName();
            _builder_5.append(_name_11);
            _builder_5.append("::");
            String _parallelTransitionMethodName = this.concurrency.parallelTransitionMethodName(t);
            _builder_5.append(_parallelTransitionMethodName);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder_5.newLine();
    {
      int _size_3 = this.changeEvents.size();
      boolean _greaterThan_1 = (_size_3 > 0);
      if (_greaterThan_1) {
        _builder_5.append("// threads for changeEvent");
        _builder_5.newLine();
        _builder_5.append("for(int i = ");
        String _CHANGE_EVENT_LOWER_BOUND = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_5.append(_CHANGE_EVENT_LOWER_BOUND);
        _builder_5.append("; i < ");
        String _CHANGE_EVENT_LOWER_BOUND_1 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_5.append(_CHANGE_EVENT_LOWER_BOUND_1);
        _builder_5.append(" + ");
        int _size_4 = this.changeEvents.size();
        _builder_5.append(_size_4);
        _builder_5.append("; i++) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_5.append("[");
        String _CHE_INDEX = this.cdefs.CHE_INDEX();
        _builder_5.append(_CHE_INDEX, "\t");
        _builder_5.append("(i)].id = i;");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_5.append("[");
        String _CHE_INDEX_1 = this.cdefs.CHE_INDEX();
        _builder_5.append(_CHE_INDEX_1, "\t");
        _builder_5.append("(i)].ptr = this;");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_5.append("[");
        String _CHE_INDEX_2 = this.cdefs.CHE_INDEX();
        _builder_5.append(_CHE_INDEX_2, "\t");
        _builder_5.append("(i)].func_type = ");
        _builder_5.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_CHANGEEVENT_TYPE, "\t");
        _builder_5.append(";");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append(SMCodeGeneratorConstants.FORK_NAME, "\t");
        _builder_5.append("(&");
        _builder_5.append(SMCodeGeneratorConstants.THREADS_CHANGE_EVENT, "\t");
        _builder_5.append("[");
        String _CHE_INDEX_3 = this.cdefs.CHE_INDEX();
        _builder_5.append(_CHE_INDEX_3, "\t");
        _builder_5.append("(i)], NULL, &");
        String _name_12 = this.superContext.getName();
        _builder_5.append(_name_12, "\t");
        _builder_5.append("::");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t");
        _builder_5.append(", &");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_5.append("[");
        String _CHE_INDEX_4 = this.cdefs.CHE_INDEX();
        _builder_5.append(_CHE_INDEX_4, "\t");
        _builder_5.append("(i)]);");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("}");
        _builder_5.newLine();
      }
    }
    _builder_5.newLine();
    _builder_5.append("// initialize root active state");
    _builder_5.newLine();
    _builder_5.append("// execute initial effect");
    _builder_5.newLine();
    String _regionMethodName_1 = this.getRegionMethodName(this.topRegion);
    _builder_5.append(_regionMethodName_1);
    _builder_5.append("(");
    String _initialMacroName = this.getInitialMacroName(this.topRegion);
    _builder_5.append(_initialMacroName);
    _builder_5.append(");");
    _builder_5.newLineIfNotEmpty();
    this.createOpaqueBehavior(this.superContext, startBehavior, _builder_5.toString());
    Operation stopBehavior = this.superContext.createOwnedOperation("stop", null, null);
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
    _builder_6.append(" = statemachineJava.SystemStateEnum_t.IDLE;");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("dispatchStruct.interrupt();");
    _builder_6.newLine();
    _builder_6.append("for (int i = ");
    String _TIME_EVENT_LOWER_BOUND_3 = this.cdefs.TIME_EVENT_LOWER_BOUND();
    _builder_6.append(_TIME_EVENT_LOWER_BOUND_3);
    _builder_6.append("; i < ");
    int _size_5 = this.timeEvents.size();
    _builder_6.append(_size_5);
    _builder_6.append("; i++) {");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t");
    _builder_6.append("timeEventThreadStructs[i].interrupt();");
    _builder_6.newLine();
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("for (int i = 0; i < (int) StateIDEnum.");
    _builder_6.append(SMCodeGeneratorConstants.STATE_MAX);
    _builder_6.append(".ordinal(); i++) {");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t");
    _builder_6.append("if (");
    _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder_6.append("[i].");
    _builder_6.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "\t");
    _builder_6.append(" != doActivity_dft) {");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t");
    _builder_6.append("threadStructs[i].interrupt();");
    _builder_6.newLine();
    _builder_6.append("\t");
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("}");
    _builder_6.newLine();
    this.createOpaqueBehavior(this.superContext, stopBehavior, _builder_6.toString());
    this.superContext.createOwnedAttribute("dispatchFlag", this.boolType);
    final BiConsumer<Event, List<Transition>> _function_13 = new BiConsumer<Event, List<Transition>>() {
      @Override
      public void accept(final Event e, final List<Transition> trans) {
        SM2ClassesTransformationCore.this.eventTransform.createEventMethod(e, trans);
      }
    };
    eventMap.forEach(_function_13);
    final ArrayList<Transition> autoTrans = new ArrayList<Transition>();
    final Consumer<Transition> _function_14 = new Consumer<Transition>() {
      @Override
      public void accept(final Transition it) {
        if (((it.getSource() instanceof State) && (ListExtensions.<Trigger, Event>map(it.getTriggers(), new Function1<Trigger, Event>() {
          @Override
          public Event apply(final Trigger it) {
            return it.getEvent();
          }
        }).size() == 0))) {
          autoTrans.add(it);
        }
      }
    };
    this.transitions.forEach(_function_14);
    this.eventTransform.createEventMethod(SMCodeGeneratorConstants.COMPLETION_EVENT, autoTrans);
    final Consumer<State> _function_15 = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        String _upperCase = it.getName().toUpperCase();
        String _plus = (_upperCase + "_ID");
        SM2ClassesTransformationCore.this.stateIdEnum.createOwnedLiteral(_plus);
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(SM2ClassesTransformationCore.this.superContext, 
          SMJavaCodeGeneratorConstants.RUNNABLE_QNAME);
        final Interface runnable = ((Interface) _qualifiedElementFromRS);
        boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(it.getEntry());
        if (_isBehaviorExist) {
          String _name = it.getName();
          String _plus_1 = (_name + "_");
          String _plus_2 = (_plus_1 + SMCodeGeneratorConstants.ENTRY_NAME);
          Classifier _createNestedClassifier = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_2, 
            UMLPackage.eINSTANCE.getClass_());
          final org.eclipse.uml2.uml.Class entry = ((org.eclipse.uml2.uml.Class) _createNestedClassifier);
          entry.createInterfaceRealization(null, runnable);
          final Operation entry_run = entry.createOwnedOperation("run", null, null);
          Behavior _entry = it.getEntry();
          OpaqueBehavior opaque = SM2ClassesTransformationCore.this.createOpaqueBehavior(entry, entry_run, IterableExtensions.<String>head(((OpaqueBehavior) _entry).getBodies()));
          opaque.getLanguages().add(SM2ClassesTransformationCore.this.langID);
          String _name_1 = it.getName();
          String _plus_3 = (_name_1 + "_");
          String _plus_4 = (_plus_3 + SMCodeGeneratorConstants.ENTRY_NAME);
          SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_4, entry);
        }
        boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(it.getExit());
        if (_isBehaviorExist_1) {
          String _name_2 = it.getName();
          String _plus_5 = (_name_2 + "_");
          String _plus_6 = (_plus_5 + SMCodeGeneratorConstants.EXIT_NAME);
          Classifier _createNestedClassifier_1 = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_6, 
            UMLPackage.eINSTANCE.getClass_());
          final org.eclipse.uml2.uml.Class exit = ((org.eclipse.uml2.uml.Class) _createNestedClassifier_1);
          exit.createInterfaceRealization(null, runnable);
          final Operation exit_run = exit.createOwnedOperation("run", null, null);
          Behavior _exit = it.getExit();
          OpaqueBehavior opaque_1 = SM2ClassesTransformationCore.this.createOpaqueBehavior(exit, exit_run, IterableExtensions.<String>head(((OpaqueBehavior) _exit).getBodies()));
          opaque_1.getLanguages().add(SM2ClassesTransformationCore.this.langID);
          String _name_3 = it.getName();
          String _plus_7 = (_name_3 + "_");
          String _plus_8 = (_plus_7 + SMCodeGeneratorConstants.EXIT_NAME);
          SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_8, exit);
        }
        boolean _isBehaviorExist_2 = TransformationUtil.isBehaviorExist(it.getDoActivity());
        if (_isBehaviorExist_2) {
          SM2ClassesTransformationCore.this.doActivityList.add(it.getDoActivity());
          String _name_4 = it.getName();
          String _plus_9 = (_name_4 + "_");
          String _plus_10 = (_plus_9 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
          Classifier _createNestedClassifier_2 = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_10, 
            UMLPackage.eINSTANCE.getClass_());
          final org.eclipse.uml2.uml.Class doActivity = ((org.eclipse.uml2.uml.Class) _createNestedClassifier_2);
          doActivity.createInterfaceRealization(null, runnable);
          final Operation doActivity_run = doActivity.createOwnedOperation("run", null, null);
          Behavior _doActivity = it.getDoActivity();
          OpaqueBehavior opaque_2 = SM2ClassesTransformationCore.this.createOpaqueBehavior(doActivity, doActivity_run, 
            IterableExtensions.<String>head(((OpaqueBehavior) _doActivity).getBodies()));
          opaque_2.getLanguages().add(SM2ClassesTransformationCore.this.langID);
          String _name_5 = it.getName();
          String _plus_11 = (_name_5 + "_");
          String _plus_12 = (_plus_11 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
          SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_12, doActivity);
        } else {
        }
      }
    };
    this.states.forEach(_function_15);
    this.stateIdEnum.createOwnedLiteral(SMCodeGeneratorConstants.STATE_MAX);
    this.concurrency.createThreadBasedParallelism();
    this.smPack.getOwnedType("Event_t");
    Operation eventDispatch = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.EVENT_DISPATCH, null, null);
    StringConcatenation _builder_7 = new StringConcatenation();
    _builder_7.append("boolean popDeferred = false;");
    _builder_7.newLine();
    _builder_7.append("while (!Thread.currentThread().isInterrupted()) {");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("// run-to-completion: need to have a mutex here");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("try {");
    _builder_7.newLine();
    _builder_7.append("\t\t");
    _builder_7.append("currentEvent = ");
    _builder_7.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t");
    _builder_7.append(".take();");
    _builder_7.newLineIfNotEmpty();
    _builder_7.append("\t");
    _builder_7.append("} catch (InterruptedException e) {");
    _builder_7.newLine();
    _builder_7.append("\t\t");
    _builder_7.append("// interruption, exit loop");
    _builder_7.newLine();
    _builder_7.append("\t\t");
    _builder_7.append("break;");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("}");
    _builder_7.newLine();
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("dispatchFlag = true;");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("if (currentEvent != null) {");
    _builder_7.newLine();
    _builder_7.append("\t\t");
    _builder_7.append("int eventID = currentEvent.getEventID();");
    _builder_7.newLine();
    _builder_7.newLine();
    {
      final Function1<Event, Boolean> _function_16 = new Function1<Event, Boolean>() {
        @Override
        public Boolean apply(final Event it) {
          return Boolean.valueOf((!(it instanceof CallEvent)));
        }
      };
      Iterable<Event> _filter = IterableExtensions.<Event>filter(eventMap.keySet(), _function_16);
      for(final Event e_1 : _filter) {
        _builder_7.append("\t\t");
        _builder_7.append("if (eventID == EventId_t.");
        String _eventID_1 = TransformationUtil.eventID(e_1);
        _builder_7.append(_eventID_1, "\t\t");
        _builder_7.append(".ordinal()) { ");
        _builder_7.newLineIfNotEmpty();
        {
          if (((e_1 instanceof SignalEvent) && (((SignalEvent) e_1).getSignal() != null))) {
            _builder_7.append("\t\t");
            _builder_7.append("\t");
            _builder_7.append("if (currentEvent != NULL) {");
            _builder_7.newLine();
            _builder_7.append("\t\t");
            _builder_7.append("\t");
            _builder_7.append("\t");
            _builder_7.append("memcpy(&sig_");
            String _eventID_2 = TransformationUtil.eventID(e_1);
            _builder_7.append(_eventID_2, "\t\t\t\t");
            _builder_7.append(", currentEvent->data, sizeof();");
            _builder_7.newLineIfNotEmpty();
            _builder_7.append("\t\t");
            _builder_7.append("\t");
            _builder_7.append("\t");
            _builder_7.append("process");
            String _eventName = TransformationUtil.eventName(e_1);
            _builder_7.append(_eventName, "\t\t\t\t");
            _builder_7.append("(sig_");
            String _eventID_3 = TransformationUtil.eventID(e_1);
            _builder_7.append(_eventID_3, "\t\t\t\t");
            _builder_7.append(");");
            _builder_7.newLineIfNotEmpty();
            _builder_7.append("\t\t");
            _builder_7.append("\t");
            _builder_7.append("}");
            _builder_7.newLine();
          } else {
            _builder_7.append("\t\t");
            _builder_7.append("\t");
            _builder_7.append("process");
            String _eventName_1 = TransformationUtil.eventName(e_1);
            _builder_7.append(_eventName_1, "\t\t\t");
            _builder_7.append("();");
            _builder_7.newLineIfNotEmpty();
          }
        }
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("}");
        _builder_7.newLine();
      }
    }
    _builder_7.append("\t\t");
    _builder_7.append("if (eventID == EventId_t.COMPLETIONEVENT_ID.ordinal()) {");
    _builder_7.newLine();
    _builder_7.append("\t\t\t");
    _builder_7.append("processCompletionEvent();");
    _builder_7.newLine();
    _builder_7.append("\t\t");
    _builder_7.append("}");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("}");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("if (");
    _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
    _builder_7.append(" == SystemStateEnum_t.EVENT_DEFERRED) {");
    _builder_7.newLineIfNotEmpty();
    _builder_7.append("\t\t");
    _builder_7.append("// ");
    _builder_7.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t");
    _builder_7.append(".saveDeferred(*currentEvent);");
    _builder_7.newLineIfNotEmpty();
    _builder_7.append("\t");
    _builder_7.append("}");
    _builder_7.newLine();
    _builder_7.append("\t");
    _builder_7.append("popDeferred = (");
    _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
    _builder_7.append(" != SystemStateEnum_t.EVENT_DEFERRED);");
    _builder_7.newLineIfNotEmpty();
    _builder_7.append("\t");
    _builder_7.append("// ");
    _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
    _builder_7.append(" = SystemStateEnum_t.IDLE;");
    _builder_7.newLineIfNotEmpty();
    _builder_7.append("}");
    _builder_7.newLine();
    this.createOpaqueBehavior(this.superContext, eventDispatch, _builder_7.toString());
    this.concurrency.createConcurrencyForTransitions();
    this.createChangeEvents();
  }
  
  public void appendImport(final String appended) {
    final Import import_ = StereotypeUtil.<Import>applyApp(this.superContext, Import.class);
    StringConcatenation _builder = new StringConcatenation();
    String _manualImports = import_.getManualImports();
    _builder.append(_manualImports);
    _builder.newLineIfNotEmpty();
    _builder.append(appended);
    import_.setManualImports(_builder.toString());
  }
  
  private void createChangeEvents() {
    new ChangeEventTransformation(this).createChangeEvents();
  }
  
  public String generateChangeState(final State s) {
    Region _container = s.getContainer();
    boolean _equals = Objects.equal(_container, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
      _builder.append(" = StateIDEnum.");
      String _upperCase = s.getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_ID;");
      return _builder.toString();
    }
    int rIndex = s.getContainer().getState().getRegions().indexOf(s.getContainer());
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder_1.append("[StateIDEnum.");
    String _upperCase_1 = s.getContainer().getState().getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID.ordinal()].");
    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
    _builder_1.append("[");
    _builder_1.append(rIndex);
    _builder_1.append("] = ");
    String _upperCase_2 = s.getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_ID;");
    return _builder_1.toString();
  }
  
  public String generateExitingSubStates(final State parent, final boolean exitParent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        _builder_1.append("//exiting concurrent state ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.newLineIfNotEmpty();
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            String _generateForkCall = this.concurrency.generateForkCall(r, false, "0");
            _builder_1.append(_generateForkCall);
            _builder_1.newLineIfNotEmpty();
          }
        }
        {
          EList<Region> _regions_1 = parent.getRegions();
          for(final Region r_1 : _regions_1) {
            String _generateJoinCall = this.concurrency.generateJoinCall(r_1, false);
            _builder_1.append(_generateJoinCall);
            _builder_1.newLineIfNotEmpty();
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          String _regionMethodExitName = this.getRegionMethodExitName(IterableExtensions.<Region>head(parent.getRegions()));
          _builder_1.append(_regionMethodExitName);
          _builder_1.append("();");
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    {
      if (exitParent) {
        {
          boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(parent.getDoActivity());
          if (_isBehaviorExist) {
            _builder_1.append("//signal to exit the doActivity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1);
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
            _builder_1.append("(StateIDEnum.");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
          }
        }
        CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "false");
        _builder_1.append(_generateActivateTimeEvent);
        _builder_1.newLineIfNotEmpty();
        {
          boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(parent.getExit());
          if (_isBehaviorExist_1) {
            _builder_1.append("//exit action of ");
            String _name_2 = parent.getName();
            _builder_1.append(_name_2);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.EXIT_NAME);
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
          }
        }
        _builder_1.append("\t\t");
      }
    }
    return _builder_1.toString();
  }
  
  public CharSequence generateActivateTimeEvent(final State s, final String trueOrFalse) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<TimeEvent> _get = this.states2TimeEvents.get(s);
      boolean _tripleNotEquals = (_get != null);
      if (_tripleNotEquals) {
        {
          List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
          for(final TimeEvent te : _get_1) {
            _builder.append(SMCodeGeneratorConstants.SET_FLAG);
            _builder.append("(");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder.append(_TE_INDEX);
            _builder.append("(EventId_t.");
            String _eventID = TransformationUtil.eventID(te);
            _builder.append(_eventID);
            _builder.append(".ordinal()), ");
            _builder.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE);
            _builder.append(", ");
            _builder.append(trueOrFalse);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  @Deprecated
  public String generateExitingSubStatesWithTransition(final State parent, final boolean exitParent, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
                }
              };
              Iterable<State> _filter = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function);
              boolean _hasElements = false;
              for(final State s : _filter) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder_1.appendImmediate(" else ", "");
                }
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder_1.append("[StateIDEnum.");
                String _upperCase_1 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_1);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                _builder_1.append("[");
                int _indexOf = parent.getRegions().indexOf(r);
                _builder_1.append(_indexOf);
                _builder_1.append("] == &");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder_1.append("[StateIDEnum.");
                String _upperCase_2 = s.getName().toUpperCase();
                _builder_1.append(_upperCase_2);
                _builder_1.append("_ID.ordinal()]) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                String _generateExitingSubStates = this.generateExitingSubStates(s, true);
                _builder_1.append(_generateExitingSubStates, "\t");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
              }
            }
            _builder_1.append("if (");
            _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_1.append("[StateIDEnum.");
            String _upperCase_3 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_3);
            _builder_1.append("_ID.ordinal()].");
            _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            _builder_1.append("[");
            int _indexOf_1 = parent.getRegions().indexOf(r);
            _builder_1.append(_indexOf_1);
            _builder_1.append("] != NULL) {");
            _builder_1.newLineIfNotEmpty();
            {
              final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf((!(it instanceof FinalState)));
                }
              };
              Iterable<State> _filter_1 = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function_1);
              boolean _hasElements_1 = false;
              for(final State sub : _filter_1) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder_1.appendImmediate(" else ", "\t");
                }
                _builder_1.append("\t");
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4, "\t");
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
                _builder_1.append("[");
                int _indexOf_2 = parent.getRegions().indexOf(r);
                _builder_1.append(_indexOf_2, "\t");
                _builder_1.append("] == &");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_5 = sub.getName().toUpperCase();
                _builder_1.append(_upperCase_5, "\t");
                _builder_1.append("_ID.ordinal()]) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("\t");
                _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
                _builder_1.append("(StateIdEnum.");
                String _upperCase_6 = sub.getName().toUpperCase();
                _builder_1.append(_upperCase_6, "\t\t");
                _builder_1.append("_ID.ordinal(), ");
                _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
                _builder_1.append(", false);");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("}");
                _builder_1.newLine();
              }
            }
            _builder_1.append("\t");
            String _upperCase_7 = parent.getName().toUpperCase();
            String _plus = ((SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE + "[StateIDEnum.") + _upperCase_7);
            String _plus_1 = (_plus + "_ID.ordinal()].");
            String _plus_2 = (_plus_1 + SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            String _plus_3 = (_plus_2 + "[");
            int _indexOf_3 = parent.getRegions().indexOf(r);
            String _plus_4 = (_plus_3 + Integer.valueOf(_indexOf_3));
            String _plus_5 = (_plus_4 + "]");
            String _fptrCall = this.getFptrCall(_plus_5, SMCodeGeneratorConstants.EXIT_NAME);
            _builder_1.append(_fptrCall, "\t");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_1.append("[StateIdEnum.");
            String _upperCase_8 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_8);
            _builder_1.append("_ID.ordinal()].");
            _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            _builder_1.append("[");
            int _indexOf_4 = parent.getRegions().indexOf(r);
            _builder_1.append(_indexOf_4);
            _builder_1.append("] = NULL;");
            _builder_1.newLineIfNotEmpty();
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            final Function1<State, Boolean> _function_2 = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
              }
            };
            Iterable<State> _filter_2 = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_2);
            boolean _hasElements_2 = false;
            for(final State s_1 : _filter_2) {
              if (!_hasElements_2) {
                _hasElements_2 = true;
              } else {
                _builder_1.appendImmediate(" else ", "");
              }
              _builder_1.append("if (");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[StateIdEnum.");
              String _upperCase_9 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_9);
              _builder_1.append("_ID.ordinal()].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] == ");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[StateIDEnum.");
              String _upperCase_10 = s_1.getName().toUpperCase();
              _builder_1.append(_upperCase_10);
              _builder_1.append("_ID.ordinal()]) {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              String _generateExitingSubStates_1 = this.generateExitingSubStates(s_1, true);
              _builder_1.append(_generateExitingSubStates_1, "\t");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
          _builder_1.append("if (");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[StateIdEnum.");
          String _upperCase_11 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_11);
          _builder_1.append("_ID.ordinal()].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] != NULL) {");
          _builder_1.newLineIfNotEmpty();
          {
            final Function1<State, Boolean> _function_3 = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf((!(it instanceof FinalState)));
              }
            };
            Iterable<State> _filter_3 = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_3);
            boolean _hasElements_3 = false;
            for(final State sub_1 : _filter_3) {
              if (!_hasElements_3) {
                _hasElements_3 = true;
              } else {
                _builder_1.appendImmediate(" else ", "\t");
              }
              _builder_1.append("\t");
              _builder_1.append("if (");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
              _builder_1.append("[StateIDEnum.");
              String _upperCase_12 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_12, "\t");
              _builder_1.append("_ID.ordinal()].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
              _builder_1.append("[0] == ");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
              _builder_1.append("[StateIDEnum.");
              String _upperCase_13 = sub_1.getName().toUpperCase();
              _builder_1.append(_upperCase_13, "\t");
              _builder_1.append("_ID.ordinal()]) {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
              _builder_1.append("(StateIDEnum.");
              String _upperCase_14 = sub_1.getName().toUpperCase();
              _builder_1.append(_upperCase_14, "\t\t");
              _builder_1.append("_ID.ordinal(), ");
              _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
              _builder_1.append(", false);");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
          _builder_1.append("\t");
          String _upperCase_15 = parent.getName().toUpperCase();
          String _plus_6 = ((SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE + "[StateIDEnum") + _upperCase_15);
          String _plus_7 = (_plus_6 + "_ID.ordinal()].");
          String _plus_8 = (_plus_7 + SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          String _plus_9 = (_plus_8 + "[0]");
          String _fptrCall_1 = this.getFptrCall(_plus_9, SMCodeGeneratorConstants.EXIT_NAME);
          _builder_1.append(_fptrCall_1, "\t");
          _builder_1.append(";");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[StateIDEnum.");
          String _upperCase_16 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_16);
          _builder_1.append("_ID.ordinal()].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] = NULL;");
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    {
      if (exitParent) {
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(StateIDEnum.");
        String _upperCase_17 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_17);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", false);");
        _builder_1.newLineIfNotEmpty();
        String _fptrCall_2 = this.getFptrCall(pAttr, SMCodeGeneratorConstants.EXIT_NAME);
        _builder_1.append(_fptrCall_2);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
      }
    }
    String _transitionEffect = TransformationUtil.getTransitionEffect(t);
    _builder_1.append(_transitionEffect);
    return _builder_1.toString();
  }
  
  @Deprecated
  public String generateEnteringSubStates(final State parent, final boolean enterParent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              State _findInitialState = TransformationUtil.findInitialState(r);
              boolean _tripleNotEquals = (_findInitialState != null);
              if (_tripleNotEquals) {
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _findInitialState_1 = TransformationUtil.findInitialState(IterableExtensions.<Region>head(parent.getRegions()));
            boolean _tripleNotEquals_1 = (_findInitialState_1 != null);
            if (_tripleNotEquals_1) {
              String _initialEffect_1 = TransformationUtil.getInitialEffect(IterableExtensions.<Region>head(parent.getRegions()));
              _builder_1.append(_initialEffect_1);
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState(IterableExtensions.<Region>head(parent.getRegions())), true);
              _builder_1.append(_generateEnteringSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  @Deprecated
  public String generateEnteringSubStates(final State parent, final State child, final boolean enterParent, final boolean gotoSubstate) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equal(_container, r);
              if (_equals) {
                {
                  if (gotoSubstate) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              } else {
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean _tripleNotEquals = (_findInitialState != null);
                if (_tripleNotEquals) {
                  String _initialEffect = TransformationUtil.getInitialEffect(r);
                  _builder_1.append(_initialEffect);
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                  _builder_1.append(_generateEnteringSubStates_1);
                  _builder_1.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          _builder_1.append("//");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[StateIDEnum.");
          String _upperCase_2 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_2);
          _builder_1.append("_ID.ordinal()].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] = &");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[StateIDEnum.");
          String _upperCase_3 = child.getName().toUpperCase();
          _builder_1.append(_upperCase_3);
          _builder_1.append("_ID.ordinal()];");
          _builder_1.newLineIfNotEmpty();
          String _generateEnteringSubStates_2 = this.generateEnteringSubStates(child, true);
          _builder_1.append(_generateEnteringSubStates_2);
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  @Deprecated
  public String generateEnteringTransitiveSubStates(final State parent, final State child) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("// start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(StateIDEnum.");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID.ordinal(), ");
    _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equal(_container, r);
              if (_equals) {
                String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = TransformationUtil.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
                    @Override
                    public Boolean apply(final State it) {
                      return Boolean.valueOf(TransformationUtil.transitiveSubStates(it).contains(child));
                    }
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                  _builder_1.append(_generateEnteringTransitiveSubStates);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = TransformationUtil.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = TransformationUtil.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equal(_state, parent);
            if (_equals_1) {
              String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, false, false);
              _builder_1.append(_generateEnteringSubStates_2);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf(TransformationUtil.transitiveSubStates(it).contains(child));
                }
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
              _builder_1.append(_generateEnteringTransitiveSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  @Deprecated
  public String generateEnteringTransitiveSubStates(final State parent, final State child, final boolean enterParent, final boolean gotoChild) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equal(_container, r);
              if (_equals) {
                {
                  if (gotoChild) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              } else {
                boolean _contains = TransformationUtil.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
                    @Override
                    public Boolean apply(final State it) {
                      return Boolean.valueOf(TransformationUtil.transitiveSubStates(it).contains(child));
                    }
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                  _builder_1.append(_generateEnteringTransitiveSubStates);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = TransformationUtil.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = TransformationUtil.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equal(_state, parent);
            if (_equals_1) {
              {
                if (gotoChild) {
                  String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, enterParent, false);
                  _builder_1.append(_generateEnteringSubStates_2);
                  _builder_1.newLineIfNotEmpty();
                }
              }
            } else {
              final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf(TransformationUtil.transitiveSubStates(it).contains(child));
                }
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
              _builder_1.append(_generateEnteringTransitiveSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  private List<State> transitiveSubStates(final Region r) {
    return TransformationUtil.transitiveSubStates(r);
  }
  
  private List<State> transitiveSubStates(final State s) {
    return TransformationUtil.transitiveSubStates(s);
  }
  
  @Deprecated
  public String generateEnteringSpecial(final State parent, final Pseudostate child) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal(),]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("// start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(StateIDEnum.");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID.ordinal(), ");
    _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equal(_container, r);
              if (_equals) {
                String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                _builder_1.append(_generatePseudo);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = this.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
                    @Override
                    public Boolean apply(final State it) {
                      return Boolean.valueOf(SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child));
                    }
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                  _builder_1.append("[StateIDEnum.");
                  String _upperCase_2 = parent.getName().toUpperCase();
                  _builder_1.append(_upperCase_2);
                  _builder_1.append("_ID.ordinal(),].");
                  _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                  _builder_1.append("[");
                  int _indexOf = parent.getRegions().indexOf(r);
                  _builder_1.append(_indexOf);
                  _builder_1.append("] = ");
                  String _upperCase_3 = nextParent.getName().toUpperCase();
                  _builder_1.append(_upperCase_3);
                  _builder_1.append("_ID;");
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                  _builder_1.append(_generateEnteringSpecial);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = TransformationUtil.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = TransformationUtil.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                    _builder_1.append("[");
                    int _indexOf_1 = parent.getRegions().indexOf(r);
                    _builder_1.append(_indexOf_1);
                    _builder_1.append("] = ");
                    String _upperCase_5 = TransformationUtil.findInitialState(r).getName().toUpperCase();
                    _builder_1.append(_upperCase_5);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equal(_state, parent);
            if (_equals_1) {
              String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
              _builder_1.append(_generatePseudo_1);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf(SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child));
                }
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[StateIDEnum.");
              String _upperCase_6 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_6);
              _builder_1.append("_ID.ordinal()].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] = ");
              String _upperCase_7 = nextParent_1.getName().toUpperCase();
              _builder_1.append(_upperCase_7);
              _builder_1.append("_ID;");
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
              _builder_1.append(_generateEnteringSpecial_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  @Deprecated
  public String generateEnteringSpecial(final State parent, final Pseudostate child, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _transitionEffect = TransformationUtil.getTransitionEffect(t);
    _builder_1.append(_transitionEffect);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("// start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(StateIDEnum.");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID.ordinal(), ");
    _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    _builder_1.newLine();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equal(_container, r);
              if (_equals) {
                String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                _builder_1.append(_generatePseudo);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = this.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
                    @Override
                    public Boolean apply(final State it) {
                      return Boolean.valueOf(SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child));
                    }
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                  _builder_1.append("[StateIDEnum.");
                  String _upperCase_2 = parent.getName().toUpperCase();
                  _builder_1.append(_upperCase_2);
                  _builder_1.append("_ID.ordinal()].");
                  _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                  _builder_1.append("[");
                  int _indexOf = parent.getRegions().indexOf(r);
                  _builder_1.append(_indexOf);
                  _builder_1.append("] = ");
                  String _upperCase_3 = nextParent.getName().toUpperCase();
                  _builder_1.append(_upperCase_3);
                  _builder_1.append("_ID;");
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                  _builder_1.append(_generateEnteringSpecial);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = TransformationUtil.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = TransformationUtil.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                    _builder_1.append("[");
                    int _indexOf_1 = parent.getRegions().indexOf(r);
                    _builder_1.append(_indexOf_1);
                    _builder_1.append("] = ");
                    String _upperCase_5 = TransformationUtil.findInitialState(r).getName().toUpperCase();
                    _builder_1.append(_upperCase_5);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equal(_state, parent);
            if (_equals_1) {
              String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
              _builder_1.append(_generatePseudo_1);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
                @Override
                public Boolean apply(final State it) {
                  return Boolean.valueOf(SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child));
                }
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[StateIDEnum.");
              String _upperCase_6 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_6);
              _builder_1.append("_ID.ordinal()].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] = ");
              String _upperCase_7 = nextParent_1.getName().toUpperCase();
              _builder_1.append(_upperCase_7);
              _builder_1.append("_ID;");
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
              _builder_1.append(_generateEnteringSpecial_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }
  
  public String generateCompletionCall(final State state) {
    StringConcatenation _builder = new StringConcatenation();
    String callCompletionEvent = _builder.toString();
    State composite = state.getContainer().getState();
    if ((composite == null)) {
      StringConcatenation _builder_1 = new StringConcatenation();
      callCompletionEvent = _builder_1.toString();
    } else {
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("if (");
      {
        EList<Region> _regions = composite.getRegions();
        boolean _hasElements = false;
        for(final Region r : _regions) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder_2.appendImmediate(" && ", "");
          }
          _builder_2.append("(");
          _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_2.append("[StateIDEnum.");
          String _upperCase = composite.getName().toUpperCase();
          _builder_2.append(_upperCase);
          _builder_2.append("_ID.ordinal()].");
          _builder_2.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_2.append("[");
          int _indexOf = composite.getRegions().indexOf(r);
          _builder_2.append(_indexOf);
          _builder_2.append("] == ");
          _builder_2.append(SMCodeGeneratorConstants.STATE_MAX);
          _builder_2.append(")");
        }
      }
      _builder_2.append(") {");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      _builder_2.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
      _builder_2.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
      String _upperCase_1 = composite.getName().toUpperCase();
      _builder_2.append(_upperCase_1, "\t");
      _builder_2.append("_ID);");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("}");
      callCompletionEvent = _builder_2.toString();
    }
    return callCompletionEvent;
  }
  
  public TransitionGraph calculateTransitionGraphs(final State s, final Transition t) {
    TransitionGraph ret = new TransitionGraph();
    Vertex _target = t.getTarget();
    ret.P.add(((Pseudostate) _target));
    ret.T.add(t);
    ret.S.add(s);
    Vertex _target_1 = t.getTarget();
    Pseudostate target = ((Pseudostate) _target_1);
    PseudostateKind _kind = target.getKind();
    boolean _equals = Objects.equal(_kind, PseudostateKind.JOIN_LITERAL);
    if (_equals) {
      final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
        @Override
        public Boolean apply(final Transition it) {
          State _state = it.getSource().getContainer().getState();
          State _state_1 = s.getContainer().getState();
          return Boolean.valueOf(Objects.equal(_state, _state_1));
        }
      };
      List<Transition> ins = IterableExtensions.<Transition>toList(IterableExtensions.<Transition>filter(target.getIncomings(), _function));
      final Function1<Transition, Vertex> _function_1 = new Function1<Transition, Vertex>() {
        @Override
        public Vertex apply(final Transition it) {
          return it.getSource();
        }
      };
      Iterables.<State>addAll(ret.S, Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(ins, _function_1), State.class));
      ret.T.addAll(ins);
    }
    List<Transition> nexts = SMCommon.findTrans(t.getTarget());
    ret.T.addAll(nexts);
    final Function1<Transition, Vertex> _function_2 = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return t.getTarget();
      }
    };
    final Function1<Pseudostate, Boolean> _function_3 = new Function1<Pseudostate, Boolean>() {
      @Override
      public Boolean apply(final Pseudostate it) {
        return Boolean.valueOf((Objects.equal(it.getKind(), PseudostateKind.DEEP_HISTORY_LITERAL) || Objects.equal(it.getKind(), PseudostateKind.SHALLOW_HISTORY_LITERAL)));
      }
    };
    Iterable<Pseudostate> H = IterableExtensions.<Pseudostate>filter(Iterables.<Pseudostate>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_2), Pseudostate.class), _function_3);
    Iterables.<Pseudostate>addAll(ret.P, H);
    final Function1<Transition, Vertex> _function_4 = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return it.getSource();
      }
    };
    Iterables.<Pseudostate>addAll(ret.P, Iterables.<Pseudostate>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_4), Pseudostate.class));
    final Function1<Transition, Vertex> _function_5 = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return it.getTarget();
      }
    };
    Iterables.<State>addAll(ret.L, Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_5), State.class));
    return ret;
  }
  
  private OpaqueExpression createOpaqueExpressionDefaultValue(final Property container, final String name) {
    ValueSpecification _defaultValue = container.getDefaultValue();
    OpaqueExpression opaque = ((OpaqueExpression) _defaultValue);
    if ((opaque == null)) {
      ValueSpecification _createDefaultValue = container.createDefaultValue(name, null, UMLPackage.Literals.OPAQUE_EXPRESSION);
      opaque = ((OpaqueExpression) _createDefaultValue);
      opaque.getLanguages().add(this.langID);
    }
    return opaque;
  }
  
  public OpaqueExpression createOpaqueExpressionDefaultValue(final Property container, final String name, final String body) {
    OpaqueExpression opaque = this.createOpaqueExpressionDefaultValue(container, name);
    int _size = opaque.getBodies().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      opaque.getBodies().set(0, body);
    } else {
      opaque.getLanguages().add(this.langID);
      opaque.getBodies().add(body);
    }
    return opaque;
  }
  
  public List<State> getTransitiveParentStates(final Vertex s) {
    ArrayList<State> ret = new ArrayList<State>();
    State parent = s.getContainer().getState();
    while ((parent != null)) {
      {
        ret.add(parent);
        parent = parent.getContainer().getState();
      }
    }
    return ret;
  }
  
  /**
   * def generateDelegation(State s, List<Transition> transitions) {
   * return '''
   * «IF checkTransitiveSubStatesAcceptEvent(s, transitions)»
   * «IF s.orthogonal»
   * «ELSE»
   * 
   * «ENDIF»
   * «ENDIF»'''
   * }
   */
  public Property createStateStruct() {
    Property _xblockexpression = null;
    {
      NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.superContext, 
        SMJavaCodeGeneratorConstants.RUNNABLE_QNAME);
      final Interface runnable = ((Interface) _qualifiedElementFromRS);
      Classifier _createNestedClassifier = this.superContext.createNestedClassifier("Entry_dft", UMLPackage.eINSTANCE.getClass_());
      final org.eclipse.uml2.uml.Class entry_dft = ((org.eclipse.uml2.uml.Class) _createNestedClassifier);
      entry_dft.createInterfaceRealization(null, runnable);
      final Operation entry_run = entry_dft.createOwnedOperation("run", null, null);
      this.createOpaqueBehavior(entry_dft, entry_run, "");
      Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("DoActivity_dft", 
        UMLPackage.eINSTANCE.getClass_());
      final org.eclipse.uml2.uml.Class doActivity_dft = ((org.eclipse.uml2.uml.Class) _createNestedClassifier_1);
      doActivity_dft.createInterfaceRealization(null, runnable);
      final Operation doActivity_run = doActivity_dft.createOwnedOperation("run", null, null);
      this.createOpaqueBehavior(doActivity_dft, doActivity_run, "");
      Classifier _createNestedClassifier_2 = this.superContext.createNestedClassifier("Exit_dft", UMLPackage.eINSTANCE.getClass_());
      final org.eclipse.uml2.uml.Class exit_dft = ((org.eclipse.uml2.uml.Class) _createNestedClassifier_2);
      exit_dft.createInterfaceRealization(null, runnable);
      final Operation exit_run = exit_dft.createOwnedOperation("run", null, null);
      this.createOpaqueBehavior(exit_dft, exit_run, "");
      this.superContext.createOwnedAttribute("entry_dft", entry_dft);
      this.superContext.createOwnedAttribute("doActivity_dft", doActivity_dft);
      _xblockexpression = this.superContext.createOwnedAttribute("exit_dft", exit_dft);
    }
    return _xblockexpression;
  }
  
  public String getFptrCall(final String attr, final String fptrName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(attr);
    _builder.append(".");
    _builder.append(fptrName);
    _builder.append(".run()");
    return _builder.toString();
  }
  
  private Map<Event, List<Transition>> getAllEvents(final Region region) {
    final Map<Event, List<Transition>> ret = new LinkedHashMap<Event, List<Transition>>();
    EList<Vertex> subVertices = region.getSubvertices();
    EList<Transition> transitions = region.getTransitions();
    final Consumer<Transition> _function = new Consumer<Transition>() {
      @Override
      public void accept(final Transition it) {
        EList<Trigger> _triggers = it.getTriggers();
        for (final Trigger trigger : _triggers) {
          Event _event = trigger.getEvent();
          boolean _tripleNotEquals = (_event != null);
          if (_tripleNotEquals) {
            boolean _containsKey = ret.containsKey(trigger.getEvent());
            boolean _not = (!_containsKey);
            if (_not) {
              Event _event_1 = trigger.getEvent();
              ArrayList<Transition> _arrayList = new ArrayList<Transition>();
              ret.put(_event_1, _arrayList);
            }
            boolean _contains = ret.get(trigger.getEvent()).contains(it);
            boolean _not_1 = (!_contains);
            if (_not_1) {
              ret.get(trigger.getEvent()).add(it);
            }
          }
        }
      }
    };
    transitions.forEach(_function);
    final Consumer<State> _function_1 = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        EList<Region> _regions = it.getRegions();
        for (final Region subRe : _regions) {
          {
            Map<Event, List<Transition>> m = SM2ClassesTransformationCore.this.getAllEvents(subRe);
            Set<Map.Entry<Event, List<Transition>>> _entrySet = m.entrySet();
            for (final Map.Entry<Event, List<Transition>> e : _entrySet) {
              boolean _containsKey = ret.containsKey(e.getKey());
              boolean _not = (!_containsKey);
              if (_not) {
                ret.put(e.getKey(), e.getValue());
              } else {
                ret.get(e.getKey()).addAll(e.getValue());
              }
            }
          }
        }
      }
    };
    Iterables.<State>filter(subVertices, State.class).forEach(_function_1);
    return ret;
  }
  
  private void getAllActionsTransitionsStates(final Region region) {
    boolean _contains = this.regions.contains(region);
    boolean _not = (!_contains);
    if (_not) {
      this.regions.add(region);
    }
    final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        return Boolean.valueOf(((it.getSource() != null) && (it.getTarget() != null)));
      }
    };
    Iterables.<Transition>addAll(this.transitions, IterableExtensions.<Transition>filter(region.getTransitions(), _function));
    final Function1<Transition, Boolean> _function_1 = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        boolean _contains = SM2ClassesTransformationCore.this.parallelTransitions.contains(it);
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<Transition> _function_2 = new Consumer<Transition>() {
      @Override
      public void accept(final Transition it) {
        Vertex _source = it.getSource();
        if ((_source instanceof Pseudostate)) {
          if ((Objects.equal(((Pseudostate) it.getSource()).getKind(), PseudostateKind.FORK_LITERAL) && (it.getEffect() != null))) {
            SM2ClassesTransformationCore.this.parallelTransitions.add(it);
          }
        }
        Vertex _target = it.getTarget();
        if ((_target instanceof Pseudostate)) {
          if ((Objects.equal(((Pseudostate) it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL) && (it.getEffect() != null))) {
            SM2ClassesTransformationCore.this.parallelTransitions.add(it);
          }
        }
      }
    };
    IterableExtensions.<Transition>filter(this.transitions, _function_1).forEach(_function_2);
    EList<Vertex> _subvertices = region.getSubvertices();
    for (final Vertex s : _subvertices) {
      {
        this.vertexes.add(s);
        if ((s instanceof State)) {
          if ((!(s instanceof FinalState))) {
            this.states.add(((State)s));
          }
          if (((((State)s).getEntry() != null) && (((State)s).getEntry() instanceof OpaqueBehavior))) {
            Behavior _entry = ((State)s).getEntry();
            this.actions.add(((OpaqueBehavior) _entry));
          }
          if (((((State)s).getExit() != null) && (((State)s).getExit() instanceof OpaqueBehavior))) {
            Behavior _exit = ((State)s).getExit();
            this.actions.add(((OpaqueBehavior) _exit));
          }
          if (((this.createDoActivity && (((State)s).getDoActivity() != null)) && (((State)s).getDoActivity() instanceof OpaqueBehavior))) {
            Behavior _doActivity = ((State)s).getDoActivity();
            this.actions.add(((OpaqueBehavior) _doActivity));
          }
          final Consumer<Region> _function_3 = new Consumer<Region>() {
            @Override
            public void accept(final Region it) {
              SM2ClassesTransformationCore.this.getAllActionsTransitionsStates(it);
            }
          };
          ((State)s).getRegions().forEach(_function_3);
        }
      }
    }
  }
  
  public List<Region> orthogonalRegions = new ArrayList<Region>();
  
  /**
   * create methods for regions
   */
  private void createRegionMethods() {
    for (int i = 0; (i < this.regions.size()); i++) {
      {
        this.createIntConstant(this.getRegionMacroName(this.regions.get(i)), i);
        this.createRegionMethod(this.regions.get(i));
        this.createRegionMethodExit(this.regions.get(i));
        if (((this.regions.get(i).getState() != null) && this.regions.get(i).getState().isOrthogonal())) {
          this.orthogonalRegions.add(this.regions.get(i));
        }
      }
    }
    for (int i = 0; (i < this.orthogonalRegions.size()); i++) {
      this.createIntConstant(this.getRegionMacroId(this.orthogonalRegions.get(i)), i);
    }
  }
  
  public String getRegionMacroId(final Region r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("REGION_ID_");
    String _upperCase = r.getState().getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = r.getName().toUpperCase();
    _builder.append(_upperCase_1);
    return _builder.toString();
  }
  
  public String getRegionMethodName(final Region r) {
    boolean _equals = Objects.equal(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _name = r.getStateMachine().getName();
      _builder.append(_name);
      _builder.append("_");
      String _name_1 = r.getName();
      _builder.append(_name_1);
      _builder.append("_Enter");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _name_2 = r.getState().getName();
    _builder_1.append(_name_2);
    _builder_1.append("_");
    String _name_3 = r.getName();
    _builder_1.append(_name_3);
    _builder_1.append("_Enter");
    return _builder_1.toString();
  }
  
  public String getRegionMacroName(final Region r) {
    boolean _equals = Objects.equal(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = r.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = r.getName().toUpperCase();
      _builder.append(_upperCase_1);
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_2 = r.getState().getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_");
    String _upperCase_3 = r.getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    return _builder_1.toString();
  }
  
  public String getVertexMacroName(final Vertex v) {
    Region _container = v.getContainer();
    boolean _equals = Objects.equal(_container, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = this.topRegion.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = v.getContainer().getName().toUpperCase();
      _builder.append(_upperCase_1);
      _builder.append("_");
      String _upperCase_2 = v.getName().toUpperCase();
      _builder.append(_upperCase_2);
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_3 = v.getContainer().getState().getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    _builder_1.append("_");
    String _upperCase_4 = v.getContainer().getName().toUpperCase();
    _builder_1.append(_upperCase_4);
    _builder_1.append("_");
    String _upperCase_5 = v.getName().toUpperCase();
    _builder_1.append(_upperCase_5);
    return _builder_1.toString();
  }
  
  public String getInitialMacroName(final Region r) {
    boolean _equals = Objects.equal(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = r.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = r.getName().toUpperCase();
      _builder.append(_upperCase_1);
      _builder.append("_DEFAULT");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_2 = r.getState().getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_");
    String _upperCase_3 = r.getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    _builder_1.append("_DEFAULT");
    return _builder_1.toString();
  }
  
  private ArrayList<Vertex> getSubVertexes(final State state) {
    final ArrayList<Vertex> ret = new ArrayList<Vertex>();
    final Consumer<Region> _function = new Consumer<Region>() {
      @Override
      public void accept(final Region it) {
        ret.addAll(it.getSubvertices());
      }
    };
    state.getRegions().forEach(_function);
    return ret;
  }
  
  private void createRegionMethod(final Region r) {
    ArrayList<Vertex> endVertexs = new ArrayList<Vertex>();
    Map<State, List<Vertex>> state2TransSubVertices = new HashMap<State, List<Vertex>>();
    EList<Vertex> _subvertices = r.getSubvertices();
    for (final Vertex v : _subvertices) {
      {
        final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
          @Override
          public Boolean apply(final Transition it) {
            return Boolean.valueOf(((!Objects.equal(it.getContainer(), v.getContainer())) || ((it.getSource() instanceof State) && SM2ClassesTransformationCore.this.getSubVertexes(((State) it.getSource())).contains(it.getTarget()))));
          }
        };
        final Iterable<Transition> incomings = IterableExtensions.<Transition>filter(v.getIncomings(), _function);
        final Function1<Transition, Vertex> _function_1 = new Function1<Transition, Vertex>() {
          @Override
          public Vertex apply(final Transition it) {
            return it.getSource();
          }
        };
        final Iterable<Vertex> sources = IterableExtensions.<Transition, Vertex>map(incomings, _function_1);
        int _size = IterableExtensions.size(sources);
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          boolean _contains = endVertexs.contains(v);
          boolean _not = (!_contains);
          if (_not) {
            endVertexs.add(v);
          }
        }
        if ((v instanceof State)) {
          final ArrayList<Vertex> subvertices = new ArrayList<Vertex>();
          final Consumer<Region> _function_2 = new Consumer<Region>() {
            @Override
            public void accept(final Region it) {
              subvertices.addAll(SM2ClassesTransformationCore.this.allSubVertexes(it));
            }
          };
          ((State)v).getRegions().forEach(_function_2);
          for (final Vertex subV : subvertices) {
            {
              final Function1<Transition, Vertex> _function_3 = new Function1<Transition, Vertex>() {
                @Override
                public Vertex apply(final Transition it) {
                  return it.getSource();
                }
              };
              List<Vertex> sourcesOfIncomings = ListExtensions.<Transition, Vertex>map(subV.getIncomings(), _function_3);
              final Function1<Vertex, Boolean> _function_4 = new Function1<Vertex, Boolean>() {
                @Override
                public Boolean apply(final Vertex it) {
                  boolean _contains = subvertices.contains(it);
                  return Boolean.valueOf((!_contains));
                }
              };
              Iterable<Vertex> sourcesOutSideOfR = IterableExtensions.<Vertex>filter(sourcesOfIncomings, _function_4);
              int _size_1 = IterableExtensions.size(sourcesOutSideOfR);
              boolean _greaterThan_1 = (_size_1 > 0);
              if (_greaterThan_1) {
                boolean _containsKey = state2TransSubVertices.containsKey(v);
                boolean _not_1 = (!_containsKey);
                if (_not_1) {
                  ArrayList<Vertex> _arrayList = new ArrayList<Vertex>();
                  state2TransSubVertices.put(((State)v), _arrayList);
                }
                state2TransSubVertices.get(v).add(subV);
              }
            }
          }
        }
      }
    }
    StringConcatenation _builder = new StringConcatenation();
    String switchBody = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String body = _builder_1.toString();
    StringConcatenation _builder_2 = new StringConcatenation();
    String macros = _builder_2.toString();
    Pseudostate _firstPseudoState = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
    boolean _tripleNotEquals = (_firstPseudoState != null);
    if (_tripleNotEquals) {
      Pseudostate initialP = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
      Vertex _target = IterableExtensions.<Transition>head(initialP.getOutgoings()).getTarget();
      State initialState = ((State) _target);
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
      _builder_3.append("[StateIDEnum.");
      String _upperCase = initialState.getName().toUpperCase();
      _builder_3.append(_upperCase);
      _builder_3.append("_ID.ordinal()]");
      String pAttr = _builder_3.toString();
      this.createIntConstant(this.getInitialMacroName(r), 0);
      String _body = body;
      StringConcatenation _builder_4 = new StringConcatenation();
      _builder_4.append("case ");
      String _initialMacroName = this.getInitialMacroName(r);
      _builder_4.append(_initialMacroName);
      _builder_4.append(":");
      _builder_4.newLineIfNotEmpty();
      _builder_4.append("\t");
      String _transitionEffect = TransformationUtil.getTransitionEffect(IterableExtensions.<Transition>head(initialP.getOutgoings()));
      _builder_4.append(_transitionEffect, "\t");
      _builder_4.newLineIfNotEmpty();
      _builder_4.append("\t");
      String _generateChangeState = this.generateChangeState(initialState);
      _builder_4.append(_generateChangeState, "\t");
      _builder_4.newLineIfNotEmpty();
      _builder_4.append("\t");
      _builder_4.newLine();
      {
        boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(initialState.getEntry());
        if (_isBehaviorExist) {
          _builder_4.append("\t");
          String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
          _builder_4.append(_fptrCall, "\t");
          _builder_4.append(";");
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("\t");
          _builder_4.append("// starting the counters for time events");
          _builder_4.newLine();
        }
      }
      _builder_4.append("\t");
      CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(initialState, "true");
      _builder_4.append(_generateActivateTimeEvent, "\t");
      _builder_4.newLineIfNotEmpty();
      _builder_4.append("\t");
      _builder_4.newLine();
      {
        if ((TransformationUtil.isBehaviorExist(initialState.getDoActivity()) || TransformationUtil.hasTriggerlessTransition(initialState))) {
          _builder_4.append("\t");
          _builder_4.append("// start activity of ");
          String _name = initialState.getName();
          _builder_4.append(_name, "\t");
          _builder_4.append(" by calling setFlag");
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("\t");
          _builder_4.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
          _builder_4.append("(StateIDEnum.");
          String _upperCase_1 = initialState.getName().toUpperCase();
          _builder_4.append(_upperCase_1, "\t");
          _builder_4.append("_ID.ordinal(), ");
          _builder_4.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
          _builder_4.append(", true);");
          _builder_4.newLineIfNotEmpty();
        }
      }
      {
        boolean _isComposite = initialState.isComposite();
        if (_isComposite) {
          {
            boolean _isOrthogonal = initialState.isOrthogonal();
            if (_isOrthogonal) {
              _builder_4.append("\t");
              _builder_4.append("//TODO: fork region funtions");
              _builder_4.newLine();
              {
                EList<Region> _regions = initialState.getRegions();
                for(final Region subRegion : _regions) {
                  _builder_4.append("\t");
                  _builder_4.append("//");
                  String _regionMethodName = this.getRegionMethodName(subRegion);
                  _builder_4.append(_regionMethodName, "\t");
                  _builder_4.append("(");
                  String _initialMacroName_1 = this.getInitialMacroName(subRegion);
                  _builder_4.append(_initialMacroName_1, "\t");
                  _builder_4.append(");");
                  _builder_4.newLineIfNotEmpty();
                  _builder_4.append("\t");
                  String _generateForkCall = this.concurrency.generateForkCall(subRegion, true, this.getInitialMacroName(subRegion));
                  _builder_4.append(_generateForkCall, "\t");
                  _builder_4.newLineIfNotEmpty();
                }
              }
              _builder_4.append("\t");
              _builder_4.append("//TODO: join region functions");
              _builder_4.newLine();
              {
                EList<Region> _regions_1 = initialState.getRegions();
                for(final Region subRegion_1 : _regions_1) {
                  _builder_4.append("\t");
                  _builder_4.append("//");
                  String _regionMethodName_1 = this.getRegionMethodName(subRegion_1);
                  _builder_4.append(_regionMethodName_1, "\t");
                  _builder_4.append("(");
                  String _initialMacroName_2 = this.getInitialMacroName(subRegion_1);
                  _builder_4.append(_initialMacroName_2, "\t");
                  _builder_4.append(");");
                  _builder_4.newLineIfNotEmpty();
                  _builder_4.append("\t");
                  String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, true);
                  _builder_4.append(_generateJoinCall, "\t");
                  _builder_4.newLineIfNotEmpty();
                }
              }
            } else {
              _builder_4.append("\t");
              String _regionMethodName_2 = this.getRegionMethodName(IterableExtensions.<Region>head(initialState.getRegions()));
              _builder_4.append(_regionMethodName_2, "\t");
              _builder_4.append("(");
              String _initialMacroName_3 = this.getInitialMacroName(IterableExtensions.<Region>head(initialState.getRegions()));
              _builder_4.append(_initialMacroName_3, "\t");
              _builder_4.append(");");
              _builder_4.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder_4.append("\t");
      _builder_4.append("//TODO: set systemState to EVENT_CONSUMED");
      _builder_4.newLine();
      _builder_4.append("\t");
      _builder_4.append("break;");
      body = (_body + _builder_4);
    }
    for (int i = 0; (i < endVertexs.size()); i++) {
      this.createIntConstant(this.getVertexMacroName(endVertexs.get(i)), (i + 1));
    }
    boolean _isApplied = StereotypeUtil.isApplied(this.superContext, Import.class);
    boolean _not = (!_isApplied);
    if (_not) {
      StereotypeUtil.apply(this.superContext, Import.class);
    }
    Operation regionMethod = this.superContext.createOwnedOperation(this.getRegionMethodName(r), null, null);
    regionMethod.createOwnedParameter(SMCodeGeneratorConstants.ENTER_MODE_PARAM, this.intType);
    for (final Vertex v_1 : endVertexs) {
      if ((v_1 instanceof State)) {
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
        _builder_5.append("[StateIDEnum.");
        String _upperCase_2 = ((State)v_1).getName().toUpperCase();
        _builder_5.append(_upperCase_2);
        _builder_5.append("_ID.ordinal()]");
        String pAttr_1 = _builder_5.toString();
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append(body);
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("case ");
        String _vertexMacroName = this.getVertexMacroName(v_1);
        _builder_6.append(_vertexMacroName);
        _builder_6.append(":");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        String _generateChangeState_1 = this.generateChangeState(((State)v_1));
        _builder_6.append(_generateChangeState_1, "\t");
        _builder_6.newLineIfNotEmpty();
        {
          boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(((State)v_1).getEntry());
          if (_isBehaviorExist_1) {
            _builder_6.append("\t");
            String _fptrCall_1 = this.getFptrCall(pAttr_1, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_6.append(_fptrCall_1, "\t");
            _builder_6.append(";");
            _builder_6.newLineIfNotEmpty();
          }
        }
        _builder_6.append("\t");
        _builder_6.append("//starting the counters for time events");
        _builder_6.newLine();
        _builder_6.append("\t");
        CharSequence _generateActivateTimeEvent_1 = this.generateActivateTimeEvent(((State)v_1), "true");
        _builder_6.append(_generateActivateTimeEvent_1, "\t");
        _builder_6.newLineIfNotEmpty();
        {
          if ((TransformationUtil.isBehaviorExist(((State)v_1).getDoActivity()) || TransformationUtil.hasTriggerlessTransition(((State)v_1)))) {
            _builder_6.append("\t");
            _builder_6.append("// start activity of ");
            String _name_1 = ((State)v_1).getName();
            _builder_6.append(_name_1, "\t");
            _builder_6.append(" by calling setFlag");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
            _builder_6.append("(StateIDEnum.");
            String _upperCase_3 = ((State)v_1).getName().toUpperCase();
            _builder_6.append(_upperCase_3, "\t");
            _builder_6.append("_ID.ordinal(), ");
            _builder_6.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
            _builder_6.append(", true);");
            _builder_6.newLineIfNotEmpty();
          }
        }
        {
          boolean _isComposite_1 = ((State)v_1).isComposite();
          if (_isComposite_1) {
            {
              boolean _isOrthogonal_1 = ((State)v_1).isOrthogonal();
              if (_isOrthogonal_1) {
                _builder_6.append("\t");
                _builder_6.append("//TODO: fork region funtions");
                _builder_6.newLine();
                {
                  EList<Region> _regions_2 = ((State)v_1).getRegions();
                  for(final Region subRegion_2 : _regions_2) {
                    _builder_6.append("\t");
                    _builder_6.append("//");
                    String _regionMethodName_3 = this.getRegionMethodName(subRegion_2);
                    _builder_6.append(_regionMethodName_3, "\t");
                    _builder_6.append("(");
                    String _initialMacroName_4 = this.getInitialMacroName(subRegion_2);
                    _builder_6.append(_initialMacroName_4, "\t");
                    _builder_6.append(");");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t");
                    String _generateForkCall_1 = this.concurrency.generateForkCall(subRegion_2, true, this.getInitialMacroName(subRegion_2));
                    _builder_6.append(_generateForkCall_1, "\t");
                    _builder_6.newLineIfNotEmpty();
                  }
                }
                _builder_6.append("\t");
                _builder_6.append("//TODO: join region functions");
                _builder_6.newLine();
                {
                  EList<Region> _regions_3 = ((State)v_1).getRegions();
                  for(final Region subRegion_3 : _regions_3) {
                    _builder_6.append("\t");
                    _builder_6.append("//");
                    String _regionMethodName_4 = this.getRegionMethodName(subRegion_3);
                    _builder_6.append(_regionMethodName_4, "\t");
                    _builder_6.append("(");
                    String _initialMacroName_5 = this.getInitialMacroName(subRegion_3);
                    _builder_6.append(_initialMacroName_5, "\t");
                    _builder_6.append(");");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t");
                    String _generateJoinCall_1 = this.concurrency.generateJoinCall(subRegion_3, true);
                    _builder_6.append(_generateJoinCall_1, "\t");
                    _builder_6.newLineIfNotEmpty();
                  }
                }
              } else {
                _builder_6.append("\t");
                String _regionMethodName_5 = this.getRegionMethodName(IterableExtensions.<Region>head(((State)v_1).getRegions()));
                _builder_6.append(_regionMethodName_5, "\t");
                _builder_6.append("(");
                String _initialMacroName_6 = this.getInitialMacroName(IterableExtensions.<Region>head(((State)v_1).getRegions()));
                _builder_6.append(_initialMacroName_6, "\t");
                _builder_6.append(");");
                _builder_6.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder_6.append("\t");
        _builder_6.append("//TODO: set systemState to EVENT_CONSUMED");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("break;");
        body = _builder_6.toString();
      } else {
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append(body);
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("case ");
        String _vertexMacroName_1 = this.getVertexMacroName(v_1);
        _builder_7.append(_vertexMacroName_1);
        _builder_7.append(": ");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        String _generatePseudo = this.pseudostateGenerator.generatePseudo(((Pseudostate) v_1));
        _builder_7.append(_generatePseudo, "\t");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("//TODO: set systemState to EVENT_CONSUMED");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("break;");
        body = _builder_7.toString();
      }
    }
    boolean _notEquals = (!Objects.equal(r, this.topRegion));
    if (_notEquals) {
      Set<Map.Entry<State, List<Vertex>>> _entrySet = state2TransSubVertices.entrySet();
      for (final Map.Entry<State, List<Vertex>> e : _entrySet) {
        {
          State state = e.getKey();
          List<Vertex> _value = e.getValue();
          for (final Vertex transitiveSubVertex : _value) {
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append(body);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("case ");
            String _vertexMacroName_2 = this.getVertexMacroName(transitiveSubVertex);
            _builder_8.append(_vertexMacroName_2);
            _builder_8.append(":");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("\t");
            String _generateEnteringOnSubVertex = this.generateEnteringOnSubVertex(state, transitiveSubVertex);
            _builder_8.append(_generateEnteringOnSubVertex, "\t");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("\t");
            _builder_8.append("break;");
            body = _builder_8.toString();
          }
        }
      }
    }
    StringConcatenation _builder_8 = new StringConcatenation();
    _builder_8.append("switch(");
    _builder_8.append(SMCodeGeneratorConstants.ENTER_MODE_PARAM);
    _builder_8.append(") {");
    _builder_8.newLineIfNotEmpty();
    _builder_8.append("\t");
    _builder_8.append(body, "\t");
    _builder_8.newLineIfNotEmpty();
    _builder_8.append("}");
    _builder_8.newLine();
    switchBody = _builder_8.toString();
    this.createOpaqueBehavior(this.superContext, regionMethod, switchBody);
  }
  
  public String generateEnteringOnSubVertex(final State parent, final Vertex subVertex) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID.ordinal()]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    {
      boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(parent.getEntry());
      if (_isBehaviorExist) {
        String _fptrCall = this.getFptrCall(pAttr, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
      }
    }
    _builder_1.append("//starting the counters for time events");
    _builder_1.newLine();
    CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "true");
    _builder_1.append(_generateActivateTimeEvent);
    _builder_1.newLineIfNotEmpty();
    {
      if ((TransformationUtil.isBehaviorExist(parent.getDoActivity()) || TransformationUtil.hasTriggerlessTransition(parent))) {
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      if ((parent.isComposite() && (!Objects.equal(parent, subVertex)))) {
        {
          boolean _isOrthogonal = parent.isOrthogonal();
          if (_isOrthogonal) {
            ArrayList<Region> toJoinList = new ArrayList<Region>();
            _builder_1.newLineIfNotEmpty();
            {
              EList<Region> _regions = parent.getRegions();
              for(final Region r : _regions) {
                {
                  if ((subVertex != null)) {
                    {
                      Region _container = subVertex.getContainer();
                      boolean _equals = Objects.equal(_container, r);
                      if (_equals) {
                        boolean _add = toJoinList.add(r);
                        _builder_1.append(_add);
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("//");
                        String _regionMethodName = this.getRegionMethodName(r);
                        _builder_1.append(_regionMethodName);
                        _builder_1.append("(");
                        String _vertexMacroName = this.getVertexMacroName(subVertex);
                        _builder_1.append(_vertexMacroName);
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                        String _generateForkCall = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                        _builder_1.append(_generateForkCall);
                        _builder_1.newLineIfNotEmpty();
                      } else {
                        boolean _contains = this.allSubVertexes(r).contains(subVertex);
                        if (_contains) {
                          boolean _add_1 = toJoinList.add(r);
                          _builder_1.append(_add_1);
                          _builder_1.newLineIfNotEmpty();
                          _builder_1.append("//");
                          String _regionMethodName_1 = this.getRegionMethodName(r);
                          _builder_1.append(_regionMethodName_1);
                          _builder_1.append("(");
                          String _vertexMacroName_1 = this.getVertexMacroName(subVertex);
                          _builder_1.append(_vertexMacroName_1);
                          _builder_1.append(");");
                          _builder_1.newLineIfNotEmpty();
                          String _generateForkCall_1 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder_1.append(_generateForkCall_1);
                          _builder_1.newLineIfNotEmpty();
                        } else {
                          State _findInitialState = TransformationUtil.findInitialState(r);
                          boolean _tripleNotEquals = (_findInitialState != null);
                          if (_tripleNotEquals) {
                            boolean _add_2 = toJoinList.add(r);
                            _builder_1.append(_add_2);
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append("//");
                            String _regionMethodName_2 = this.getRegionMethodName(r);
                            _builder_1.append(_regionMethodName_2);
                            _builder_1.append("(");
                            String _initialMacroName = this.getInitialMacroName(r);
                            _builder_1.append(_initialMacroName);
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                            String _generateForkCall_2 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                            _builder_1.append(_generateForkCall_2);
                            _builder_1.newLineIfNotEmpty();
                          }
                        }
                      }
                    }
                  } else {
                    if (((subVertex != null) && (subVertex.getContainer() == null))) {
                      {
                        EObject _eContainer = subVertex.eContainer();
                        boolean _equals_1 = Objects.equal(_eContainer, parent);
                        if (_equals_1) {
                          boolean _add_3 = toJoinList.add(r);
                          _builder_1.append(_add_3);
                          _builder_1.newLineIfNotEmpty();
                          String _generateForkCall_3 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder_1.append(_generateForkCall_3);
                          _builder_1.newLineIfNotEmpty();
                        } else {
                          boolean _add_4 = toJoinList.add(r);
                          _builder_1.append(_add_4);
                          _builder_1.newLineIfNotEmpty();
                          String _generateForkCall_4 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder_1.append(_generateForkCall_4);
                          _builder_1.newLineIfNotEmpty();
                        }
                      }
                    } else {
                      {
                        State _findInitialState_1 = TransformationUtil.findInitialState(r);
                        boolean _tripleNotEquals_1 = (_findInitialState_1 != null);
                        if (_tripleNotEquals_1) {
                          boolean _add_5 = toJoinList.add(r);
                          _builder_1.append(_add_5);
                          _builder_1.newLineIfNotEmpty();
                          _builder_1.append("//");
                          String _regionMethodName_3 = this.getRegionMethodName(r);
                          _builder_1.append(_regionMethodName_3);
                          _builder_1.append("(");
                          String _initialMacroName_1 = this.getInitialMacroName(r);
                          _builder_1.append(_initialMacroName_1);
                          _builder_1.append(");");
                          _builder_1.newLineIfNotEmpty();
                          String _generateForkCall_5 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                          _builder_1.append(_generateForkCall_5);
                          _builder_1.newLineIfNotEmpty();
                        }
                      }
                    }
                  }
                }
              }
            }
            {
              for(final Region r_1 : toJoinList) {
                String _generateJoinCall = this.concurrency.generateJoinCall(r_1, true);
                _builder_1.append(_generateJoinCall);
                _builder_1.newLineIfNotEmpty();
              }
            }
          } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
              {
                if ((subVertex != null)) {
                  {
                    if (((subVertex.getContainer() == null) && (subVertex.eContainer() instanceof State))) {
                      String _regionMethodName_4 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                      _builder_1.append(_regionMethodName_4);
                      _builder_1.append("(");
                      String _vertexMacroName_2 = this.getVertexMacroName(subVertex);
                      _builder_1.append(_vertexMacroName_2);
                      _builder_1.append(");");
                      _builder_1.newLineIfNotEmpty();
                    } else {
                      State _state = subVertex.getContainer().getState();
                      boolean _equals_2 = Objects.equal(_state, parent);
                      if (_equals_2) {
                        String _regionMethodName_5 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                        _builder_1.append(_regionMethodName_5);
                        _builder_1.append("(");
                        String _vertexMacroName_3 = this.getVertexMacroName(subVertex);
                        _builder_1.append(_vertexMacroName_3);
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                      } else {
                        final Function1<Region, Boolean> _function = new Function1<Region, Boolean>() {
                          @Override
                          public Boolean apply(final Region it) {
                            return Boolean.valueOf(SM2ClassesTransformationCore.this.allSubVertexes(it).contains(subVertex));
                          }
                        };
                        Region containingRegion = IterableExtensions.<Region>head(IterableExtensions.<Region>filter(parent.getRegions(), _function));
                        _builder_1.newLineIfNotEmpty();
                        String _regionMethodName_6 = this.getRegionMethodName(containingRegion);
                        _builder_1.append(_regionMethodName_6);
                        _builder_1.append("(");
                        String _vertexMacroName_4 = this.getVertexMacroName(subVertex);
                        _builder_1.append(_vertexMacroName_4);
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                      }
                    }
                  }
                } else {
                  String _regionMethodName_7 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder_1.append(_regionMethodName_7);
                  _builder_1.append("(");
                  String _initialMacroName_2 = this.getInitialMacroName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder_1.append(_initialMacroName_2);
                  _builder_1.append(");");
                  _builder_1.newLineIfNotEmpty();
                }
              }
            } else {
            }
          }
        }
      } else {
        if ((parent.isComposite() && Objects.equal(parent, subVertex))) {
          {
            boolean _isOrthogonal_1 = parent.isOrthogonal();
            if (_isOrthogonal_1) {
              ArrayList<Region> toJoinList_1 = new ArrayList<Region>();
              _builder_1.newLineIfNotEmpty();
              {
                EList<Region> _regions_1 = parent.getRegions();
                for(final Region r_2 : _regions_1) {
                  {
                    State _findInitialState_2 = TransformationUtil.findInitialState(r_2);
                    boolean _tripleNotEquals_2 = (_findInitialState_2 != null);
                    if (_tripleNotEquals_2) {
                      boolean _add_6 = toJoinList_1.add(r_2);
                      _builder_1.append(_add_6);
                      _builder_1.newLineIfNotEmpty();
                      _builder_1.append("//");
                      String _regionMethodName_8 = this.getRegionMethodName(r_2);
                      _builder_1.append(_regionMethodName_8);
                      _builder_1.append("(");
                      String _initialMacroName_3 = this.getInitialMacroName(r_2);
                      _builder_1.append(_initialMacroName_3);
                      _builder_1.append(");");
                      _builder_1.newLineIfNotEmpty();
                      String _generateForkCall_6 = this.concurrency.generateForkCall(r_2, true, this.getInitialMacroName(r_2));
                      _builder_1.append(_generateForkCall_6);
                      _builder_1.newLineIfNotEmpty();
                    }
                  }
                }
              }
              {
                for(final Region r_3 : toJoinList_1) {
                  String _generateJoinCall_1 = this.concurrency.generateJoinCall(r_3, true);
                  _builder_1.append(_generateJoinCall_1);
                  _builder_1.newLineIfNotEmpty();
                }
              }
            } else {
              {
                State _findInitialState_3 = TransformationUtil.findInitialState(IterableExtensions.<Region>head(parent.getRegions()));
                boolean _tripleNotEquals_3 = (_findInitialState_3 != null);
                if (_tripleNotEquals_3) {
                  String _regionMethodName_9 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder_1.append(_regionMethodName_9);
                  _builder_1.append("(");
                  String _initialMacroName_4 = this.getInitialMacroName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder_1.append(_initialMacroName_4);
                  _builder_1.append(");");
                  _builder_1.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder_1.append("\t\t");
        }
      }
    }
    return _builder_1.toString();
  }
  
  private void createRegionMethodExit(final Region r) {
    if (((r.getState() == null) || (!r.getState().isComposite()))) {
      return;
    }
    State parent = r.getState();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//exiting region ");
    String _name = r.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    int regionIndex = r.getState().getRegions().indexOf(r);
    _builder.newLineIfNotEmpty();
    {
      final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
        @Override
        public Boolean apply(final State it) {
          return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
        }
      };
      Iterable<State> _filter = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function);
      boolean _hasElements = false;
      for(final State s : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" else ", "");
        }
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
        _builder.append("[");
        _builder.append(regionIndex);
        _builder.append("] == ");
        String _upperCase_1 = s.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_ID) {");
        _builder.newLineIfNotEmpty();
        {
          boolean _isOrthogonal = s.isOrthogonal();
          if (_isOrthogonal) {
            {
              EList<Region> _regions = s.getRegions();
              for(final Region subRegion : _regions) {
                _builder.append("\t");
                String _generateForkCall = this.concurrency.generateForkCall(subRegion, false, "0");
                _builder.append(_generateForkCall, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              EList<Region> _regions_1 = s.getRegions();
              for(final Region subRegion_1 : _regions_1) {
                _builder.append("\t");
                String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, false);
                _builder.append(_generateJoinCall, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            _builder.append("\t");
            String _regionMethodExitName = this.getRegionMethodExitName(IterableExtensions.<Region>head(s.getRegions()));
            _builder.append(_regionMethodExitName, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("if (");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[StateIDEnum.");
    String _upperCase_2 = parent.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_ID.ordinal()].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
    _builder.append("[");
    _builder.append(regionIndex);
    _builder.append("] != ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("//signal to exit the doActivity of sub-state of ");
    String _name_1 = parent.getName();
    _builder.append(_name_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
    _builder.append("(");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[StateIDEnum.");
    String _upperCase_3 = parent.getName().toUpperCase();
    _builder.append(_upperCase_3, "\t");
    _builder.append("_ID.ordinal()].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[0], ");
    _builder.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    {
      Iterable<State> _filter_1 = Iterables.<State>filter(r.getSubvertices(), State.class);
      boolean _hasElements_1 = false;
      for(final State sub : _filter_1) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate(" else ", "\t");
        }
        {
          List<TimeEvent> _get = this.states2TimeEvents.get(sub);
          boolean _tripleNotEquals = (_get != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_4 = sub.getName().toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == ");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder.append("[StateIDEnum.");
            String _upperCase_5 = parent.getName().toUpperCase();
            _builder.append(_upperCase_5, "\t");
            _builder.append("_ID.ordinal()].");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
            _builder.append("[");
            _builder.append(regionIndex, "\t");
            _builder.append("]) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(sub, "false");
            _builder.append(_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("//exit action of sub-state of ");
    String _name_2 = parent.getName();
    _builder.append(_name_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("(this->*");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[StateIDEnum.");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[");
    String _upperCase_6 = parent.getName().toUpperCase();
    _builder.append(_upperCase_6, "\t");
    _builder.append("_ID.ordinal()].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[0]].");
    _builder.append(SMCodeGeneratorConstants.EXIT_NAME, "\t");
    _builder.append(")();");
    _builder.newLineIfNotEmpty();
    {
      boolean _isSavehistory = TransformationUtil.isSavehistory(this.topRegion, r);
      if (_isSavehistory) {
        _builder.append("\t");
        _builder.append("//save history region ");
        String _name_3 = r.getName();
        _builder.append(_name_3, "\t");
        _builder.append(" of state ");
        String _name_4 = parent.getName();
        _builder.append(_name_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[StateIDEnum.");
        String _upperCase_7 = parent.getName().toUpperCase();
        _builder.append(_upperCase_7, "\t");
        _builder.append("_ID.ordinal()].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
        _builder.append("[");
        _builder.append(regionIndex, "\t");
        _builder.append("] = ");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[StateIDEnum.");
        String _upperCase_8 = parent.getName().toUpperCase();
        _builder.append(_upperCase_8, "\t");
        _builder.append("_ID.ordinal()].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[");
        _builder.append(regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("//set active sub-state of ");
    String _name_5 = parent.getName();
    _builder.append(_name_5, "\t");
    _builder.append(" to ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
    _builder.append(" meaning NULL");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[StateIDEnum.");
    String _upperCase_9 = parent.getName().toUpperCase();
    _builder.append(_upperCase_9, "\t");
    _builder.append("_ID.ordinal()].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[");
    _builder.append(regionIndex, "\t");
    _builder.append("] = ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    String body = _builder.toString();
    Operation exitOp = this.superContext.createOwnedOperation(this.getRegionMethodExitName(r), null, null);
    this.createOpaqueBehavior(this.superContext, exitOp, body);
  }
  
  private String getRegionMethodExitName(final Region r) {
    boolean _equals = Objects.equal(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _name = r.getStateMachine().getName();
      _builder.append(_name);
      _builder.append("_");
      String _name_1 = r.getName();
      _builder.append(_name_1);
      _builder.append("_Exit");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _name_2 = r.getState().getName();
    _builder_1.append(_name_2);
    _builder_1.append("_");
    String _name_3 = r.getName();
    _builder_1.append(_name_3);
    _builder_1.append("_Exit");
    return _builder_1.toString();
  }
  
  public List<Vertex> allSubVertexes(final Region r) {
    final ArrayList<Vertex> ret = new ArrayList<Vertex>();
    ret.addAll(r.getSubvertices());
    final Consumer<State> _function = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        final Consumer<Region> _function = new Consumer<Region>() {
          @Override
          public void accept(final Region it) {
            ret.addAll(SM2ClassesTransformationCore.this.allSubVertexes(it));
          }
        };
        it.getRegions().forEach(_function);
      }
    };
    Iterables.<State>filter(r.getSubvertices(), State.class).forEach(_function);
    return ret;
  }
  
  private OpaqueBehavior createOpaqueBehavior(final org.eclipse.uml2.uml.Class container, final Operation op) {
    OpaqueBehavior opaque = IterableExtensions.<OpaqueBehavior>head(Iterables.<OpaqueBehavior>filter(op.getMethods(), OpaqueBehavior.class));
    if ((opaque == null)) {
      Behavior _createClassifierBehavior = container.createClassifierBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
      opaque = ((OpaqueBehavior) _createClassifierBehavior);
      op.getMethods().add(opaque);
      opaque.getLanguages().add(this.langID);
    }
    return opaque;
  }
  
  public OpaqueBehavior createOpaqueBehavior(final org.eclipse.uml2.uml.Class container, final Operation op, final String body) {
    OpaqueBehavior opaque = this.createOpaqueBehavior(container, op);
    int _size = opaque.getBodies().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      opaque.getBodies().set(0, body);
    } else {
      opaque.getLanguages().add(this.langID);
      opaque.getBodies().add(body);
    }
    return opaque;
  }
  
  public Operation createDerivedOperation(final org.eclipse.uml2.uml.Class clz, final Operation source) {
    Operation _xblockexpression = null;
    {
      String name = source.getName();
      Operation derivedOp = clz.createOwnedOperation(name, null, null);
      derivedOp.setName(name);
      StereotypeUtil.apply(derivedOp, DerivedElement.class);
      DerivedElement _stereotypeApplication = UMLUtil.<DerivedElement>getStereotypeApplication(derivedOp, DerivedElement.class);
      _stereotypeApplication.setSource(source);
      this.setVirtual(derivedOp);
      _xblockexpression = derivedOp;
    }
    return _xblockexpression;
  }
  
  public void copyParameters(final Operation source, final Operation target, final boolean isCopyReturn) {
    String name = target.getName();
    if ((!isCopyReturn)) {
      final Function1<Parameter, Boolean> _function = new Function1<Parameter, Boolean>() {
        @Override
        public Boolean apply(final Parameter it) {
          ParameterDirectionKind _direction = it.getDirection();
          return Boolean.valueOf(Objects.equal(_direction, ParameterDirectionKind.RETURN_LITERAL));
        }
      };
      Iterable<Parameter> ret = IterableExtensions.<Parameter>filter(target.getOwnedParameters(), _function);
      CollectionExtensions.<Parameter>removeAll(target.getOwnedParameters(), ret);
    }
    EList<EObject> _stereotypeApplications = target.getStereotypeApplications();
    for (final EObject stt : _stereotypeApplications) {
      StereotypeUtil.apply(target, stt.getClass());
    }
    target.setName(name);
  }
  
  private Object setVirtual(final Operation op) {
    return null;
  }
  
  public String getGuard(final Transition t) {
    ValueSpecification _specification = t.getGuard().getSpecification();
    return IterableExtensions.<String>head(((OpaqueExpression) _specification).getBodies());
  }
}
