/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadLibrariesRequest
extends RequestWithConfirmation<Integer> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadLibrariesRequest.class);
    private Collection<String> libraryNames;
    private File cacheFolder;

    public LoadLibrariesRequest(CDOClientProtocol protocol, Collection<String> libraryNames, File cacheFolder) {
        super((SignalProtocol)protocol, (short)3);
        this.libraryNames = libraryNames;
        this.cacheFolder = cacheFolder;
    }

    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        int size = this.libraryNames.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} library names", new Object[]{size});
        }
        out.writeInt(size);
        for (String libraryName : this.libraryNames) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing library name: {0}", new Object[]{libraryName});
            }
            out.writeString(libraryName);
        }
    }

    protected Integer confirming(ExtendedDataInputStream in) throws Exception {
        byte[] buffer = new byte[8192];
        int count = 0;
        for (String libraryName : this.libraryNames) {
            int size = in.readInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Reading library {0}: {1} bytes", new Object[]{libraryName, size});
            }
            File file = new File(this.cacheFolder, libraryName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                IOUtil.copy((InputStream)in, (OutputStream)out, (int)size, (byte[])buffer);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close((Closeable)out);
            ++count;
        }
        return count;
    }
}

