/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.emf.exporter.html.HTMLExporterPlugin;
import org.eclipse.emf.exporter.html.PackageHTML;

public class HTMLExporter
extends ModelExporter {
    private ModelExporter.ExportData exportData;
    private Map<EPackage, GenPackage> ePackageToGenPackage;
    private GenPackage currentGenPackage;
    private URI currentArtifactURI;

    public String getID() {
        return "org.eclipse.emf.exporter.html";
    }

    protected String getDefaultArtifactLocation(EPackage ePackage) {
        return String.valueOf(this.getDefaultArtifactFileName(ePackage)) + ".html";
    }

    protected String doCheckEPackageArtifactLocation(String location, String packageName) {
        if (!location.endsWith(".html")) {
            return HTMLExporterPlugin.INSTANCE.getString("_UI_InvalidArtifactFileNameExtension_message");
        }
        return super.doCheckEPackageArtifactLocation(location, packageName);
    }

    protected Diagnostic doExport(Monitor monitor, ModelExporter.ExportData exportData) throws Exception {
        this.exportData = exportData;
        ArrayList entries = new ArrayList(exportData.genPackageToArtifactURI.keySet());
        entries.addAll(exportData.referencedGenPackagesToArtifactURI.keySet());
        this.ePackageToGenPackage = new HashMap<EPackage, GenPackage>();
        for (GenPackage genPackage : entries) {
            this.ePackageToGenPackage.put(genPackage.getEcorePackage(), genPackage);
        }
        for (Map.Entry entry : exportData.genPackageToArtifactURI.entrySet()) {
            this.currentGenPackage = (GenPackage)entry.getKey();
            this.currentArtifactURI = (URI)entry.getValue();
            String content = new PackageHTML().generate((Object)this);
            this.save(content);
        }
        return Diagnostic.OK_INSTANCE;
    }

    public GenPackage getCurrentGenPackage() {
        return this.currentGenPackage;
    }

    public URI getPackageArtifacttURI(EPackage ePackage) {
        GenPackage eClassifierGenPackage = this.ePackageToGenPackage.get(ePackage);
        if (eClassifierGenPackage != null) {
            URI artifactURI = (URI)this.exportData.genPackageToArtifactURI.get(eClassifierGenPackage);
            if (artifactURI == null) {
                artifactURI = (URI)this.exportData.referencedGenPackagesToArtifactURI.get(eClassifierGenPackage);
            }
            if (artifactURI != null) {
                return artifactURI.deresolve(this.currentArtifactURI);
            }
        }
        return null;
    }

    public String computeClassifierLabel(EClassifier classifier) {
        StringBuilder label = new StringBuilder();
        label.append("<a name=\"");
        label.append(classifier.getName());
        label.append("\">");
        label.append(classifier.getName());
        label.append("</a>");
        if (!classifier.getETypeParameters().isEmpty()) {
            label.append("&lt;");
            Iterator i = classifier.getETypeParameters().iterator();
            while (i.hasNext()) {
                ETypeParameter typeParameter = (ETypeParameter)i.next();
                label.append(this.computeTypeParameterLabel(typeParameter));
                if (!i.hasNext()) continue;
                label.append(", ");
            }
            label.append("&gt;");
        }
        return label.toString();
    }

    protected String computeTypeParameterLabel(ETypeParameter typeParameter) {
        StringBuilder label = new StringBuilder();
        String name = typeParameter.getName();
        EObject container = typeParameter.eContainer();
        if (container instanceof EClassifier) {
            EClassifier classifier = (EClassifier)container;
            label.append("<a name=\"");
            label.append(classifier.getName());
            label.append("@@");
            label.append(name);
            label.append("\">");
            label.append(name);
            label.append("</a>");
        } else {
            label.append(name);
        }
        if (!typeParameter.getEBounds().isEmpty()) {
            label.append(" extends ");
            Iterator j = typeParameter.getEBounds().iterator();
            while (j.hasNext()) {
                EGenericType bound = (EGenericType)j.next();
                label.append(this.computeLabel(bound));
                if (!j.hasNext()) continue;
                label.append(" &amp; ");
            }
        }
        return label.toString();
    }

    public String computeLabel(EClassifier classifier) {
        String classifierType;
        String name = classifier.getName().trim();
        EPackage eClassifierEPackage = classifier.getEPackage();
        String string = classifier instanceof EClass ? "Class" : (classifierType = classifier instanceof EEnum ? "Enumeration" : "DataType");
        if (this.getCurrentGenPackage().getEcorePackage() == eClassifierEPackage || this.getCurrentGenPackage().getEcorePackage().getNsURI().equals(eClassifierEPackage.getNsURI())) {
            return new StringBuffer().append("<a href=\"#").append(name).append("\"").append(" title=\"").append(classifierType).append(":").append(name).append("\">").append(name).append("</a>").toString();
        }
        URI packageArtifactURI = this.getPackageArtifacttURI(eClassifierEPackage);
        if (packageArtifactURI != null) {
            return new StringBuffer().append("<a href=\"").append(packageArtifactURI.toString()).append("#").append(name).append("\"").append(" title=\"").append(classifierType).append(":").append(name).append("\">").append(name).append("</a>").toString();
        }
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(eClassifierEPackage.getNsURI())) {
            return new StringBuffer().append("<i><b>").append(name).append("</b></i>").toString();
        }
        return name;
    }

    protected String computeLabel(ENamedElement namedElement) {
        boolean addedHyperlink = false;
        StringBuilder label = new StringBuilder();
        String titleType = namedElement.eClass().getName().substring(1);
        String name = namedElement.getName();
        EObject container = namedElement.eContainer();
        if (container instanceof EClassifier) {
            int currentPos;
            String classifierLabel = this.computeLabel((EClassifier)container);
            int index = classifierLabel.indexOf("href=\"");
            if (index > 0) {
                index = classifierLabel.indexOf(34, index + "href=\"".length());
                label.append(classifierLabel.substring(0, index));
                if (namedElement instanceof ETypeParameter) {
                    label.append("@@");
                } else {
                    label.append("@");
                }
                label.append(name);
            }
            if ((index = classifierLabel.indexOf("title=\"", currentPos = index)) > 0) {
                label.append(classifierLabel.substring(currentPos, index += "title=\"".length()));
                label.append(titleType).append(":").append(name);
                currentPos = classifierLabel.indexOf(34, index + 1);
            }
            if ((index = classifierLabel.indexOf(62, currentPos)) > 0) {
                addedHyperlink = true;
                label.append(classifierLabel.substring(currentPos, ++index));
            }
        }
        label.append(name);
        if (addedHyperlink) {
            label.append("</a>");
        }
        return label.toString();
    }

    protected String computeLabel(EGenericType genericType) {
        EObject container = genericType.eContainer();
        if (container == null || !container.eIsSet(genericType.eContainingFeature())) {
            return this.computeLabel(genericType.getERawType());
        }
        StringBuilder label = new StringBuilder();
        if (genericType.getEClassifier() != null) {
            label.append(this.computeLabel(genericType.getERawType()));
            if (!genericType.getETypeArguments().isEmpty()) {
                label.append("&lt;");
                Iterator i = genericType.getETypeArguments().iterator();
                while (i.hasNext()) {
                    EGenericType typeArgument = (EGenericType)i.next();
                    label.append(this.computeLabel(typeArgument));
                    if (!i.hasNext()) continue;
                    label.append(", ");
                }
                label.append("&gt;");
            }
        } else {
            ETypeParameter typeParameter = genericType.getETypeParameter();
            String name = typeParameter != null ? this.computeLabel((ENamedElement)typeParameter) : "?";
            label.append(name);
            if (genericType.getELowerBound() != null) {
                label.append(" super ");
                label.append(this.computeLabel(genericType.getELowerBound()));
            } else if (genericType.getEUpperBound() != null) {
                label.append(" extends ");
                label.append(this.computeLabel(genericType.getEUpperBound()));
            }
        }
        return label.toString();
    }

    protected String computeLabel(ETypedElement typedElement) {
        StringBuilder label = new StringBuilder();
        EGenericType genericType = typedElement.getEGenericType();
        if (genericType != null) {
            label.append(this.computeLabel(genericType));
            if (typedElement.isMany()) {
                label.append("*");
            }
            label.append(" ");
        }
        String name = typedElement.getName();
        EObject container = typedElement.eContainer();
        if (container instanceof EClassifier) {
            EClassifier classifier = (EClassifier)container;
            label.append("<a name=\"");
            label.append(classifier.getName());
            label.append("@");
            label.append(name);
            label.append("\">");
            label.append(name);
            label.append("</a>");
        } else {
            label.append(name);
        }
        return label.toString();
    }

    protected String computeLabel(EStructuralFeature feature) {
        StringBuilder label = new StringBuilder(this.computeLabel((ETypedElement)feature));
        if (feature.isDerived()) {
            label.append(" /");
        }
        return label.toString();
    }

    public String computeLabel(EReference reference) {
        StringBuilder label = new StringBuilder(this.computeLabel((EStructuralFeature)reference));
        if (!reference.getEKeys().isEmpty()) {
            label.append("<ul><li>key(s): ");
            Iterator i = reference.getEKeys().iterator();
            while (i.hasNext()) {
                EAttribute attribute = (EAttribute)i.next();
                label.append(this.computeLabel((ENamedElement)attribute));
                if (!i.hasNext()) continue;
                label.append(", ");
            }
            label.append("</li></ul>");
        }
        return label.toString();
    }

    public String computeLabel(EOperation operation) {
        Iterator i;
        StringBuilder label = new StringBuilder();
        if (!operation.getETypeParameters().isEmpty()) {
            label.append("&lt;");
            i = operation.getETypeParameters().iterator();
            while (i.hasNext()) {
                ETypeParameter typeParameter = (ETypeParameter)i.next();
                label.append(this.computeTypeParameterLabel(typeParameter));
                if (!i.hasNext()) continue;
                label.append(", ");
            }
            label.append("&gt; ");
        }
        if (operation.getEGenericType() == null) {
            label.append("void ");
        }
        label.append(this.computeLabel((ETypedElement)operation));
        if (!operation.getEParameters().isEmpty()) {
            label.append("(");
            i = operation.getEParameters().iterator();
            while (i.hasNext()) {
                EParameter parameter = (EParameter)i.next();
                label.append(this.computeLabel((ETypedElement)parameter));
                if (!i.hasNext()) continue;
                label.append(", ");
            }
            label.append(")");
        }
        return label.toString();
    }

    public String computeLabel(EEnumLiteral enumLiteral) {
        StringBuilder label = new StringBuilder();
        label.append(enumLiteral.getName());
        return label.toString();
    }

    protected void save(String content) throws IOException {
        OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(this.currentArtifactURI, null);
        outputStream.write(content.getBytes("UTF-8"));
        outputStream.close();
    }
}

