/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FeatureKindSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private CCombo featureKindCb;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.featureKindCb = this.getWidgetFactory().createCCombo(composite, 0x800808);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.featureKindCb, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.featureKindCb.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.featureKindCb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureKindSection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing) {
            final int newFeatureKind = this.getIndex(this.featureKindCb.getText());
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                int oldFeatureKind = ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)this.getEObject());
                if (oldFeatureKind != newFeatureKind) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)FeatureKindSection.this.getEObject(), newFeatureKind);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    int oldFeatureKind = ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)nextObject);
                    if (oldFeatureKind == newFeatureKind) continue;
                    compoundCommand.append((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)nextObject, newFeatureKind);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.featureKindCb.setItems(ExtendedMetaData.FEATURE_KINDS);
        int featureKind = ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)this.getEObject());
        this.featureKindCb.setText(ExtendedMetaData.FEATURE_KINDS[featureKind]);
        this.isRefreshing = false;
    }

    private int getIndex(String key) {
        String[] contentKinds = ExtendedMetaData.FEATURE_KINDS;
        int i = 0;
        while (i < contentKinds.length) {
            if (contentKinds[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.FeatureKindSection_FeatureKind;
    }
}

