/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TotalDigitsSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text digitsTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.digitsTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.digitsTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.digitsTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                TotalDigitsSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.digitsTxt);
        listener.startListeningForEnter((Control)this.digitsTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            try {
                if (this.digitsTxt.getText() == null || this.digitsTxt.getText().length() == 0) {
                    this.digitsTxt.setText("-1");
                }
                final int newDigits = Integer.parseInt(this.digitsTxt.getText());
                EditingDomain editingDomain = this.getEditingDomain();
                if (this.getEObjectList().size() == 1) {
                    int oldDigits = ExtendedMetaData.INSTANCE.getTotalDigitsFacet((EDataType)this.getEObject());
                    if (oldDigits != newDigits) {
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setTotalDigitsFacet((EDataType)TotalDigitsSection.this.getEObject(), newDigits);
                            }
                        });
                    }
                } else {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (final EObject nextObject : this.getEObjectList()) {
                        int oldDigits = ExtendedMetaData.INSTANCE.getTotalDigitsFacet((EDataType)nextObject);
                        if (oldDigits == newDigits) continue;
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setTotalDigitsFacet((EDataType)nextObject, newDigits);
                            }
                        });
                    }
                    editingDomain.getCommandStack().execute((Command)compoundCommand);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.digitsTxt.setText("" + ExtendedMetaData.INSTANCE.getTotalDigitsFacet((EDataType)this.getEObject()));
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.TotalDigitsSection_TotalDigits;
    }
}

