/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringHelper;

public class BufferImpl {
    public static final int HEX_MODE = 1;
    public static final int UTF8_MODE = 2;
    public static final int FLAT_MODE = 3;
    protected ByteBuffer byteBuffer;
    private static transient int COUNTER;
    private transient int id = ++COUNTER;

    public BufferImpl(int size) {
        this.byteBuffer = ByteBuffer.allocateDirect(size);
    }

    public int capacity() {
        return this.byteBuffer.capacity();
    }

    public Buffer clear() {
        return this.byteBuffer.clear();
    }

    public Buffer flip() {
        return this.byteBuffer.flip();
    }

    public byte get() {
        return this.byteBuffer.get();
    }

    public ByteBuffer get(byte[] arg0) {
        return this.byteBuffer.get(arg0);
    }

    public ByteBuffer get(byte[] arg0, int arg1, int arg2) {
        return this.byteBuffer.get(arg0, arg1, arg2);
    }

    public char getChar() {
        return this.byteBuffer.getChar();
    }

    public double getDouble() {
        return this.byteBuffer.getDouble();
    }

    public float getFloat() {
        return this.byteBuffer.getFloat();
    }

    public int getInt() {
        return this.byteBuffer.getInt();
    }

    public long getLong() {
        return this.byteBuffer.getLong();
    }

    public short getShort() {
        return this.byteBuffer.getShort();
    }

    public boolean hasRemaining() {
        return this.byteBuffer.hasRemaining();
    }

    public int limit() {
        return this.byteBuffer.limit();
    }

    public void limit(int newLimit) {
        this.byteBuffer.limit(newLimit);
    }

    public Buffer mark() {
        return this.byteBuffer.mark();
    }

    public int position() {
        return this.byteBuffer.position();
    }

    public void position(int newPosition) {
        this.byteBuffer.position(newPosition);
    }

    public ByteBuffer put(byte arg0) {
        return this.byteBuffer.put(arg0);
    }

    public ByteBuffer put(byte[] arg0) {
        return this.byteBuffer.put(arg0);
    }

    public ByteBuffer put(byte[] arg0, int arg1, int arg2) {
        return this.byteBuffer.put(arg0, arg1, arg2);
    }

    public ByteBuffer put(BufferImpl arg0) {
        return this.byteBuffer.put(arg0.getByteBuffer());
    }

    public ByteBuffer putChar(char arg0) {
        return this.byteBuffer.putChar(arg0);
    }

    public ByteBuffer putDouble(double arg0) {
        return this.byteBuffer.putDouble(arg0);
    }

    public ByteBuffer putFloat(float arg0) {
        return this.byteBuffer.putFloat(arg0);
    }

    public ByteBuffer putInt(int arg0) {
        return this.byteBuffer.putInt(arg0);
    }

    public ByteBuffer putLong(long arg0) {
        return this.byteBuffer.putLong(arg0);
    }

    public ByteBuffer putShort(short arg0) {
        return this.byteBuffer.putShort(arg0);
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    public Buffer reset() {
        return this.byteBuffer.reset();
    }

    public Buffer rewind() {
        return this.byteBuffer.rewind();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Buffer[id=");
        buffer.append(this.id);
        buffer.append(" pos=");
        buffer.append(this.byteBuffer.position());
        buffer.append(" lim=");
        buffer.append(this.byteBuffer.limit());
        buffer.append(" cap=");
        buffer.append(this.byteBuffer.capacity());
        buffer.append("]");
        return buffer.toString();
    }

    public String toString(int mode) {
        String result;
        int position = this.byteBuffer.position();
        int limit = this.byteBuffer.limit();
        switch (mode) {
            case 1: {
                result = StringHelper.toHexString((ByteBuffer)this.byteBuffer);
                break;
            }
            case 2: {
                result = StringHelper.toUTF8String((ByteBuffer)this.byteBuffer, (boolean)false);
                break;
            }
            case 3: {
                result = StringHelper.toUTF8String((ByteBuffer)this.byteBuffer, (boolean)false);
                break;
            }
            default: {
                throw new ImplementationError("invalid mode: " + mode);
            }
        }
        this.byteBuffer.position(position);
        this.byteBuffer.limit(limit);
        return result;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public boolean readFrom(SocketChannel socketChannel) throws IOException {
        boolean ok = false;
        try {
            ok = socketChannel.read(this.byteBuffer) != -1;
        }
        catch (ClosedChannelException closedChannelException) {
            ok = false;
        }
        catch (IOException iOException) {
            ok = false;
        }
        return ok;
    }
}

