/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.model;

import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;

public class EvaluationException
extends RuntimeException {
    private static final long serialVersionUID = 542684666287282979L;
    private final String location;

    public EvaluationException(String msg, SyntaxElement element) {
        super(msg);
        this.location = EvaluationException.location(element);
    }

    public EvaluationException(String msg) {
        super(msg);
        this.location = "";
    }

    public EvaluationException(Throwable ex) {
        super(ex);
        this.location = "";
    }

    public EvaluationException(AmbiguousDefinitionException e) {
        super(e.getMessage());
        this.location = this.location(e);
    }

    public EvaluationException(String message, ExpressionHelper expressionHelper) {
        super(message);
        this.location = EvaluationException.location(expressionHelper);
    }

    private String location(AmbiguousDefinitionException e) {
        String fileName = null;
        if (e.getDefinition1() != null) {
            fileName = e.getDefinition1().getOwner().getFullyQualifiedName();
        } else if (e.getDefinition2() != null) {
            fileName = e.getDefinition2().getOwner().getFullyQualifiedName();
        }
        if (fileName != null) {
            return ":in " + fileName;
        }
        return "";
    }

    private static String location(ExpressionHelper expressionHelper) {
        if (expressionHelper == null) {
            return "";
        }
        return ":in " + expressionHelper.getFileName() + ", line " + expressionHelper.getLine();
    }

    private static String location(SyntaxElement element) {
        if (element == null) {
            return "";
        }
        return ":in " + element.getFileName() + ", line " + element.getLine();
    }

    public String getMessage() {
        return String.valueOf(super.getMessage()) + this.location;
    }
}

