/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;

public final class JMergeUtil {
    private JMergeUtil() {
    }

    public static String mergeFileContent(File target, String content, String charset) throws IOException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return content;
        }
        String newContent = content;
        if (target.getName().endsWith(".java")) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
            if (model.canMerge()) {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(content));
                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(target), charset));
                jMerger.merge();
                newContent = jMerger.getTargetCompilationUnit().getContents();
            }
        }
        return newContent;
    }

    public static String mergeContent(File target, String content, String oldContent) throws IOException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return content;
        }
        String newContent = content;
        if (target.getName().endsWith(".java")) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
            if (model.canMerge()) {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(content));
                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForContents(oldContent));
                jMerger.merge();
                newContent = jMerger.getTargetCompilationUnit().getContents();
            }
        }
        return newContent;
    }
}

