/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.launch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jet.internal.launch.JETProcess;
import org.eclipse.jet.internal.launch.JETStreamsProxy;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class JETConsoleColorProvider
extends ConsoleColorProvider
implements IConsoleColorProvider {
    private Map colors;

    public void connect(IProcess process, IConsole console) {
        this.colors = new HashMap();
        JETProcess jetProcess = (JETProcess)process;
        JETStreamsProxy jetStreamsProxy = (JETStreamsProxy)jetProcess.getStreamsProxy();
        if (jetStreamsProxy != null) {
            if (jetStreamsProxy.getWarningStreamMonitor() != null) {
                console.connect((IStreamMonitor)jetStreamsProxy.getWarningStreamMonitor(), JETStreamsProxy.JET_WARNING_STREAM);
            }
            if (jetStreamsProxy.getTraceStreamMonitor() != null) {
                console.connect((IStreamMonitor)jetStreamsProxy.getTraceStreamMonitor(), JETStreamsProxy.JET_TRACE_STREAM);
            }
            if (jetStreamsProxy.getDebugStreamMonitor() != null) {
                console.connect((IStreamMonitor)jetStreamsProxy.getDebugStreamMonitor(), JETStreamsProxy.JET_DEBUG_STREAM);
            }
        }
        super.connect(process, console);
    }

    public void disconnect() {
        Iterator i = this.colors.values().iterator();
        while (i.hasNext()) {
            Color color = (Color)i.next();
            color.dispose();
        }
        this.colors.clear();
        super.disconnect();
    }

    private Color getPrefColor(String prefKey) {
        Color color = (Color)this.colors.get(prefKey);
        if (color == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)prefKey);
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colors.put(prefKey, color);
        }
        return color;
    }

    public Color getColor(String streamIdentifer) {
        if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM")) {
            return this.getPrefColor("org.eclipse.jet.consoleInfoColor");
        }
        if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM")) {
            return this.getPrefColor("org.eclipse.jet.consoleErrorColor");
        }
        if (streamIdentifer.equals(JETStreamsProxy.JET_DEBUG_STREAM)) {
            return this.getPrefColor("org.eclipse.jet.consoleDebugColor");
        }
        if (streamIdentifer.equals(JETStreamsProxy.JET_TRACE_STREAM)) {
            return this.getPrefColor("org.eclipse.jet.consoleTraceColor");
        }
        if (streamIdentifer.equals(JETStreamsProxy.JET_WARNING_STREAM)) {
            return this.getPrefColor("org.eclipse.jet.consoleWarningColor");
        }
        return super.getColor(streamIdentifer);
    }

    public boolean isReadOnly() {
        return true;
    }
}

